/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience;

import com.google.inject.Inject;
import java.nio.file.Path;
import me.andre111.mambience.MALogger;
import me.andre111.mambience.MAmbience;
import me.andre111.mambience.accessor.AccessorSponge;
import org.slf4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.network.ChannelRegistrationEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.network.ChannelBinding;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.scheduler.Task;

@Plugin(id="mambience", name="MAmbience", version="0.3")
public class MAmbienceSponge {
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path configDir;
    @Inject
    private Logger ilogger;
    @Inject
    private Game game;
    private ChannelBinding.RawDataChannel rawDataChannel;

    @Listener
    public void onServerStart(GameStartedServerEvent event) {
        MAmbience.init(new MALogger(arg_0 -> ((Logger)this.ilogger).info(arg_0), arg_0 -> ((Logger)this.ilogger).error(arg_0)), this.configDir.toFile());
        Task.Builder taskBuilder = Task.builder();
        taskBuilder.execute((Runnable)MAmbience.getScheduler()).async().delayTicks(20L).intervalTicks(20L).submit((Object)this);
        this.rawDataChannel = this.game.getChannelRegistrar().createRawChannel((Object)this, "mambience:server");
    }

    @Listener
    public void onPlayerJoin(ClientConnectionEvent.Join event) {
        Player player = event.getTargetEntity();
        MAmbience.addPlayer(player.getUniqueId(), new AccessorSponge(player.getUniqueId()));
    }

    @Listener
    public void onChannelRegistration(ChannelRegistrationEvent.Register event) {
        if (event.getChannel().equals("mambience:server")) {
            Player player = (Player)event.getCause().first(Player.class).get();
            this.rawDataChannel.sendTo(player, buf -> buf.writeBytes("enabled".getBytes()));
        }
    }

    @Listener
    public void reload(GameReloadEvent event) {
    }
}

