/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.structures.trees;

import com.legacy.blue_skies.blocks.BlocksSkies;
import com.legacy.blue_skies.world.structures.TreePlacer;
import com.legacy.blue_skies.world.structures.trees.LargeDuskTreePieces;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LargeDuskTreeGenerator
extends TreePlacer {
    private static final IBlockState LOG = BlocksSkies.dusk_log.func_176223_P();
    boolean natural;

    public LargeDuskTreeGenerator(boolean notify, boolean natural) {
        super(notify);
        this.natural = natural;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
        if (this.natural) {
            pos = worldIn.func_175725_q(pos);
        }
        if (worldIn.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151577_b || worldIn.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151578_c) {
            int h = rand.nextInt(5) + 10;
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < 2; ++x) {
                    for (int z = 0; z < 2; ++z) {
                        this.setLog(worldIn, pos.func_177982_a(x, y, z), BlockLog.EnumAxis.Y);
                    }
                }
            }
            LargeDuskTreePieces.top.placeBlocks(worldIn, pos.func_177981_b(h));
            LargeDuskTreePieces.top_decay.placeBlocks(worldIn, pos.func_177981_b(h - 1), 0.7f);
            int i = rand.nextInt(4);
            int j = rand.nextInt(2);
            LargeDuskTreePieces.branch.placeBlocks(worldIn, pos.func_177982_a(0, i + 5, -j));
            LargeDuskTreePieces.branch_decay.placeBlocks(worldIn, pos.func_177982_a(0, i + 6, -j), 0.7f);
            i = rand.nextInt(4);
            j = rand.nextInt(2);
            LargeDuskTreePieces.branch.placeBlocks(worldIn, pos.func_177982_a(1 + j, i + 5, 0), Rotation.CLOCKWISE_90);
            LargeDuskTreePieces.branch_decay.placeBlocks(worldIn, pos.func_177982_a(1 + j, i + 6, 0), Rotation.CLOCKWISE_90, 0.7f);
            i = rand.nextInt(4);
            j = rand.nextInt(2);
            LargeDuskTreePieces.branch.placeBlocks(worldIn, pos.func_177982_a(1, i + 5, 1 + j), Rotation.CLOCKWISE_180);
            LargeDuskTreePieces.branch_decay.placeBlocks(worldIn, pos.func_177982_a(1, i + 6, 1 + j), Rotation.CLOCKWISE_180, 0.7f);
            i = rand.nextInt(4);
            j = rand.nextInt(2);
            LargeDuskTreePieces.branch.placeBlocks(worldIn, pos.func_177982_a(-j, i + 5, 1), Rotation.COUNTERCLOCKWISE_90);
            LargeDuskTreePieces.branch_decay.placeBlocks(worldIn, pos.func_177982_a(-j, i + 6, 1), Rotation.COUNTERCLOCKWISE_90, 0.7f);
            for (int x = -1; x <= 2; ++x) {
                for (int z = -1; z <= 2; ++z) {
                    if (!rand.nextBoolean() || !((x == -1 || x == 2) ^ (z == -1 || z == 2))) continue;
                    this.setLog(worldIn, pos.func_177982_a(x, 0, z), BlockLog.EnumAxis.NONE);
                    if (!rand.nextBoolean()) continue;
                    this.setLog(worldIn, pos.func_177982_a(x, 1, z), BlockLog.EnumAxis.NONE);
                    this.setLog(worldIn, pos.func_177982_a(x, 2, z), BlockLog.EnumAxis.NONE);
                    if (!rand.nextBoolean()) continue;
                    this.setLog(worldIn, pos.func_177982_a(x, 3, z), BlockLog.EnumAxis.NONE);
                }
            }
            return true;
        }
        return false;
    }

    protected void setLog(World worldIn, BlockPos pos, BlockLog.EnumAxis axis) {
        if (worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) || worldIn.func_180495_p(pos).func_177230_c() instanceof BlockLeaves) {
            this.func_175903_a(worldIn, pos, LOG.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)axis));
        }
    }

    private void addVine(World worldIn, BlockPos pos, PropertyBool prop) {
        IBlockState iblockstate = BlocksSkies.dusk_vine.func_176223_P().func_177226_a((IProperty)prop, (Comparable)Boolean.valueOf(true));
        this.func_175903_a(worldIn, pos, iblockstate);
        BlockPos blockpos = pos.func_177977_b();
        for (int i = 4; worldIn.func_175623_d(blockpos) && i > 0; --i) {
            this.func_175903_a(worldIn, blockpos, iblockstate);
            blockpos = blockpos.func_177977_b();
        }
    }

    @Override
    public void handleDataMarker(String function, BlockPos pos, World worldIn, Random rand) {
    }
}

