/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.structures.misc;

import com.legacy.blue_skies.entities.villager.EntityVillagerWarrior;
import com.legacy.blue_skies.entities.villager.SkyVillagerProfessionRegistry;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class GateKeeperGenerator
extends WorldGenerator {
    public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
        pos = worldIn.func_175725_q(pos);
        WorldServer worldserver = (WorldServer)worldIn;
        MinecraftServer minecraftserver = worldIn.func_73046_m();
        TemplateManager templatemanager = worldserver.func_184163_y();
        String variant = worldIn.func_180494_b(pos) == Biomes.field_76772_c ? ":gatekeeper/house" : ":gatekeeper/house_snowy";
        Template houseTemplate = templatemanager.func_186237_a(minecraftserver, new ResourceLocation("blue_skies" + variant));
        if (houseTemplate == null) {
            System.out.println("NO STRUCTURE");
            return false;
        }
        if (this.canHouseSpawnHere(houseTemplate, (World)worldserver, pos) && (worldIn.func_180494_b(pos) == Biomes.field_76772_c || worldIn.func_180494_b(pos) == Biomes.field_76770_e || worldIn.func_180494_b(pos) == Biomes.field_76774_n)) {
            IBlockState iblockstate = worldIn.func_180495_p(pos);
            worldIn.func_184138_a(pos, iblockstate, iblockstate, 3);
            BlockPos placementPos = worldIn.func_175725_q(pos).func_177979_c(2);
            PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186226_b(false);
            houseTemplate.func_189962_a(worldIn, placementPos, placementsettings, 3);
            Map map = houseTemplate.func_186258_a(placementPos, placementsettings);
            for (Map.Entry entry : map.entrySet()) {
                String s = (String)entry.getValue();
                this.handleDataMarker(s, (BlockPos)entry.getKey(), worldIn, rand);
            }
            return true;
        }
        return false;
    }

    protected void handleDataMarker(String function, BlockPos pos, World worldIn, Random rand) {
        if (function.startsWith("gatekeeper")) {
            EntityVillager gatekeeper = new EntityVillager(worldIn);
            gatekeeper.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5);
            gatekeeper.setProfession((VillagerRegistry.VillagerProfession)SkyVillagerProfessionRegistry.gatekeeper);
            worldIn.func_72838_d((Entity)gatekeeper);
            worldIn.func_175698_g(pos);
        } else if (function.startsWith("warrior")) {
            EntityVillagerWarrior warrior = new EntityVillagerWarrior(worldIn);
            warrior.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5);
            warrior.setVillagerType(8);
            warrior.func_98053_h(false);
            warrior.field_70173_aa = 5;
            warrior.setArmored(true);
            warrior.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151028_Y));
            warrior.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151030_Z));
            warrior.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151021_T));
            warrior.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
            worldIn.func_72838_d((Entity)warrior);
            worldIn.func_175698_g(pos);
        } else if (function.startsWith("portal")) {
            WorldServer worldserver = (WorldServer)worldIn;
            MinecraftServer minecraftserver = worldIn.func_73046_m();
            TemplateManager templatemanager = worldserver.func_184163_y();
            String variant = rand.nextBoolean() ? ":gatekeeper/everbright_portal" : ":gatekeeper/everdawn_portal";
            Template portalTemplate = templatemanager.func_186237_a(minecraftserver, new ResourceLocation("blue_skies" + variant));
            BlockPos placementPos = worldIn.func_175725_q(pos.func_177982_a(-3, 0, -3));
            PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186226_b(false);
            portalTemplate.func_189962_a(worldIn, placementPos.func_177982_a(0, 0, -2), placementsettings, 3);
            worldIn.func_175656_a(pos, Blocks.field_150349_c.func_176223_P());
        }
    }

    private boolean canHouseSpawnHere(Template template, World worldIn, BlockPos posAboveGround) {
        int zwidth = template.func_186259_a().func_177952_p();
        int xwidth = template.func_186259_a().func_177958_n();
        boolean corner1 = this.isCornerValid(worldIn, posAboveGround);
        boolean corner2 = this.isCornerValid(worldIn, posAboveGround.func_177982_a(xwidth, 0, zwidth));
        boolean corner3 = this.isCornerValid(worldIn, posAboveGround.func_177982_a(0, 0, zwidth));
        boolean corner4 = this.isCornerValid(worldIn, posAboveGround.func_177982_a(xwidth, 0, 0));
        return posAboveGround.func_177956_o() > 50 && corner1 && corner2 && corner3 && corner4;
    }

    private boolean isCornerValid(World worldIn, BlockPos pos) {
        Block block1 = worldIn.func_180495_p(pos.func_177981_b(1)).func_177230_c();
        Block block2 = worldIn.func_180495_p(pos.func_177981_b(2)).func_177230_c();
        Block block3 = worldIn.func_180495_p(pos).func_177230_c();
        return (block1.func_176200_f((IBlockAccess)worldIn, pos.func_177981_b(1)) || block2.func_176200_f((IBlockAccess)worldIn, pos.func_177981_b(2))) && block3 != Blocks.field_150355_j;
    }
}

