/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.structures.blockTemplates;

import com.legacy.blue_skies.world.structures.blockTemplates.BlockWithPos;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLayout {
    private List<BlockWithPos> blocks = new ArrayList<BlockWithPos>();
    private String[][] strings;
    private IBlockState[] states;
    private BlockPos center;
    private Random rand = new Random();

    public BlockLayout(IBlockState[] states, String[][] strings, BlockPos center) {
        this.states = states;
        this.strings = strings;
        this.center = center;
        this.registerBlocks();
    }

    private void registerBlocks() {
        int z = 0;
        int y = 0;
        String[][] stringArray = this.strings;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] s;
            for (String d : s = stringArray[i]) {
                for (int i2 = 0; i2 < d.length(); ++i2) {
                    if (d.charAt(i2) == ' ' || this.getInt(d, i2) >= 10) continue;
                    try {
                        BlockWithPos bwp = new BlockWithPos(this.states[this.getInt(d, i2)], i2, y, z);
                        this.blocks.add(bwp);
                        continue;
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.out.println(e);
                    }
                }
                ++z;
            }
            z = 0;
            ++y;
        }
    }

    public void placeBlocks(World worldIn, BlockPos pos) {
        this.placeBlocks(worldIn, pos, false);
    }

    public void placeBlocks(World worldIn, BlockPos pos, float decay) {
        this.placeBlocks(worldIn, pos, false, decay);
    }

    public void placeBlocks(World worldIn, BlockPos pos, Rotation rot) {
        this.placeBlocks(worldIn, pos, false, rot);
    }

    public void placeBlocks(World worldIn, BlockPos pos, Rotation rot, float decay) {
        this.placeBlocks(worldIn, pos, false, rot, decay);
    }

    public void placeBlocks(World worldIn, BlockPos pos, boolean replaceBlocks) {
        pos = pos.func_177973_b((Vec3i)this.center);
        if (replaceBlocks) {
            for (BlockWithPos b : this.blocks) {
                worldIn.func_175656_a(pos.func_177971_a((Vec3i)b.getPos()), b.getState());
            }
        } else {
            for (BlockWithPos b : this.blocks) {
                BlockPos pos1 = pos.func_177971_a((Vec3i)b.getPos());
                if (!worldIn.func_180495_p(pos1).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos1)) continue;
                worldIn.func_175656_a(pos1, b.getState());
            }
        }
    }

    public void placeBlocks(World worldIn, BlockPos pos, boolean replaceBlocks, Rotation rot) {
        pos = pos.func_177973_b((Vec3i)this.rotatedBlockPos(this.center, rot));
        if (replaceBlocks) {
            for (BlockWithPos b : this.blocks) {
                worldIn.func_175656_a(pos.func_177971_a((Vec3i)this.rotatedBlockPos(b.getPos(), rot)), b.getState().func_185907_a(rot));
            }
        } else {
            for (BlockWithPos b : this.blocks) {
                BlockPos pos1 = pos.func_177971_a((Vec3i)this.rotatedBlockPos(b.getPos(), rot));
                if (!worldIn.func_180495_p(pos1).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos1)) continue;
                worldIn.func_175656_a(pos1, b.getState().func_185907_a(rot));
            }
        }
    }

    public void placeBlocks(World worldIn, BlockPos pos, boolean replaceBlocks, float decay) {
        pos = pos.func_177973_b((Vec3i)this.center);
        if (replaceBlocks) {
            for (BlockWithPos b : this.blocks) {
                if (!(this.rand.nextFloat() > decay)) continue;
                worldIn.func_175656_a(pos.func_177971_a((Vec3i)b.getPos()), b.getState());
            }
        } else {
            for (BlockWithPos b : this.blocks) {
                BlockPos pos1;
                if (!(this.rand.nextFloat() > decay) || !worldIn.func_180495_p(pos1 = pos.func_177971_a((Vec3i)b.getPos())).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos1)) continue;
                worldIn.func_175656_a(pos1, b.getState());
            }
        }
    }

    public void placeBlocks(World worldIn, BlockPos pos, boolean replaceBlocks, Rotation rot, float decay) {
        pos = pos.func_177973_b((Vec3i)this.rotatedBlockPos(this.center, rot));
        if (replaceBlocks) {
            for (BlockWithPos b : this.blocks) {
                if (!(this.rand.nextFloat() > decay)) continue;
                worldIn.func_175656_a(pos.func_177971_a((Vec3i)this.rotatedBlockPos(b.getPos(), rot)), b.getState().func_185907_a(rot));
            }
        } else {
            for (BlockWithPos b : this.blocks) {
                BlockPos pos1;
                if (!(this.rand.nextFloat() > decay) || !worldIn.func_180495_p(pos1 = pos.func_177971_a((Vec3i)this.rotatedBlockPos(b.getPos(), rot))).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos1)) continue;
                worldIn.func_175656_a(pos1, b.getState().func_185907_a(rot));
            }
        }
    }

    private int getInt(String s, int i) {
        try {
            return Integer.parseInt(s.substring(i, i + 1));
        }
        catch (NumberFormatException e) {
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private BlockPos rotatedBlockPos(BlockPos pos, Rotation rotationIn) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        boolean flag = true;
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(k, j, -i);
            }
            case CLOCKWISE_90: {
                return new BlockPos(-k, j, i);
            }
            case CLOCKWISE_180: {
                return new BlockPos(-i, j, -k);
            }
        }
        return flag ? new BlockPos(i, j, k) : pos;
    }
}

