/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.biome.decoration.trees;

import com.legacy.blue_skies.blocks.BlocksSkies;
import com.legacy.blue_skies.blocks.natural.BlockSkyLeaves;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenTrees;

public class WorldGenDuskTree
extends WorldGenTrees {
    private static final IBlockState LOG = BlocksSkies.dusk_log.func_176223_P();
    private static final IBlockState LOGX = BlocksSkies.dusk_log.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X);
    private static final IBlockState LOGZ = BlocksSkies.dusk_log.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z);
    private static final IBlockState LEAF = BlocksSkies.dusk_leaves.func_176223_P().func_177226_a((IProperty)BlockSkyLeaves.field_176237_a, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockSkyLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    private final boolean useExtraRandomHeight;
    private int minTreeHeight;

    public WorldGenDuskTree(boolean notify, boolean useExtraRandomHeightIn, int minTreeHeightIn) {
        super(notify);
        this.minTreeHeight = minTreeHeightIn;
        this.useExtraRandomHeight = useExtraRandomHeightIn;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int i = rand.nextInt(3) + this.minTreeHeight;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= worldIn.func_72800_K()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_72800_K()) {
                            if (this.isReplaceable(worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            IBlockState state = worldIn.func_180495_p(position.func_177977_b());
            if (state.func_185904_a() == Material.field_151578_c || state.func_185904_a() == Material.field_151577_b) {
                this.setLeafCanopy(worldIn, position.func_177982_a(0, i - 2, 0), rand);
                for (int j3 = 0; j3 < i; ++j3) {
                    BlockPos upN = position.func_177981_b(j3);
                    state = worldIn.func_180495_p(upN);
                    if (!state.func_177230_c().isAir(state, (IBlockAccess)worldIn, upN) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, upN)) continue;
                    this.func_175903_a(worldIn, position.func_177981_b(j3), LOG);
                }
                this.setBranches(worldIn, position, rand, i);
                return true;
            }
            return false;
        }
        return false;
    }

    protected void setBranches(World worldIn, BlockPos position, Random rand, int height) {
        int i = height - 3;
        if (rand.nextBoolean()) {
            this.setLog(worldIn, position.func_177982_a(1, i, 0), LOGX);
            this.setLog(worldIn, position.func_177982_a(-1, i, 0), LOGX);
            this.setLog(worldIn, position.func_177982_a(2, i + 1, 0), LOG);
            this.setLog(worldIn, position.func_177982_a(-2, i + 1, 0), LOG);
        } else {
            this.setLog(worldIn, position.func_177982_a(0, i, 1), LOGZ);
            this.setLog(worldIn, position.func_177982_a(0, i, -1), LOGZ);
            this.setLog(worldIn, position.func_177982_a(0, i + 1, 2), LOG);
            this.setLog(worldIn, position.func_177982_a(0, i + 1, -2), LOG);
        }
    }

    protected void setLeafCanopy(World worldIn, BlockPos position, Random rand) {
        int j;
        int i;
        for (i = -3; i <= 3; ++i) {
            for (j = -3; j <= 3; ++j) {
                if (Math.abs(i) == 3 && Math.abs(j) == 3 || rand.nextInt(3) != 0) continue;
                this.setLeaf(worldIn, position.func_177982_a(i, 0, j));
            }
        }
        position = position.func_177984_a();
        for (i = -3; i <= 3; ++i) {
            for (j = -3; j <= 3; ++j) {
                if (Math.abs(i) == 3 && Math.abs(j) == 3) continue;
                this.setLeaf(worldIn, position.func_177982_a(i, 0, j));
            }
        }
        for (i = -4; i <= 4; ++i) {
            for (j = -1; j <= 1; ++j) {
                if (Math.abs(i) != 4) continue;
                this.setLeaf(worldIn, position.func_177982_a(i, 0, j));
                this.setLeaf(worldIn, position.func_177982_a(j, 0, i));
            }
        }
        position = position.func_177984_a();
        for (i = -2; i <= 2; ++i) {
            for (j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                this.setLeaf(worldIn, position.func_177982_a(i, 0, j));
            }
        }
    }

    protected void setLeaf(World worldIn, BlockPos position) {
        IBlockState state = worldIn.func_180495_p(position);
        if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, position) || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, position) || state.func_185904_a() == Material.field_151582_l) {
            this.func_175903_a(worldIn, position, LEAF);
        }
    }

    protected void setLog(World worldIn, BlockPos position, IBlockState log) {
        if (this.isReplaceable(worldIn, position)) {
            this.func_175903_a(worldIn, position, log);
        }
    }

    protected boolean func_150523_a(Block blockType) {
        Material material = blockType.func_176223_P().func_185904_a();
        return material == Material.field_151579_a || material == Material.field_151577_b || material == Material.field_151578_c || material == Material.field_151585_k || blockType instanceof BlockBush;
    }
}

