/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn;

import com.legacy.blue_skies.blocks.BlocksSkies;
import com.legacy.blue_skies.blocks.natural.BlockSkyRoot;
import com.legacy.blue_skies.world.everdawn.gen.village.MapGenEverdawnVillage;
import com.legacy.blue_skies.world.gen.MapGenSkyCaves;
import com.legacy.blue_skies.world.gen.MapGenSkyRavine;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class ChunkGeneratorEverdawn
implements IChunkGenerator {
    public World world;
    public Random random;
    protected ChunkPos chunkPos;
    private NoiseGeneratorOctaves minLimitPerlinNoise;
    private NoiseGeneratorOctaves maxLimitPerlinNoise;
    private NoiseGeneratorOctaves mainPerlinNoise;
    private NoiseGeneratorPerlin surfaceNoise;
    public NoiseGeneratorOctaves scaleNoise;
    public NoiseGeneratorOctaves depthNoise;
    private double[] stoneNoise = new double[256];
    private WorldType terrainType;
    private final double[] heightMap;
    private final float[] biomeWeights;
    double[] noise3;
    double[] noise1;
    double[] noise2;
    double[] noise5;
    double[] noise6;
    float[] parabolicField;
    int[][] field_73219_j = new int[32][32];
    private Biome[] biomesForGeneration;
    double[] mainNoiseRegion;
    double[] minLimitRegion;
    double[] maxLimitRegion;
    double[] depthRegion;
    private MapGenBase caveGenerator = new MapGenSkyCaves();
    private MapGenBase ravineGenerator = new MapGenSkyRavine();
    protected MapGenVillage villageGenerator = new MapGenEverdawnVillage();
    private boolean useVillages = true;
    protected boolean mapFeaturesEnabled = true;

    public ChunkGeneratorEverdawn(World world, long seed) {
        this.random = new Random(seed);
        this.world = world;
        this.minLimitPerlinNoise = new NoiseGeneratorOctaves(this.random, 16);
        this.maxLimitPerlinNoise = new NoiseGeneratorOctaves(this.random, 16);
        this.mainPerlinNoise = new NoiseGeneratorOctaves(this.random, 8);
        this.surfaceNoise = new NoiseGeneratorPerlin(this.random, 4);
        this.scaleNoise = new NoiseGeneratorOctaves(this.random, 10);
        this.depthNoise = new NoiseGeneratorOctaves(this.random, 16);
        this.heightMap = new double[825];
        this.biomeWeights = new float[25];
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.ravineGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.caveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)this.villageGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.mapFeaturesEnabled = world.func_72912_H().func_76089_r();
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float f;
                this.biomeWeights[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
            }
        }
    }

    protected void postTerrainGenEvents() {
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)this.villageGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
    }

    public void generateTerrain(int x, int z, ChunkPrimer primer) {
        this.biomesForGeneration = this.world.func_72959_q().func_76937_a(this.biomesForGeneration, x * 4 - 2, z * 4 - 2, 10, 10);
        this.generateHeightmap(x * 4, 0, z * 4);
        for (int i = 0; i < 4; ++i) {
            int j = i * 5;
            int k = (i + 1) * 5;
            for (int l = 0; l < 4; ++l) {
                int i1 = (j + l) * 33;
                int j1 = (j + l + 1) * 33;
                int k1 = (k + l) * 33;
                int l1 = (k + l + 1) * 33;
                for (int i2 = 0; i2 < 32; ++i2) {
                    double d1 = this.heightMap[i1 + i2];
                    double d2 = this.heightMap[j1 + i2];
                    double d3 = this.heightMap[k1 + i2];
                    double d4 = this.heightMap[l1 + i2];
                    double d5 = (this.heightMap[i1 + i2 + 1] - d1) * 0.125;
                    double d6 = (this.heightMap[j1 + i2 + 1] - d2) * 0.125;
                    double d7 = (this.heightMap[k1 + i2 + 1] - d3) * 0.125;
                    double d8 = (this.heightMap[l1 + i2 + 1] - d4) * 0.125;
                    for (int j2 = 0; j2 < 8; ++j2) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        for (int k2 = 0; k2 < 4; ++k2) {
                            double d16 = (d11 - d10) * 0.25;
                            double lvt_45_1_ = d10 - d16;
                            for (int l2 = 0; l2 < 4; ++l2) {
                                double d;
                                lvt_45_1_ += d16;
                                if (!(d > 0.0)) continue;
                                primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, BlocksSkies.lunar_stone.func_176223_P());
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void generateHeightmap(int chunkX, int zero, int chunkZ) {
        this.depthRegion = this.depthNoise.func_76305_a(this.depthRegion, chunkX, chunkZ, 5, 5, 200.0, 200.0, 0.5);
        this.mainNoiseRegion = this.mainPerlinNoise.func_76304_a(this.mainNoiseRegion, chunkX, zero, chunkZ, 5, 33, 5, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        this.minLimitRegion = this.minLimitPerlinNoise.func_76304_a(this.minLimitRegion, chunkX, zero, chunkZ, 5, 33, 5, 684.412, 684.412, 684.412);
        this.maxLimitRegion = this.maxLimitPerlinNoise.func_76304_a(this.maxLimitRegion, chunkX, zero, chunkZ, 5, 33, 5, 684.412, 684.412, 684.412);
        int terrainIndex = 0;
        int noiseIndex = 0;
        for (int ax = 0; ax < 5; ++ax) {
            for (int az = 0; az < 5; ++az) {
                float totalVariation = 0.0f;
                float totalHeight = 0.0f;
                float totalFactor = 0.0f;
                int two = 2;
                Biome biomegenbase = this.biomesForGeneration[ax + 2 + (az + 2) * 10];
                for (int ox = -two; ox <= two; ++ox) {
                    for (int oz = -two; oz <= two; ++oz) {
                        Biome biomegenbase1 = this.biomesForGeneration[ax + ox + 2 + (az + oz + 2) * 10];
                        float rootHeight = biomegenbase1.func_185355_j();
                        float heightVariation = biomegenbase1.func_185360_m();
                        if (this.terrainType == WorldType.field_151360_e && rootHeight > 0.0f) {
                            rootHeight = 1.0f + rootHeight * 2.0f;
                            heightVariation = 1.0f + heightVariation * 4.0f;
                        }
                        float heightFactor = this.biomeWeights[ox + 2 + (oz + 2) * 5] / (rootHeight + 2.0f);
                        if (biomegenbase1.func_185355_j() > biomegenbase.func_185355_j()) {
                            heightFactor /= 2.0f;
                        }
                        totalVariation += heightVariation * heightFactor;
                        totalHeight += rootHeight * heightFactor;
                        totalFactor += heightFactor;
                    }
                }
                totalVariation /= totalFactor;
                totalHeight /= totalFactor;
                totalVariation = totalVariation * 0.9f + 0.1f;
                totalHeight = (totalHeight * 4.0f - 1.0f) / 8.0f;
                double terrainNoise = this.depthRegion[noiseIndex] / 8000.0;
                if (terrainNoise < 0.0) {
                    terrainNoise = -terrainNoise * 0.3;
                }
                if ((terrainNoise = terrainNoise * 3.0 - 2.0) < 0.0) {
                    if ((terrainNoise /= 2.0) < -1.0) {
                        terrainNoise = -1.0;
                    }
                    terrainNoise /= 1.4;
                    terrainNoise /= 2.0;
                } else {
                    if (terrainNoise > 1.0) {
                        terrainNoise = 1.0;
                    }
                    terrainNoise /= 8.0;
                }
                ++noiseIndex;
                double heightCalc = totalHeight;
                double variationCalc = totalVariation;
                heightCalc += terrainNoise * 0.2;
                heightCalc = heightCalc * 8.5 / 8.0;
                double d5 = 8.5 + heightCalc * 4.0;
                for (int ay = 0; ay < 33; ++ay) {
                    double d6 = ((double)ay - d5) * 12.0 * 128.0 / 256.0 / variationCalc;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = this.minLimitRegion[terrainIndex] / 512.0;
                    double d8 = this.maxLimitRegion[terrainIndex] / 512.0;
                    double d9 = (this.mainNoiseRegion[terrainIndex] / 10.0 + 1.0) / 2.0;
                    double terrainCalc = MathHelper.func_151238_b((double)d7, (double)d8, (double)d9) - d6;
                    if (ay > 29) {
                        double d11 = (float)(ay - 29) / 3.0f;
                        terrainCalc = terrainCalc * (1.0 - d11) + -10.0 * d11;
                    }
                    this.heightMap[terrainIndex] = terrainCalc;
                    ++terrainIndex;
                }
            }
        }
    }

    public void replaceBlocksForBiome(int x, int z, ChunkPrimer chunkPrimer) {
        this.stoneNoise = this.surfaceNoise.func_151599_a(this.stoneNoise, (double)(x * 16), (double)(z * 16), 16, 16, 0.0625, 0.0625, 1.0);
        for (int varX = 15; varX > -1; --varX) {
            for (int varZ = 15; varZ > -1; --varZ) {
                Biome biome = this.biomesForGeneration[varX + varZ * 16];
                int var12 = (int)(this.stoneNoise[varX + varZ * 16] / 3.0 + 3.0 + this.random.nextDouble() * 0.25);
                int var13 = -1;
                IBlockState topBlock = biome.field_76752_A;
                IBlockState fillerBlock = biome.field_76753_B;
                for (int varY = 255; varY >= 0; --varY) {
                    if (varY <= 0 + this.random.nextInt(5)) {
                        chunkPrimer.func_177855_a(varX, varY, varZ, Blocks.field_150357_h.func_176223_P());
                        continue;
                    }
                    IBlockState var18 = chunkPrimer.func_177856_a(varX, varY, varZ);
                    if (var18.func_177230_c() == Blocks.field_150350_a) {
                        var13 = -1;
                        continue;
                    }
                    if (var18.func_177230_c() != BlocksSkies.lunar_stone) continue;
                    if (var13 == -1) {
                        var13 = var12;
                        chunkPrimer.func_177855_a(varX, varY + 1, varZ, topBlock);
                        chunkPrimer.func_177855_a(varX, varY, varZ, fillerBlock);
                    }
                    if (var13 <= 0) continue;
                    chunkPrimer.func_177855_a(varX, varY, varZ, fillerBlock);
                    --var13;
                }
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer primer = new ChunkPrimer();
        this.generateTerrain(x, z, primer);
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.replaceBlocksForBiome(x, z, primer);
        this.caveGenerator.func_186125_a(this.world, x, z, primer);
        this.ravineGenerator.func_186125_a(this.world, x, z, primer);
        if (this.mapFeaturesEnabled) {
            this.villageGenerator.func_186125_a(this.world, x, z, primer);
        }
        Chunk chunk = new Chunk(this.world, primer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int x, int z) {
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        this.random.setSeed(this.world.func_72905_C());
        long k = this.random.nextLong() / 2L * 2L + 1L;
        long l = this.random.nextLong() / 2L * 2L + 1L;
        this.random.setSeed((long)x * k + (long)z * l ^ this.world.func_72905_C());
        this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16)).func_180624_a(this.world, this.random, new BlockPos(i, 0, j));
        if (this.mapFeaturesEnabled) {
            this.villageGenerator.func_175794_a(this.world, this.random, new ChunkPos(x, z));
        }
        BlockFalling.field_149832_M = false;
        BlockSkyRoot.generate(i, j, this.world, BlocksSkies.igneous_root.func_176223_P(), this.random);
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return true;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.world.func_180494_b(pos);
        return biome.func_76747_a(creatureType);
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
        if (this.useVillages) {
            this.villageGenerator.func_186125_a(this.world, x, z, (ChunkPrimer)null);
        }
    }

    private boolean generateMapFeatures() {
        boolean villageHasGenerated = false;
        if (this.useVillages) {
            villageHasGenerated = this.villageGenerator.func_175794_a(this.world, this.random, this.chunkPos);
        }
        return villageHasGenerated;
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        if (!this.mapFeaturesEnabled) {
            return null;
        }
        return "Village".equals(structureName) && this.villageGenerator != null ? this.villageGenerator.func_180706_b(worldIn, position, findUnexplored) : null;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        if (!this.mapFeaturesEnabled) {
            return false;
        }
        return "Village".equals(structureName) && this.villageGenerator != null ? this.villageGenerator.func_175795_b(pos) : false;
    }
}

