/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.biome.decoration.trees;

import com.legacy.blue_skies.blocks.BlocksSkies;
import com.legacy.blue_skies.blocks.natural.BlockSkyLeaves;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class WorldGenPaleSwampTree
extends WorldGenAbstractTree {
    private static final IBlockState LOG = BlocksSkies.bluebright_log.func_176223_P();
    private static final IBlockState LEAF = BlocksSkies.bluebright_leaves.func_176223_P().func_177226_a((IProperty)BlockSkyLeaves.field_176237_a, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockSkyLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));

    public WorldGenPaleSwampTree() {
        super(false);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int i = rand.nextInt(4) + 5;
        while (worldIn.func_180495_p(position.func_177977_b()).func_185904_a() == Material.field_151586_h) {
            position = position.func_177977_b();
        }
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= 256) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 3;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < 256) {
                            IBlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1));
                            Block block = iblockstate.func_177230_c();
                            if (iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1)) || iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            if (block != Blocks.field_150355_j && block != Blocks.field_150358_i) {
                                flag = false;
                                continue;
                            }
                            if (j <= position.func_177956_o()) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = position.func_177977_b();
            IBlockState state = worldIn.func_180495_p(down);
            boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && position.func_177956_o() < worldIn.func_72800_K() - i - 1) {
                state.func_177230_c().onPlantGrow(state, worldIn, position.func_177977_b(), position);
                this.setLeaves(worldIn, position.func_177981_b(i), rand);
                for (int l1 = 0; l1 < i + 2; ++l1) {
                    BlockPos upN = position.func_177981_b(l1);
                    IBlockState iblockstate1 = worldIn.func_180495_p(upN);
                    Block block2 = iblockstate1.func_177230_c();
                    if (!block2.isAir(iblockstate1, (IBlockAccess)worldIn, upN) && !block2.isLeaves(iblockstate1, (IBlockAccess)worldIn, upN) && block2 != Blocks.field_150358_i && block2 != Blocks.field_150355_j) continue;
                    if (l1 > i - 3) {
                        this.setLog(worldIn, position.func_177981_b(l1), LOG);
                        if (l1 == i - 1) {
                            this.setLog(worldIn, position.func_177982_a(1, l1, 0), LOG.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X));
                            this.setLog(worldIn, position.func_177982_a(-1, l1, 0), LOG.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X));
                            this.setLog(worldIn, position.func_177982_a(0, l1, 1), LOG.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z));
                            this.setLog(worldIn, position.func_177982_a(0, l1, -1), LOG.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z));
                        }
                    }
                    if (l1 != 1) continue;
                    this.setBaseLogs(worldIn, position);
                }
                for (int i2 = position.func_177956_o() - 3 + i; i2 <= position.func_177956_o() + i; ++i2) {
                    int k2 = i2 - (position.func_177956_o() + i);
                    int i3 = 2 - k2 / 2;
                    BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
                    for (int l3 = position.func_177958_n() - i3; l3 <= position.func_177958_n() + i3; ++l3) {
                        for (int j4 = position.func_177952_p() - i3; j4 <= position.func_177952_p() + i3; ++j4) {
                            blockpos$mutableblockpos1.func_181079_c(l3, i2, j4);
                            if (worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos1).func_185904_a() != Material.field_151584_j) continue;
                            BlockPos blockpos3 = blockpos$mutableblockpos1.func_177976_e();
                            BlockPos blockpos4 = blockpos$mutableblockpos1.func_177974_f();
                            BlockPos blockpos1 = blockpos$mutableblockpos1.func_177978_c();
                            BlockPos blockpos2 = blockpos$mutableblockpos1.func_177968_d();
                            if (rand.nextInt(4) == 0 && worldIn.func_175623_d(blockpos3)) {
                                this.addVine(worldIn, blockpos3, BlockVine.field_176278_M);
                            }
                            if (rand.nextInt(4) == 0 && worldIn.func_175623_d(blockpos4)) {
                                this.addVine(worldIn, blockpos4, BlockVine.field_176280_O);
                            }
                            if (rand.nextInt(4) == 0 && worldIn.func_175623_d(blockpos1)) {
                                this.addVine(worldIn, blockpos1, BlockVine.field_176279_N);
                            }
                            if (rand.nextInt(4) != 0 || !worldIn.func_175623_d(blockpos2)) continue;
                            this.addVine(worldIn, blockpos2, BlockVine.field_176273_b);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected void setLeaves(World worldIn, BlockPos position, Random rand) {
        int k;
        int j;
        int i;
        for (i = -4; i <= 4; ++i) {
            for (j = -2; j <= 2; ++j) {
                for (k = -1; k <= 0; ++k) {
                    this.setLeaf(worldIn, position.func_177982_a(i, k, j));
                    this.setLeaf(worldIn, position.func_177982_a(j, k, i));
                }
            }
        }
        for (int k2 = -1; k2 <= 0; ++k2) {
            this.setLeaf(worldIn, position.func_177982_a(3, k2, 3));
            this.setLeaf(worldIn, position.func_177982_a(3, k2, -3));
            this.setLeaf(worldIn, position.func_177982_a(-3, k2, 3));
            this.setLeaf(worldIn, position.func_177982_a(-3, k2, -3));
        }
        for (i = -3; i <= 3; ++i) {
            for (j = -3; j <= 3; ++j) {
                for (k = 1; k <= 2; ++k) {
                    if (Math.abs(i) == 3 && Math.abs(j) == 3) continue;
                    this.setLeaf(worldIn, position.func_177982_a(i, k, j));
                    this.setLeaf(worldIn, position.func_177982_a(j, k, i));
                }
            }
        }
        for (i = -2; i <= 2; ++i) {
            for (j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                this.setLeaf(worldIn, position.func_177982_a(i, 3, j));
                this.setLeaf(worldIn, position.func_177982_a(j, 3, i));
            }
        }
        for (i = -3; i <= 3; ++i) {
            for (j = -3; j <= 3; ++j) {
                if (rand.nextInt(5) == 0) {
                    this.setLeaf(worldIn, position.func_177982_a(i, -2, j));
                }
                if (rand.nextInt(5) != 0) continue;
                this.setLeaf(worldIn, position.func_177982_a(i, -2, j));
                this.setLeaf(worldIn, position.func_177982_a(i, -3, j));
            }
        }
        position = position.func_177984_a();
        this.setLeaf(worldIn, position.func_177964_d(4));
        this.setLeaf(worldIn, position.func_177970_e(4));
        this.setLeaf(worldIn, position.func_177965_g(4));
        this.setLeaf(worldIn, position.func_177985_f(4));
    }

    protected void setBaseLogs(World worldIn, BlockPos position) {
        int i;
        for (i = -3; i <= 1; ++i) {
            this.setLog(worldIn, position.func_177982_a(2, i, 0), LOG);
            this.setLog(worldIn, position.func_177982_a(-2, i, 0), LOG);
            this.setLog(worldIn, position.func_177982_a(0, i, 2), LOG);
            this.setLog(worldIn, position.func_177982_a(0, i, -2), LOG);
        }
        position = position.func_177981_b(2);
        this.setLog(worldIn, position.func_177978_c(), LOG);
        this.setLog(worldIn, position.func_177968_d(), LOG);
        this.setLog(worldIn, position.func_177974_f(), LOG);
        this.setLog(worldIn, position.func_177976_e(), LOG);
        for (i = 0; i <= 3; ++i) {
            this.setLog(worldIn, position.func_177981_b(i), LOG);
        }
    }

    protected void setLeaf(World worldIn, BlockPos position) {
        IBlockState state = worldIn.func_180495_p(position);
        if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, position) || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, position) || state.func_185904_a() == Material.field_151582_l) {
            this.func_175903_a(worldIn, position, LEAF);
        }
    }

    protected void setLog(World worldIn, BlockPos position, IBlockState log) {
        if (this.isReplaceable(worldIn, position)) {
            this.func_175903_a(worldIn, position, log);
        }
    }

    private void addVine(World worldIn, BlockPos pos, PropertyBool prop) {
        IBlockState iblockstate = BlocksSkies.bluebright_vine.func_176223_P().func_177226_a((IProperty)prop, (Comparable)Boolean.valueOf(true));
        this.func_175903_a(worldIn, pos, iblockstate);
        BlockPos blockpos = pos.func_177977_b();
        for (int i = 4; worldIn.func_175623_d(blockpos) && i > 0; --i) {
            this.func_175903_a(worldIn, blockpos, iblockstate);
            blockpos = blockpos.func_177977_b();
        }
    }

    protected boolean func_150523_a(Block blockType) {
        Material material = blockType.func_176223_P().func_185904_a();
        return material == Material.field_151579_a || material == Material.field_151577_b || material == Material.field_151578_c || material == Material.field_151585_k || blockType instanceof BlockBush || material == Material.field_151586_h;
    }
}

