/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items;

import com.legacy.blue_skies.creative_tabs.SkiesTabs;
import com.legacy.blue_skies.items.ItemsSkies;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;

public class ItemSkyBucket
extends Item {
    public ItemSkyBucket() {
        this.func_77627_a(true);
        this.func_77642_a(this);
        this.func_77637_a(SkiesTabs.TAB_TOOLS);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (int meta = 0; meta < EnumFluids.values().length; ++meta) {
                subItems.add((Object)new ItemStack((Item)this, 1, meta));
            }
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        return stack.func_77952_i() == 0 ? 16 : 1;
    }

    public String func_77667_c(ItemStack itemstack) {
        return "item." + EnumFluids.getType(itemstack.func_77952_i()).getName();
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        BlockPos blockpos1;
        ItemStack heldItem = player.func_184586_b(hand);
        int meta = heldItem.func_77952_i();
        if (EnumFluids.getType(meta) == EnumFluids.MILK) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.PASS, (Object)heldItem);
        }
        boolean isEmpty = EnumFluids.getType(meta) == EnumFluids.AIR;
        RayTraceResult movingobjectposition = this.func_77621_a(world, player, isEmpty);
        ActionResult ret = ForgeEventFactory.onBucketUse((EntityPlayer)player, (World)world, (ItemStack)heldItem, (RayTraceResult)movingobjectposition);
        if (ret != null) {
            return ret;
        }
        if (movingobjectposition == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)heldItem);
        }
        if (movingobjectposition.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)heldItem);
        }
        BlockPos blockpos = movingobjectposition.func_178782_a();
        if (!world.func_175660_a(player, blockpos)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)heldItem);
        }
        if (isEmpty) {
            if (!player.func_175151_a(blockpos.func_177972_a(movingobjectposition.field_178784_b), movingobjectposition.field_178784_b, heldItem)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)heldItem);
            }
            IBlockState iblockstate = world.func_180495_p(blockpos);
            Material material = iblockstate.func_185904_a();
            if (material == Material.field_151586_h && (Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 11);
                player.func_71029_a(StatList.func_188057_b((Item)this));
                player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)this.fillBucket(heldItem, player, new ItemStack(ItemsSkies.ventium_bucket, 1, 1)));
            }
            if (material == Material.field_151587_i && (Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 11);
                player.func_71029_a(StatList.func_188057_b((Item)this));
                player.func_184185_a(SoundEvents.field_187633_N, 1.0f, 1.0f);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)this.fillBucket(heldItem, player, new ItemStack(ItemsSkies.ventium_bucket, 1, 2)));
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)heldItem);
        }
        boolean flag1 = world.func_180495_p(blockpos).func_177230_c().func_176200_f((IBlockAccess)world, blockpos);
        BlockPos blockPos = blockpos1 = flag1 && movingobjectposition.field_178784_b == EnumFacing.UP ? blockpos : blockpos.func_177972_a(movingobjectposition.field_178784_b);
        if (!player.func_175151_a(blockpos1, movingobjectposition.field_178784_b, heldItem)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)heldItem);
        }
        if (this.tryPlaceContainedLiquid(player, world, heldItem, blockpos1)) {
            player.func_71029_a(StatList.func_188057_b((Item)this));
            return !player.field_71075_bZ.field_75098_d ? new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack(ItemsSkies.ventium_bucket)) : new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)heldItem);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150383_bp) {
            IBlockState cauldron = worldIn.func_180495_p(pos);
            if (playerIn.func_184586_b(hand).func_77952_i() == 1) {
                if ((Integer)cauldron.func_177229_b((IProperty)BlockCauldron.field_176591_a) < 3) {
                    if (!playerIn.field_71075_bZ.field_75098_d) {
                        playerIn.func_184611_a(hand, new ItemStack(ItemsSkies.ventium_bucket));
                    }
                    playerIn.func_71029_a(StatList.field_188077_K);
                    worldIn.func_175656_a(pos, cauldron.func_177226_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf(3)));
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return EnumActionResult.SUCCESS;
                }
            } else if (playerIn.func_184586_b(hand).func_77952_i() == 0) {
                if ((Integer)cauldron.func_177229_b((IProperty)BlockCauldron.field_176591_a) == 3) {
                    if (!playerIn.field_71075_bZ.field_75098_d) {
                        ItemStack emptyBuckets = playerIn.func_184586_b(hand);
                        ItemStack fullBucket = new ItemStack(ItemsSkies.ventium_bucket, 1, 1);
                        emptyBuckets.func_190918_g(1);
                        if (emptyBuckets.func_190916_E() <= 0) {
                            playerIn.func_184611_a(hand, fullBucket);
                        } else if (!playerIn.field_71071_by.func_70441_a(fullBucket)) {
                            playerIn.func_71019_a(fullBucket, false);
                        }
                    }
                    playerIn.func_71029_a(StatList.field_188078_L);
                    worldIn.func_175656_a(pos, cauldron.func_177226_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf(0)));
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return EnumActionResult.SUCCESS;
                }
            } else {
                return EnumActionResult.FAIL;
            }
        }
        return EnumActionResult.FAIL;
    }

    private ItemStack fillBucket(ItemStack emptyBuckets, EntityPlayer player, ItemStack fullBucket) {
        if (player.field_71075_bZ.field_75098_d) {
            return emptyBuckets;
        }
        emptyBuckets.func_190918_g(1);
        if (emptyBuckets.func_190916_E() <= 0) {
            return fullBucket;
        }
        if (!player.field_71071_by.func_70441_a(fullBucket)) {
            player.func_71019_a(fullBucket, false);
        }
        return emptyBuckets;
    }

    public boolean tryPlaceContainedLiquid(EntityPlayer player, World world, ItemStack stack, BlockPos pos) {
        boolean flag;
        if (EnumFluids.getType(stack.func_77952_i()) == EnumFluids.AIR || EnumFluids.getType(stack.func_77952_i()) == EnumFluids.MILK) {
            return false;
        }
        Material material = world.func_180495_p(pos).func_185904_a();
        boolean bl = flag = !material.func_76220_a();
        if (!world.func_175623_d(pos) && !flag) {
            return false;
        }
        if (world.field_73011_w.func_177500_n()) {
            world.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            if (!world.field_72995_K && flag && !material.func_76224_d()) {
                world.func_180495_p(pos).func_177230_c().func_180663_b(world, pos, world.func_180495_p(pos));
            }
            player.func_184185_a(SoundEvents.field_187624_K, 1.0f, 1.0f);
            world.func_180501_a(pos, EnumFluids.getFluid(this.getDamage(stack)).func_176223_P(), 11);
        }
        return true;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            return this.onBucketUsed(stack, worldIn, (EntityPlayer)entityLiving);
        }
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public ItemStack onBucketUsed(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        int meta = itemstack.func_77952_i();
        if (!entityplayer.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
        }
        if (EnumFluids.getType(meta) == EnumFluids.MILK && !world.field_72995_K) {
            entityplayer.curePotionEffects(new ItemStack(Items.field_151117_aB));
        }
        return itemstack.func_190916_E() <= 0 ? new ItemStack((Item)this, 1, 0) : itemstack;
    }

    public int func_77626_a(ItemStack itemstack) {
        int meta = itemstack.func_77952_i();
        if (EnumFluids.getType(meta) == EnumFluids.MILK) {
            return 32;
        }
        return 0;
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        int meta = itemstack.func_77952_i();
        if (EnumFluids.getType(meta) == EnumFluids.MILK) {
            return EnumAction.DRINK;
        }
        return EnumAction.NONE;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        String name = EntityList.func_75621_b((Entity)target);
        if (name != null && (target instanceof EntityCow && !((EntityCow)target).func_70631_g_() || name.toLowerCase().contains("cow"))) {
            if (target.field_70170_p.field_72995_K) {
                playerIn.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
                return false;
            }
            if (EnumFluids.getType(stack.func_77952_i()) == EnumFluids.AIR && !playerIn.field_71075_bZ.field_75098_d && !((EntityCow)target).func_70631_g_()) {
                if (stack.func_190916_E() == 1) {
                    playerIn.func_184611_a(hand, new ItemStack(ItemsSkies.ventium_bucket, 1, 3));
                }
                if (stack.func_190916_E() > 1) {
                    stack.func_190918_g(1);
                    if (!playerIn.field_71071_by.func_70441_a(new ItemStack(ItemsSkies.ventium_bucket, 1, 3))) {
                        playerIn.func_71019_a(new ItemStack(ItemsSkies.ventium_bucket, 1, 3), false);
                    }
                }
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidVentiumBucketWrapper(stack);
    }

    public class FluidVentiumBucketWrapper
    extends FluidBucketWrapper {
        public FluidVentiumBucketWrapper(ItemStack container) {
            super(container);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.getFluid() == FluidRegistry.WATER || fluid.getFluid() == FluidRegistry.LAVA;
        }

        @Nullable
        public FluidStack getFluid() {
            Item item = this.container.func_77973_b();
            int meta = this.container.func_77952_i();
            if (item == ItemsSkies.ventium_bucket && meta == 1) {
                return new FluidStack(FluidRegistry.WATER, 1000);
            }
            if (item == ItemsSkies.ventium_bucket && meta == 2) {
                return new FluidStack(FluidRegistry.LAVA, 1000);
            }
            return null;
        }

        protected void setFluid(Fluid fluid) {
            if (fluid == null) {
                this.container.deserializeNBT(new ItemStack(ItemsSkies.ventium_bucket).serializeNBT());
            } else if (fluid == FluidRegistry.WATER) {
                this.container.deserializeNBT(new ItemStack(ItemsSkies.ventium_bucket, 1, 1).serializeNBT());
            } else if (fluid == FluidRegistry.LAVA) {
                this.container.deserializeNBT(new ItemStack(ItemsSkies.ventium_bucket, 1, 2).serializeNBT());
            }
        }
    }

    public static enum EnumFluids {
        AIR(0, "_"),
        WATER(1, (Block)Blocks.field_150358_i, "_water_"),
        LAVA(2, (Block)Blocks.field_150356_k, "_lava_"),
        MILK(3, "_milk_");

        Block fluid;
        int meta;
        String name;

        private EnumFluids(int metaIn, Block fluidIn, String nameIn) {
            this.meta = metaIn;
            this.fluid = fluidIn;
            this.name = nameIn;
        }

        private EnumFluids(int metaIn, String nameIn) {
            this.meta = metaIn;
            this.name = nameIn;
            this.fluid = Blocks.field_150350_a;
        }

        public int getMeta() {
            return this.meta;
        }

        public Block getFluid() {
            return this.fluid;
        }

        public static Block getFluid(int meta) {
            return meta == 0 || meta == 3 ? AIR.getFluid() : (meta == 1 ? WATER.getFluid() : LAVA.getFluid());
        }

        public String getName() {
            return "ventium" + this.name + "bucket";
        }

        public static EnumFluids getType(int meta) {
            return meta == 0 ? AIR : (meta == 1 ? WATER : (meta == 2 ? LAVA : MILK));
        }
    }
}

