/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss;

import com.google.common.base.Predicate;
import com.legacy.blue_skies.blocks.BlocksSkies;
import com.legacy.blue_skies.blocks.dungeon.BlockSkyKeystone;
import com.legacy.blue_skies.client.particle.ParticleBlueFlame;
import com.legacy.blue_skies.client.sounds.SkiesSounds;
import com.legacy.blue_skies.entities.hostile.EntityNyctoBug;
import com.legacy.blue_skies.entities.hostile.boss.summons.EntityArtificialGolem;
import com.legacy.blue_skies.entities.hostile.boss.summons.EntitySummonedLightningBolt;
import com.legacy.blue_skies.entities.passive.EntityStardustRam;
import com.legacy.blue_skies.entities.villager.EntityVillagerWarrior;
import com.legacy.blue_skies.tile_entities.TileEntityBluebrightChest;
import com.legacy.blue_skies.tile_entities.TileEntityKeystone;
import com.legacy.blue_skies.variables.SkiesLootTables;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityIllusionIllager;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySpellcasterIllager;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySummoner
extends EntitySpellcasterIllager {
    public static final DataParameter<Boolean> DUNGEON_SPAWNED = EntityDataManager.func_187226_a(EntitySummoner.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> HAS_HOME = EntityDataManager.func_187226_a(EntitySummoner.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> INVULNERABILITY_TIME = EntityDataManager.func_187226_a(EntitySummoner.class, (DataSerializer)DataSerializers.field_187192_b);
    private EntityStardustRam wololoTarget;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186742_b(true);
    private int teleportCooldown;
    private int timeSinceFighting;
    public double homeX;
    public double homeY;
    public double homeZ;

    public EntitySummoner(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 2.0f);
        this.field_70728_aV = 50;
        this.field_70178_ae = true;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIDoNothing());
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AICastingSpell());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 5.0f, 0.6, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AISummonIllagerSpell());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AISummonSpell());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIAttackSpell());
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIWololoSpell());
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIHealSpell());
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntitySummoner.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillagerWarrior.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(500.0);
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (this.getInvulTime() <= 0) {
            super.func_70091_d(type, x, y, z);
        } else {
            super.func_70091_d(type, 0.0, y, 0.0);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DUNGEON_SPAWNED, (Object)false);
        this.field_70180_af.func_187214_a(HAS_HOME, (Object)false);
        this.field_70180_af.func_187214_a(INVULNERABILITY_TIME, (Object)0);
    }

    public static void registerFixesSummoner(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntitySummoner.class);
    }

    public boolean isDungeonSpawned() {
        return (Boolean)this.field_70180_af.func_187225_a(DUNGEON_SPAWNED);
    }

    public void setDungeonSpawned(boolean isDungeonSpawned) {
        this.field_70180_af.func_187227_b(DUNGEON_SPAWNED, (Object)isDungeonSpawned);
    }

    public boolean func_110175_bO() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_HOME);
    }

    public void setHasHome(boolean hasHome) {
        this.field_70180_af.func_187227_b(HAS_HOME, (Object)hasHome);
    }

    public int getInvulTime() {
        return (Integer)this.field_70180_af.func_187225_a(INVULNERABILITY_TIME);
    }

    public void setInvulTime(int time) {
        this.field_70180_af.func_187227_b(INVULNERABILITY_TIME, (Object)time);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setDungeonSpawned(compound.func_74767_n("DungeonSpawned"));
        this.setHasHome(compound.func_74767_n("HasHome"));
        this.setInvulTime(compound.func_74762_e("Invul"));
        this.homeX = compound.func_74769_h("HomeX");
        this.homeY = compound.func_74769_h("HomeY");
        this.homeZ = compound.func_74769_h("HomeZ");
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74780_a("HomeX", this.homeX);
        compound.func_74780_a("HomeY", this.homeY);
        compound.func_74780_a("HomeZ", this.homeZ);
        this.setInvulTime(compound.func_74762_e("Invul"));
        compound.func_74757_a("DungeonSpawned", this.isDungeonSpawned());
        compound.func_74757_a("HasHome", this.func_110175_bO());
    }

    public void setHome(double posX, double posY, double posZ) {
        this.homeX = posX;
        this.homeY = posY;
        this.homeZ = posZ;
    }

    protected ResourceLocation func_184647_J() {
        return SkiesLootTables.summoner;
    }

    public boolean func_70687_e(PotionEffect effect) {
        return effect.func_188419_a() == MobEffects.field_82731_v ? false : super.func_70687_e(effect);
    }

    public boolean func_70692_ba() {
        return false;
    }

    protected void func_70619_bc() {
        if (this.getInvulTime() > 0) {
            int j1 = this.getInvulTime() - 1;
            this.setInvulTime(j1);
        } else {
            super.func_70619_bc();
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
            if (this.func_70638_az() == null && this.isDungeonSpawned() && this.teleportCooldown >= 40 && this.field_70146_Z.nextFloat() * 120.0f < 4.6f) {
                this.teleportAround();
                this.teleportCooldown = 0;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void healthParticles() {
        if (this.func_110143_aJ() <= 250.0f) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            ParticleBlueFlame particle = new ParticleBlueFlame(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)particle);
        } else {
            this.spawnParticles(EnumParticleTypes.FIREWORKS_SPARK);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_70066_B();
        if (this.field_70170_p.field_72995_K) {
            this.healthParticles();
        }
        if (!this.field_70170_p.field_72995_K) {
            List list;
            if (!this.func_193082_dl() && this.func_70090_H() || !this.func_193082_dl() && this.func_180799_ab()) {
                this.teleportAround();
                this.teleportCooldown = 0;
            }
            if (this.isDungeonSpawned() && !this.func_175446_cd()) {
                if (this.func_110175_bO()) {
                    this.checkIfHome();
                }
                if (this.func_70638_az() instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)this.func_70638_az();
                    if (player.field_70128_L) {
                        this.func_70634_a(this.homeX, this.homeY, this.homeZ);
                    }
                }
                ++this.teleportCooldown;
            }
            if (this.func_110143_aJ() != 500.0f && this.timeSinceFighting >= 30 && this.isDungeonSpawned() && (list = this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.homeX - 25.0, this.homeY - 1.0, this.homeZ - 25.0, this.homeX + 25.0, this.homeY + 10.0, this.homeZ + 25.0))).isEmpty()) {
                this.func_70606_j(500.0f);
            }
            if (this.func_70638_az() != null) {
                if ((this.func_70638_az() instanceof EntityPlayer && this.func_70638_az().func_110143_aJ() == 0.0f || this.func_70638_az() instanceof EntityPlayer && this.func_70638_az().field_70128_L && this.isDungeonSpawned()) && !(list = this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.homeX - 25.0, this.homeY - 5.0, this.homeZ - 25.0, this.homeX + 25.0, this.homeY + 10.0, this.homeZ + 25.0))).isEmpty()) {
                    this.func_70691_i(30.0f);
                }
                this.timeSinceFighting = 0;
            }
            if (this.field_70737_aN > 0) {
                this.timeSinceFighting = 0;
            }
            if (this.func_70638_az() == null && this.timeSinceFighting <= 101) {
                ++this.timeSinceFighting;
            }
        }
    }

    public void func_70609_aI() {
        super.func_70609_aI();
        if (this.isDungeonSpawned() && this.func_110175_bO() && this.field_70725_aQ == 1) {
            this.field_70170_p.func_175656_a(new BlockPos(this.homeX, this.homeY, this.homeZ + 4.0), BlocksSkies.bluebright_chest.func_176223_P());
            TileEntity tileentity = this.field_70170_p.func_175625_s(new BlockPos(this.homeX, this.homeY, this.homeZ + 4.0));
            if (tileentity instanceof TileEntityBluebrightChest) {
                ((TileEntityBluebrightChest)tileentity).func_189404_a(SkiesLootTables.summoner_loot, this.field_70146_Z.nextLong());
                ((TileEntityBluebrightChest)tileentity).func_190575_a(TextFormatting.DARK_AQUA + "Treasure Chest");
            }
            this.field_70170_p.func_180501_a(new BlockPos(this.homeX, this.homeY + 1.0, this.homeZ), BlocksSkies.keystone.func_176223_P().func_177226_a(BlockSkyKeystone.DUNGEON, (Comparable)((Object)BlockSkyKeystone.EnumKeystone.SILVER)), 2);
            this.field_70170_p.func_175656_a(new BlockPos(this.homeX, this.homeY, this.homeZ), BlocksSkies.dungeon_block.func_176203_a(3));
            TileEntity keystone = this.field_70170_p.func_175625_s(new BlockPos(this.homeX, this.homeY + 1.0, this.homeZ));
            if (keystone instanceof TileEntityKeystone) {
                ((TileEntityKeystone)keystone).setDestination(new BlockPos(0, -7, 0));
                ((TileEntityKeystone)keystone).keysRequired = false;
            }
        }
    }

    public void func_70030_z() {
        int playerCount;
        super.func_70030_z();
        if (this.func_70638_az() != null && ((playerCount = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_186662_g(4.0)).size()) > 0 || (double)this.func_70032_d((Entity)this.func_70638_az()) < 5.0) && !this.func_193082_dl()) {
            this.teleportAround();
        }
        if (this.getInvulTime() > 0) {
            int j1 = this.getInvulTime() - 1;
            if (j1 <= 0) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187855_gD, SoundCategory.HOSTILE, 2.0f, 1.0f);
            }
            double d0 = 0.05;
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_175682_a(EnumParticleTypes.FIREWORKS_SPARK, true, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.5, 0.0, new int[0]);
                this.field_70170_p.func_175682_a(EnumParticleTypes.FIREWORKS_SPARK, true, this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v, d0, -0.4, d0, new int[0]);
                this.field_70170_p.func_175682_a(EnumParticleTypes.FIREWORKS_SPARK, true, this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v, d0, -0.4, -d0, new int[0]);
                this.field_70170_p.func_175682_a(EnumParticleTypes.FIREWORKS_SPARK, true, this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v, -d0, -0.4, d0, new int[0]);
                this.field_70170_p.func_175682_a(EnumParticleTypes.FIREWORKS_SPARK, true, this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v, -d0, -0.4, -d0, new int[0]);
            }
        }
    }

    public void checkIfHome() {
        int distance = 15;
        if (this.field_70165_t > this.homeX + (double)distance || this.field_70161_v > this.homeZ + (double)distance || this.field_70163_u > this.homeY + 10.0) {
            this.func_70634_a(this.homeX, this.homeY, this.homeZ);
            this.func_184185_a(SoundEvents.field_193788_dg, 1.0f, 1.0f);
            this.func_70656_aK();
            this.field_70170_p.func_175656_a(new BlockPos(this.homeX, this.homeY - 1.0, this.homeZ), BlocksSkies.turquoise_stonebrick.func_176223_P());
        } else if (this.field_70165_t < this.homeX - (double)distance || this.field_70161_v < this.homeZ - (double)distance || this.field_70163_u < this.homeY - 5.0) {
            this.func_70634_a(this.homeX, this.homeY, this.homeZ);
            this.func_184185_a(SoundEvents.field_193788_dg, 1.0f, 1.0f);
            this.func_70656_aK();
            this.field_70170_p.func_175656_a(new BlockPos(this.homeX, this.homeY - 1.0, this.homeZ), BlocksSkies.turquoise_stonebrick.func_176223_P());
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.getInvulTime() > 0 && source != DamageSource.field_76380_i) {
            return false;
        }
        if (source instanceof EntityDamageSourceIndirect && source.func_76346_g() instanceof EntitySpellcasterIllager) {
            this.teleportAround();
            return false;
        }
        if (source instanceof EntityDamageSourceIndirect && !this.func_193082_dl()) {
            this.teleportAround();
            return false;
        }
        if (source == DamageSource.field_180137_b) {
            return false;
        }
        if (source.func_76364_f() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            ItemStack stack = player.field_71071_by.func_70448_g();
            boolean isMudkip = stack.func_77973_b().getRegistryName().toString().contains("mudkip");
            if (source.func_180136_u()) {
                return super.func_70097_a(source, amount);
            }
            if (isMudkip) {
                return false;
            }
            if (!source.func_180136_u() && !source.func_76352_a() && (double)source.func_76346_g().func_70032_d((Entity)this) > 3.5) {
                return false;
            }
            return super.func_70097_a(source, Math.min(21.0f, amount));
        }
        return super.func_70097_a(source, amount);
    }

    public void teleportAround() {
        if (this.getInvulTime() <= 0) {
            double d0 = this.field_70165_t;
            double d1 = this.field_70163_u;
            double d2 = this.field_70161_v;
            for (int i = 0; i < 16; ++i) {
                double d3 = this.homeX + (this.func_70681_au().nextDouble() - 0.5) * 20.0;
                double d4 = MathHelper.func_151237_a((double)(this.field_70163_u + (double)(this.func_70681_au().nextInt(16) - 8)), (double)0.0, (double)(this.field_70170_p.func_72940_L() - 1));
                double d5 = this.homeZ + (this.func_70681_au().nextDouble() - 0.5) * 20.0;
                if (this.func_184218_aH()) {
                    this.func_184210_p();
                }
                if (this.isDungeonSpawned()) {
                    if (!this.attemptDungeonTeleport(d3, d4, d5)) continue;
                    this.field_70170_p.func_184148_a((EntityPlayer)null, d0, d1, d2, SoundEvents.field_187544_ad, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    this.func_184185_a(SoundEvents.field_187544_ad, 1.0f, 1.0f);
                    this.func_70656_aK();
                    break;
                }
                if (!this.func_184595_k(d3, d4, d5)) continue;
                this.field_70170_p.func_184148_a((EntityPlayer)null, d0, d1, d2, SoundEvents.field_187544_ad, SoundCategory.HOSTILE, 1.0f, 1.0f);
                this.func_184185_a(SoundEvents.field_187544_ad, 1.0f, 1.0f);
                this.func_70656_aK();
                break;
            }
        }
    }

    public boolean attemptDungeonTeleport(double x, double y, double z) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        boolean flag = false;
        BlockPos blockpos = new BlockPos((Entity)this);
        World world = this.field_70170_p;
        Random random = this.func_70681_au();
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && (double)blockpos.func_177956_o() > this.homeY - 3.0 && (double)blockpos.func_177956_o() <= this.homeY + 1.0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                IBlockState iblockstate = world.func_180495_p(blockpos1);
                if (iblockstate == BlocksSkies.turquoise_stonebrick.func_176223_P() || iblockstate == BlocksSkies.mossy_turquoise_stonebrick.func_176223_P() || iblockstate == BlocksSkies.cracked_turquoise_stonebrick.func_176223_P()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                this.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (world.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty()) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70634_a(d0, d1, d2);
            return false;
        }
        for (int j = 0; j < 128; ++j) {
            double d6 = (double)j / 127.0;
            float f = (random.nextFloat() - 0.5f) * 0.2f;
            float f1 = (random.nextFloat() - 0.5f) * 0.2f;
            float f2 = (random.nextFloat() - 0.5f) * 0.2f;
            double d3 = d0 + (this.field_70165_t - d0) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d4 = d1 + (this.field_70163_u - d1) * d6 + random.nextDouble() * (double)this.field_70131_O;
            double d5 = d2 + (this.field_70161_v - d2) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            world.func_175688_a(EnumParticleTypes.CLOUD, d3, d4, d5, (double)f, (double)f1, (double)f2, new int[0]);
        }
        if (this instanceof EntityCreature) {
            this.func_70661_as().func_75499_g();
        }
        return true;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn == null) {
            return false;
        }
        if (entityIn == this) {
            return true;
        }
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof EntityVex) {
            return this.func_184191_r((Entity)((EntityVex)entityIn).func_190645_o());
        }
        if (entityIn instanceof EntityLivingBase && ((EntityLivingBase)entityIn).func_70668_bt() == EnumCreatureAttribute.ILLAGER) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SkiesSounds.ENTITY_SUMMONER_IDLE;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_SUMMONER_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SkiesSounds.ENTITY_SUMMONER_HURT;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f + 0.9f;
    }

    protected float func_70599_aP() {
        return 0.5f;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(EnumParticleTypes particleType) {
        for (int i = 0; i < 1; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    private void setWololoTarget(@Nullable EntityStardustRam p_190748_1_) {
        this.wololoTarget = p_190748_1_;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @Nullable
    private EntityStardustRam getWololoTarget() {
        return this.wololoTarget;
    }

    protected SoundEvent func_193086_dk() {
        return SkiesSounds.ENTITY_SUMMONER_CAST_SPELL;
    }

    class AIDoNothing
    extends EntityAIBase {
        public AIDoNothing() {
            this.func_75248_a(7);
        }

        public boolean func_75250_a() {
            return EntitySummoner.this.getInvulTime() > 0;
        }
    }

    public class AIHealSpell
    extends EntitySpellcasterIllager.AIUseSpell {
        public AIHealSpell() {
            super((EntitySpellcasterIllager)EntitySummoner.this);
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            return !(EntitySummoner.this.func_110143_aJ() >= 250.0f);
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected void func_190868_j() {
            int playerCount = EntitySummoner.this.field_70170_p.func_72872_a(EntityPlayer.class, EntitySummoner.this.func_174813_aQ().func_186662_g(35.0)).size();
            if (playerCount < 2) {
                EntitySummoner.this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 45, 4, false, false));
            } else {
                EntitySummoner.this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 25, 5, false, false));
            }
        }

        protected int func_190867_m() {
            return 20;
        }

        protected int func_190869_f() {
            return 70;
        }

        protected int func_190872_i() {
            return 300;
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_SUMMONER_PREPARE_REGEN;
        }

        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.func_193337_a((int)6);
        }
    }

    public class AIWololoSpell
    extends EntitySpellcasterIllager.AIUseSpell {
        final Predicate<EntityStardustRam> wololoSelector;

        public AIWololoSpell() {
            super((EntitySpellcasterIllager)EntitySummoner.this);
            this.wololoSelector = new Predicate<EntityStardustRam>(){

                public boolean apply(EntityStardustRam p_apply_1_) {
                    return p_apply_1_.getFleeceColor() == EnumDyeColor.BLUE;
                }
            };
        }

        public boolean func_75250_a() {
            if (EntitySummoner.this.func_70638_az() != null) {
                return false;
            }
            if (EntitySummoner.this.func_193082_dl()) {
                return false;
            }
            if (EntitySummoner.this.field_70173_aa < this.field_193322_d) {
                return false;
            }
            if (!EntitySummoner.this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                return false;
            }
            List list = EntitySummoner.this.field_70170_p.func_175647_a(EntityStardustRam.class, EntitySummoner.this.func_174813_aQ().func_72314_b(16.0, 4.0, 16.0), this.wololoSelector);
            if (list.isEmpty()) {
                return false;
            }
            EntitySummoner.this.setWololoTarget((EntityStardustRam)((Object)list.get(EntitySummoner.this.field_70146_Z.nextInt(list.size()))));
            return true;
        }

        public boolean func_75253_b() {
            return EntitySummoner.this.getWololoTarget() != null && this.field_193321_c > 0;
        }

        public void func_75251_c() {
            super.func_75251_c();
            EntitySummoner.this.setWololoTarget(null);
        }

        protected void func_190868_j() {
            EntityStardustRam entitysheep = EntitySummoner.this.getWololoTarget();
            if (entitysheep != null && entitysheep.func_70089_S()) {
                entitysheep.setFleeceColor(EnumDyeColor.RED);
            }
        }

        protected int func_190867_m() {
            return 40;
        }

        protected int func_190869_f() {
            return 60;
        }

        protected int func_190872_i() {
            return 120;
        }

        protected SoundEvent func_190871_k() {
            return SoundEvents.field_191249_bs;
        }

        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.WOLOLO;
        }

        public boolean isNonBoss() {
            return false;
        }
    }

    class AISummonIllagerSpell
    extends EntitySpellcasterIllager.AIUseSpell {
        private AISummonIllagerSpell() {
            super((EntitySpellcasterIllager)EntitySummoner.this);
        }

        public boolean func_75250_a() {
            int golemCount = EntitySummoner.this.field_70170_p.func_72872_a(EntityArtificialGolem.class, EntitySummoner.this.func_174813_aQ().func_186662_g(35.0)).size();
            int illagerCount = EntitySummoner.this.field_70170_p.func_72872_a(EntityIllusionIllager.class, EntitySummoner.this.func_174813_aQ().func_186662_g(35.0)).size();
            if (!super.func_75250_a()) {
                return false;
            }
            if (EntitySummoner.this.getInvulTime() > 0) {
                return false;
            }
            return illagerCount == 0 && golemCount <= 1;
        }

        protected int func_190869_f() {
            return 100;
        }

        protected int func_190872_i() {
            return 340;
        }

        protected void func_190868_j() {
            for (int i = 0; i < 2; ++i) {
                BlockPos blockpos = new BlockPos(EntitySummoner.this.homeX + -6.0 + (double)EntitySummoner.this.field_70146_Z.nextInt(12), EntitySummoner.this.homeY, EntitySummoner.this.homeZ + -6.0 + (double)EntitySummoner.this.field_70146_Z.nextInt(12));
                EntityIllusionIllager illusioner = new EntityIllusionIllager(EntitySummoner.this.field_70170_p);
                illusioner.func_174828_a(blockpos, 0.0f, 0.0f);
                illusioner.func_180482_a(EntitySummoner.this.field_70170_p.func_175649_E(blockpos), (IEntityLivingData)null);
                illusioner.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 99999, 8, false, false));
                if (!(EntitySummoner.this.func_70638_az() instanceof EntityPlayer || EntitySummoner.this.func_70638_az() instanceof EntityPlayerMP || EntitySummoner.this.func_70638_az() instanceof EntityVillager || EntitySummoner.this.func_70638_az() instanceof EntityVillagerWarrior)) {
                    illusioner.func_70624_b(EntitySummoner.this.func_70638_az());
                    EntitySummoner.this.field_70170_p.func_72838_d((Entity)illusioner);
                    continue;
                }
                EntitySummoner.this.field_70170_p.func_72838_d((Entity)illusioner);
            }
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_SUMMONER_PREPARE_SUMMONING;
        }

        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.DISAPPEAR;
        }
    }

    class AISummonSpell
    extends EntitySpellcasterIllager.AIUseSpell {
        private AISummonSpell() {
            super((EntitySpellcasterIllager)EntitySummoner.this);
        }

        public boolean func_75250_a() {
            int i = EntitySummoner.this.field_70170_p.func_72872_a(EntityArtificialGolem.class, EntitySummoner.this.func_174813_aQ().func_186662_g(35.0)).size();
            if (!super.func_75250_a()) {
                return false;
            }
            if (EntitySummoner.this.getInvulTime() > 0) {
                return false;
            }
            if (i >= 3) {
                return false;
            }
            return EntitySummoner.this.field_70146_Z.nextInt(8) + 1 > i;
        }

        protected int func_190869_f() {
            return 100;
        }

        protected int func_190872_i() {
            return 340;
        }

        protected void func_190868_j() {
            block3: {
                block2: {
                    if (EntitySummoner.this.func_70638_az() instanceof EntityWither) break block2;
                    for (int i = 0; i < 3; ++i) {
                        BlockPos blockpos = new BlockPos(EntitySummoner.this.homeX + -6.0 + (double)EntitySummoner.this.field_70146_Z.nextInt(12), EntitySummoner.this.homeY, EntitySummoner.this.homeZ + -6.0 + (double)EntitySummoner.this.field_70146_Z.nextInt(12));
                        EntityArtificialGolem golem = new EntityArtificialGolem(EntitySummoner.this.field_70170_p, (EntityLivingBase)EntitySummoner.this);
                        golem.func_174828_a(blockpos, 0.0f, 0.0f);
                        golem.func_180482_a(EntitySummoner.this.field_70170_p.func_175649_E(blockpos), null);
                        golem.func_70624_b(EntitySummoner.this.func_70638_az());
                        golem.func_184174_b(false);
                        EntitySummoner.this.field_70170_p.func_72838_d((Entity)golem);
                    }
                    break block3;
                }
                if (!(EntitySummoner.this.func_70638_az() instanceof EntityWither)) break block3;
                for (int i = 0; i < 3; ++i) {
                    BlockPos blockpos = new BlockPos((Entity)EntitySummoner.this).func_177982_a(-2 + EntitySummoner.this.field_70146_Z.nextInt(5), 1, -2 + EntitySummoner.this.field_70146_Z.nextInt(5));
                    EntityNyctoBug entitybug = new EntityNyctoBug(EntitySummoner.this.field_70170_p);
                    entitybug.func_174828_a(blockpos, 0.0f, 0.0f);
                    entitybug.func_180482_a(EntitySummoner.this.field_70170_p.func_175649_E(blockpos), null);
                    entitybug.func_184174_b(false);
                    entitybug.func_70624_b(EntitySummoner.this.func_70638_az());
                    entitybug.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 99999, 8));
                    entitybug.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 99999, 3));
                    EntitySummoner.this.field_70170_p.func_72838_d((Entity)entitybug);
                }
            }
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_SUMMONER_PREPARE_SUMMONING;
        }

        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.func_193337_a((int)9);
        }
    }

    class AICastingSpell
    extends EntitySpellcasterIllager.AICastingApell {
        private AICastingSpell() {
            super((EntitySpellcasterIllager)EntitySummoner.this);
        }

        public void func_75246_d() {
            if (EntitySummoner.this.func_70638_az() != null) {
                EntitySummoner.this.func_70671_ap().func_75651_a((Entity)EntitySummoner.this.func_70638_az(), (float)EntitySummoner.this.func_184649_cE(), (float)EntitySummoner.this.func_70646_bf());
            } else if (EntitySummoner.this.getWololoTarget() != null) {
                EntitySummoner.this.func_70671_ap().func_75651_a((Entity)EntitySummoner.this.getWololoTarget(), (float)EntitySummoner.this.func_184649_cE(), (float)EntitySummoner.this.func_70646_bf());
            }
        }
    }

    class AIAttackSpell
    extends EntitySpellcasterIllager.AIUseSpell {
        private AIAttackSpell() {
            super((EntitySpellcasterIllager)EntitySummoner.this);
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            return EntitySummoner.this.getInvulTime() <= 0;
        }

        protected int func_190869_f() {
            return 40;
        }

        protected int func_190872_i() {
            return 100;
        }

        protected void func_190868_j() {
            EntityLivingBase entitylivingbase = EntitySummoner.this.func_70638_az();
            double d0 = Math.min(entitylivingbase.field_70163_u, EntitySummoner.this.field_70163_u);
            double d1 = Math.max(entitylivingbase.field_70163_u, EntitySummoner.this.field_70163_u) + 1.0;
            float f = (float)MathHelper.func_181159_b((double)(entitylivingbase.field_70161_v - EntitySummoner.this.field_70161_v), (double)(entitylivingbase.field_70165_t - EntitySummoner.this.field_70165_t));
            if ((double)EntitySummoner.this.func_70032_d((Entity)entitylivingbase) < 5.0) {
                for (int k = 0; k < 8; ++k) {
                    float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.spawnLightning(EntitySummoner.this.field_70165_t + (double)MathHelper.func_76134_b((float)f2) * 4.5, EntitySummoner.this.field_70161_v + (double)MathHelper.func_76126_a((float)f2) * 4.5, d0, d1, f2, 3);
                }
            } else {
                for (int l = 0; l < 16; ++l) {
                    double d2 = 1.25 * (double)(l + 1);
                    int j = 1 * l;
                    this.spawnFangs(EntitySummoner.this.field_70165_t + (double)MathHelper.func_76134_b((float)f) * d2, EntitySummoner.this.field_70161_v + (double)MathHelper.func_76126_a((float)f) * d2, d0, d1, f, j);
                }
            }
        }

        private void spawnFangs(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_) {
            BlockPos blockpos = new BlockPos(p_190876_1_, p_190876_7_, p_190876_3_);
            boolean flag = false;
            double d0 = 0.0;
            do {
                IBlockState iblockstate;
                AxisAlignedBB axisalignedbb;
                if (EntitySummoner.this.field_70170_p.func_175677_d(blockpos, true) || !EntitySummoner.this.field_70170_p.func_175677_d(blockpos.func_177977_b(), true)) continue;
                if (!EntitySummoner.this.field_70170_p.func_175623_d(blockpos) && (axisalignedbb = (iblockstate = EntitySummoner.this.field_70170_p.func_180495_p(blockpos)).func_185890_d((IBlockAccess)EntitySummoner.this.field_70170_p, blockpos)) != null) {
                    d0 = axisalignedbb.field_72337_e;
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)p_190876_5_) - 1);
            if (flag) {
                EntityEvokerFangs entityevokerfangs = new EntityEvokerFangs(EntitySummoner.this.field_70170_p, p_190876_1_, (double)blockpos.func_177956_o() + d0, p_190876_3_, p_190876_9_, p_190876_10_, (EntityLivingBase)EntitySummoner.this);
                EntitySummoner.this.field_70170_p.func_72838_d((Entity)entityevokerfangs);
            }
        }

        private void spawnLightning(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_) {
            BlockPos blockpos = new BlockPos(p_190876_1_, p_190876_7_, p_190876_3_);
            boolean flag = false;
            double d0 = 0.0;
            do {
                IBlockState iblockstate;
                AxisAlignedBB axisalignedbb;
                if (EntitySummoner.this.field_70170_p.func_175677_d(blockpos, true) || !EntitySummoner.this.field_70170_p.func_175677_d(blockpos.func_177977_b(), true)) continue;
                if (!EntitySummoner.this.field_70170_p.func_175623_d(blockpos) && (axisalignedbb = (iblockstate = EntitySummoner.this.field_70170_p.func_180495_p(blockpos)).func_185890_d((IBlockAccess)EntitySummoner.this.field_70170_p, blockpos)) != null) {
                    d0 = axisalignedbb.field_72337_e;
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)p_190876_5_) - 1);
            if (flag) {
                EntitySummonedLightningBolt bolt = new EntitySummonedLightningBolt(EntitySummoner.this.field_70170_p, p_190876_1_, (double)blockpos.func_177956_o() + d0, p_190876_3_);
                EntitySummoner.this.field_70170_p.func_72838_d((Entity)bolt);
            }
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_SUMMONER_PREPARE_ATTACK;
        }

        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.func_193337_a((int)8);
        }
    }
}

