/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.client.sounds.SkiesSounds;
import com.legacy.blue_skies.entities.hostile.EntityCryno;
import com.legacy.blue_skies.entities.hostile.EntityFrostSpirit;
import com.legacy.blue_skies.entities.villager.EntityVillagerWarrior;
import com.legacy.blue_skies.items.ItemsSkies;
import com.legacy.blue_skies.items.tools.ItemSkyPickaxe;
import com.legacy.blue_skies.variables.SkiesLootTables;
import java.util.Calendar;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityArmoredFrostSpirit
extends EntityMob {
    private static final DataParameter<Boolean> IS_CHILD = EntityDataManager.func_187226_a(EntityArmoredFrostSpirit.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final UUID BABY_SPEED_BOOST_ID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier BABY_SPEED_BOOST = new AttributeModifier(BABY_SPEED_BOOST_ID, "Baby speed boost", 0.5, 1);
    private static final DataParameter<Boolean> ARMS_RAISED = EntityDataManager.func_187226_a(EntityArmoredFrostSpirit.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityArmoredFrostSpirit.class, (DataSerializer)DataSerializers.field_187192_b);
    private final EntityAIBreakDoor breakDoor = new EntityAIBreakDoor((EntityLiving)this);
    private boolean isBreakDoorsTaskSet;
    private float zombieWidth = -1.0f;
    private float zombieHeight;

    public EntityArmoredFrostSpirit(World worldIn) {
        super(worldIn);
        if (!(this instanceof EntityCryno)) {
            this.func_70105_a(0.6f, 1.95f);
        }
        this.determineTypeByDifficulty();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.5, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillagerWarrior.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.17);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_CHILD, (Object)false);
        this.func_184212_Q().func_187214_a(ARMS_RAISED, (Object)false);
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
    }

    public void setIceType(int type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type);
    }

    public int getIceType() {
        return (Integer)this.field_70180_af.func_187225_a(TYPE);
    }

    public void setArmsRaised(boolean armsRaised) {
        this.func_184212_Q().func_187227_b(ARMS_RAISED, (Object)armsRaised);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isArmsRaised() {
        return (Boolean)this.func_184212_Q().func_187225_a(ARMS_RAISED);
    }

    public boolean isBreakDoorsTaskSet() {
        return this.isBreakDoorsTaskSet;
    }

    public static void registerFixesFrostSpirit(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityArmoredFrostSpirit.class);
    }

    public void setBreakDoorsAItask(boolean enabled) {
        if (this.isBreakDoorsTaskSet != enabled) {
            this.isBreakDoorsTaskSet = enabled;
            ((PathNavigateGround)this.func_70661_as()).func_179688_b(enabled);
            if (enabled) {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.breakDoor);
            } else {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.breakDoor);
            }
        }
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.field_70146_Z.nextInt(450) == 0;
    }

    public boolean func_70631_g_() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_CHILD);
    }

    protected int func_70693_a(EntityPlayer player) {
        if (this.func_70631_g_()) {
            this.field_70728_aV = (int)((float)this.field_70728_aV * 2.5f);
        }
        return super.func_70693_a(player);
    }

    public void setChild(boolean childZombie) {
        this.func_184212_Q().func_187227_b(IS_CHILD, (Object)childZombie);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            iattributeinstance.func_111124_b(BABY_SPEED_BOOST);
            if (childZombie) {
                iattributeinstance.func_111121_a(BABY_SPEED_BOOST);
            }
        }
        this.setChildSize(childZombie);
    }

    public boolean func_70097_a(DamageSource ds, float amount) {
        if (ds == DamageSource.field_76370_b || ds == DamageSource.field_76372_a) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187541_bC, SoundCategory.HOSTILE, 0.5f, 1.0f);
            if (this.field_70170_p instanceof WorldServer) {
                ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.WATER_DROP, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 1.5, this.field_70161_v, 20, (double)(this.field_70130_N / 4.0f), (double)(this.field_70131_O / 4.0f), (double)(this.field_70130_N / 4.0f), 0.05, new int[0]);
            }
            return super.func_70097_a(ds, amount * 2.0f);
        }
        if (ds.func_76346_g() instanceof EntityLivingBase && this.field_70737_aN == 0) {
            if (this.field_70170_p instanceof WorldServer) {
                for (int i = 0; i < 2; ++i) {
                    if (this.getIceType() == 1) {
                        ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 1.5, this.field_70161_v, 20, (double)(this.field_70130_N / 4.0f), (double)(this.field_70131_O / 4.0f), (double)(this.field_70130_N / 4.0f), 0.05, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150403_cj.func_176223_P())});
                        continue;
                    }
                    ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 1.5, this.field_70161_v, 20, (double)(this.field_70130_N / 4.0f), (double)(this.field_70131_O / 4.0f), (double)(this.field_70130_N / 4.0f), 0.05, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150432_aD.func_176223_P())});
                }
            }
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187561_bM, SoundCategory.HOSTILE, 0.5f, 1.0f);
            if (ds.func_76364_f() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)ds.func_76364_f();
                ItemStack stack = player.field_71071_by.func_70448_g();
                boolean isTCPickaxe = stack.func_77973_b().getClass().getName().equals("slimeknights.tconstruct.tools.tools.Pickaxe");
                boolean isOtherPick = stack.func_77973_b().getRegistryName().toString().contains("pickaxe");
                if (stack.func_77973_b() instanceof ItemPickaxe || stack.func_77973_b() instanceof ItemSkyPickaxe || isTCPickaxe || isOtherPick) {
                    return super.func_70097_a(ds, amount + 4.0f);
                }
            }
        }
        return super.func_70097_a(ds, amount);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (IS_CHILD.equals(key)) {
            this.setChildSize(this.func_70631_g_());
        }
        super.func_184206_a(key);
    }

    public void func_70636_d() {
        float f;
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && !this.func_70631_g_() && this.shouldBurnInDay() && (f = this.func_70013_c()) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v))) {
            boolean flag = true;
            ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.HEAD);
            if (!itemstack.func_190926_b()) {
                if (itemstack.func_77984_f()) {
                    itemstack.func_77964_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                    if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                        this.func_70669_a(itemstack);
                        this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
                    }
                }
                flag = false;
            }
            if (flag) {
                this.func_70015_d(8);
            }
        }
        super.func_70636_d();
    }

    protected boolean shouldBurnInDay() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SkiesSounds.ENTITY_FROST_SPIRIT_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_FROST_SPIRIT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_FROST_SPIRIT_DEATH;
    }

    protected float func_70599_aP() {
        return 0.2f;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f + 0.9f;
    }

    protected ResourceLocation func_184647_J() {
        if (this.getIceType() == 1) {
            return SkiesLootTables.packed_armored_frost_spirit;
        }
        return SkiesLootTables.armored_frost_spirit;
    }

    public void determineTypeByDifficulty() {
        int chance = this.field_70146_Z.nextInt(4);
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.EASY) {
            if (chance == 0) {
                this.setIceType(1);
            } else {
                this.setIceType(0);
            }
        } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
            this.setIceType(this.field_70146_Z.nextInt(2));
        } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
            if (chance == 0) {
                this.setIceType(0);
            } else {
                this.setIceType(1);
            }
        }
    }

    @Nullable
    public static Item getSkyArmorByChance(EntityEquipmentSlot slotIn, int chance) {
        switch (slotIn) {
            case HEAD: {
                if (chance == 0) {
                    return Items.field_151024_Q;
                }
                if (chance == 1) {
                    return ItemsSkies.pyrope_helmet;
                }
                if (chance == 2) {
                    return ItemsSkies.turquoise_helmet;
                }
                if (chance == 3) {
                    return ItemsSkies.diopside_helmet;
                }
                if (chance == 4) {
                    return ItemsSkies.charoite_helmet;
                }
            }
            case CHEST: {
                if (chance == 0) {
                    return Items.field_151027_R;
                }
                if (chance == 1) {
                    return ItemsSkies.pyrope_chestplate;
                }
                if (chance == 2) {
                    return ItemsSkies.turquoise_chestplate;
                }
                if (chance == 3) {
                    return ItemsSkies.diopside_chestplate;
                }
                if (chance == 4) {
                    return ItemsSkies.charoite_chestplate;
                }
            }
            case LEGS: {
                if (chance == 0) {
                    return Items.field_151026_S;
                }
                if (chance == 1) {
                    return ItemsSkies.pyrope_leggings;
                }
                if (chance == 2) {
                    return ItemsSkies.turquoise_leggings;
                }
                if (chance == 3) {
                    return ItemsSkies.diopside_leggings;
                }
                if (chance == 4) {
                    return ItemsSkies.charoite_leggings;
                }
            }
            case FEET: {
                if (chance == 0) {
                    return Items.field_151021_T;
                }
                if (chance == 1) {
                    return ItemsSkies.pyrope_boots;
                }
                if (chance == 2) {
                    return ItemsSkies.turquoise_boots;
                }
                if (chance == 3) {
                    return ItemsSkies.diopside_boots;
                }
                if (chance != 4) break;
                return ItemsSkies.charoite_boots;
            }
        }
        return null;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        int i;
        if (this.field_70146_Z.nextFloat() < 0.15f * difficulty.func_180170_c()) {
            float f;
            i = this.field_70146_Z.nextInt(2);
            float f2 = f = this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 0.1f : 0.25f;
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            boolean flag = true;
            for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                Item item;
                if (entityequipmentslot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) continue;
                ItemStack itemstack = this.func_184582_a(entityequipmentslot);
                if (!flag && this.field_70146_Z.nextFloat() < f) break;
                flag = false;
                if (!itemstack.func_190926_b() || (item = EntityArmoredFrostSpirit.getSkyArmorByChance(entityequipmentslot, i)) == null) continue;
                this.func_184201_a(entityequipmentslot, new ItemStack(item));
            }
        }
        float f = this.field_70146_Z.nextFloat();
        float f3 = this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 0.05f : 0.01f;
        if (f < f3) {
            i = this.field_70146_Z.nextInt(3);
            if (i == 0) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ItemsSkies.everbright_turquoise_sword));
            } else {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ItemsSkies.everbright_pyrope_sword));
            }
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.func_70631_g_()) {
            compound.func_74757_a("IsBaby", true);
        }
        compound.func_74768_a("IceType", this.getIceType());
        compound.func_74757_a("CanBreakDoors", this.isBreakDoorsTaskSet());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74767_n("IsBaby")) {
            this.setChild(true);
        }
        this.setIceType(compound.func_74762_e("IceType"));
        this.setBreakDoorsAItask(compound.func_74767_n("CanBreakDoors"));
    }

    public float func_70047_e() {
        float f = 1.74f;
        if (this.func_70631_g_()) {
            f = (float)((double)f - 0.81);
        }
        return f;
    }

    protected boolean func_175448_a(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151110_aK && this.func_70631_g_() && this.func_184218_aH() ? false : super.func_175448_a(stack);
    }

    public void setChildSize(boolean isChild) {
        this.multiplySize(isChild ? 0.5f : 1.0f);
    }

    protected final void func_70105_a(float width, float height) {
        boolean flag = this.zombieWidth > 0.0f && this.zombieHeight > 0.0f;
        this.zombieWidth = width;
        this.zombieHeight = height;
        if (!flag) {
            this.multiplySize(1.0f);
        }
    }

    protected final void multiplySize(float size) {
        super.func_70105_a(this.zombieWidth * size, this.zombieHeight * size);
    }

    public double func_70033_W() {
        return this.func_70631_g_() ? 0.0 : -0.45;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        Calendar calendar;
        livingdata = super.func_180482_a(difficulty, livingdata);
        float f = difficulty.func_180170_c();
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * f);
        this.setBreakDoorsAItask(this.field_70146_Z.nextFloat() < f * 0.1f);
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        if (this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && (calendar = this.field_70170_p.func_83015_S()).get(2) + 1 == 10 && calendar.get(5) == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
            this.field_184655_bs[EntityEquipmentSlot.HEAD.func_188454_b()] = 0.0f;
        }
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextDouble() * (double)0.05f, 0));
        if (this.getIceType() == 1) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(new AttributeModifier("armor boost", 8.0, 0));
        }
        if (this.field_70170_p.func_72896_J()) {
            if (this.getIceType() == 1) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(new AttributeModifier("armor boost", 3.0, 0));
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(new AttributeModifier("armor boost", 7.0, 0));
            }
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier("speed boost", 0.04, 0));
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier("attack nerf", -1.0, 0));
            }
        }
        return livingdata;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            BlockPos blockpos = new BlockPos((Entity)this).func_177963_a(0.0, 1.5, 0.0);
            EntityFrostSpirit spirit = new EntityFrostSpirit(this.field_70170_p);
            spirit.func_174828_a(blockpos, this.field_70177_z, this.field_70125_A);
            this.field_70170_p.func_72838_d((Entity)spirit);
            this.func_70656_aK();
            this.func_70106_y();
        }
    }

    protected boolean func_70814_o() {
        return true;
    }

    public int func_70641_bl() {
        return 1;
    }

    class GroupData
    implements IEntityLivingData {
        public boolean isChild;

        private GroupData(boolean p_i47328_2_) {
            this.isChild = p_i47328_2_;
        }
    }
}

