/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.capability;

import com.legacy.blue_skies.SkiesConfig;
import com.legacy.blue_skies.blocks.BlocksSkies;
import com.legacy.blue_skies.capability.INBT;
import com.legacy.blue_skies.capability.PlayerSkyManager;
import com.legacy.blue_skies.containers.inventory.InventoryArcs;
import com.legacy.blue_skies.items.ItemsSkies;
import com.legacy.blue_skies.items.util.EnumArcType;
import com.legacy.blue_skies.network.PacketSkyManager;
import com.legacy.blue_skies.network.packets.PacketInventoryUpdate;
import com.legacy.blue_skies.world.TeleporterSkies;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class SkiesPlayer
implements INBT {
    public EntityPlayer player;
    private String loreEntry;
    private int loreIndex = 0;
    private InventoryArcs arcInventory;
    private static final AttributeModifier ETHEREAL_SPEED_BOOST_1 = new AttributeModifier(UUID.fromString("33b4f594-371b-11e9-b210-d663bd873d93"), "Ethereal speed boost", 0.1, 2).func_111168_a(true);
    private static final AttributeModifier ETHEREAL_SPEED_BOOST_2 = new AttributeModifier(UUID.fromString("33b4f594-371b-11e9-b210-d663bd873d94"), "Ethereal speed boost II", 0.15, 2).func_111168_a(true);
    public float prevPortalAnimTime;
    public float portalAnimTime;
    public int timeInPortal;
    public boolean hasTeleported = false;
    public boolean inPortal = false;
    public boolean everdawnPortal = false;
    private boolean isJumping;

    public SkiesPlayer() {
        this(null);
    }

    public SkiesPlayer(EntityPlayer player) {
        this.player = player;
        this.arcInventory = new InventoryArcs(player);
    }

    public void onUpdate() {
        boolean hasJumped = (Boolean)ReflectionHelper.getPrivateValue(EntityLivingBase.class, (Object)this.player, (String[])new String[]{"isJumping", "field_70703_bu"});
        this.setJumping(hasJumped);
        if (this.player.field_70170_p.field_72995_K) {
            this.prevPortalAnimTime = this.portalAnimTime;
            if (this.inPortal) {
                this.portalAnimTime += 0.0125f;
                this.inPortal = false;
            } else {
                if (this.portalAnimTime > 0.0f) {
                    this.portalAnimTime -= 0.05f;
                }
                if (this.portalAnimTime < 0.0f) {
                    this.portalAnimTime = 0.0f;
                }
            }
        } else if (this.inPortal) {
            int limit = this.player.func_82145_z();
            if (this.timeInPortal++ >= limit && this.isInBlock(BlocksSkies.everdawn_portal)) {
                this.timeInPortal = limit;
                this.player.field_71088_bW = this.player.func_82147_ab();
                this.teleportPlayerToEverdawn();
            } else if (this.timeInPortal++ >= limit && this.isInBlock(BlocksSkies.everbright_portal)) {
                this.timeInPortal = limit;
                this.player.field_71088_bW = this.player.func_82147_ab();
                this.teleportPlayerToEverbright();
            }
            this.inPortal = false;
        } else {
            if (this.timeInPortal > 0) {
                this.timeInPortal -= 4;
            }
            if (this.timeInPortal < 0) {
                this.timeInPortal = 0;
            }
            if (this.player.field_71088_bW > 0) {
                --this.player.field_71088_bW;
            }
        }
        this.arcAbilities();
    }

    public void arcAbilities() {
        IAttributeInstance iattributeinstance = this.player.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (this.wearingArc(EnumArcType.Ethereal)) {
            if (!iattributeinstance.func_180374_a(ETHEREAL_SPEED_BOOST_1)) {
                iattributeinstance.func_111121_a(ETHEREAL_SPEED_BOOST_1);
            }
        } else {
            if (iattributeinstance.func_180374_a(ETHEREAL_SPEED_BOOST_1)) {
                iattributeinstance.func_111124_b(ETHEREAL_SPEED_BOOST_1);
            }
            if (iattributeinstance.func_180374_a(ETHEREAL_SPEED_BOOST_2)) {
                iattributeinstance.func_111124_b(ETHEREAL_SPEED_BOOST_2);
            }
        }
        if (this.wearingArc(EnumArcType.Dusk) && !this.player.field_70170_p.field_72995_K) {
            this.player.func_82142_c(this.player.func_70093_af());
        }
        if (this.wearingRunicArc()) {
            if (this.wearingArc(EnumArcType.Ethereal) && !iattributeinstance.func_180374_a(ETHEREAL_SPEED_BOOST_2)) {
                iattributeinstance.func_111121_a(ETHEREAL_SPEED_BOOST_2);
            }
        } else if (this.wearingArc(EnumArcType.Ethereal) && iattributeinstance.func_180374_a(ETHEREAL_SPEED_BOOST_2)) {
            iattributeinstance.func_111124_b(ETHEREAL_SPEED_BOOST_2);
        }
    }

    public void sendInventoryUpdate() {
        if (!this.player.field_70170_p.field_72995_K) {
            PacketSkyManager.sendToAll(new PacketInventoryUpdate(this));
        }
    }

    public void onPlayerDeath() {
        if (!this.player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            this.arcInventory.dropAllItems();
        }
        this.sendInventoryUpdate();
    }

    public void onPlayerRespawn() {
        this.sendInventoryUpdate();
    }

    public void onChangedDimension(int toDim, int fromDim) {
        this.sendInventoryUpdate();
    }

    private void teleportPlayerToEverbright() {
        if (this.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)this.player;
            PlayerList scm = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
            int transferToID = player.field_71093_bK == SkiesConfig.dimension.everbright_dimension_id ? 0 : SkiesConfig.dimension.everbright_dimension_id;
            scm.transferPlayerToDimension(player, transferToID, (Teleporter)new TeleporterSkies(false, FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(transferToID)));
        }
    }

    private void teleportPlayerToEverdawn() {
        if (this.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)this.player;
            PlayerList scm = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
            int transferToID = player.field_71093_bK == SkiesConfig.dimension.everdawn_dimension_id ? 0 : SkiesConfig.dimension.everdawn_dimension_id;
            scm.transferPlayerToDimension(player, transferToID, (Teleporter)new TeleporterSkies(true, FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(transferToID)));
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        this.arcInventory.writeEntityToNBT(compound);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        this.arcInventory.readEntityFromNBT(compound);
    }

    public InventoryArcs getArcInventory() {
        return this.arcInventory;
    }

    public void setArcInventory(InventoryArcs arcInventory) {
        this.arcInventory = arcInventory;
    }

    public boolean isInBlock(Block blockID) {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.player.field_70165_t);
        BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)this.player.field_70163_u), z = MathHelper.func_76128_c((double)this.player.field_70161_v));
        return this.player.field_70170_p.func_180495_p(pos).func_177230_c() == blockID || this.player.field_70170_p.func_180495_p(pos.func_177984_a()).func_177230_c() == blockID || this.player.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == blockID;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setJumping(boolean isJumping) {
        this.isJumping = isJumping;
    }

    public String getLoreEntry() {
        return this.loreEntry;
    }

    public void setLoreEntry(String loreEntry) {
        this.loreEntry = loreEntry;
    }

    public int getLoreIndex() {
        return this.loreIndex;
    }

    public void setLoreIndex(int loreIndex) {
        this.loreIndex = loreIndex;
    }

    public void setInPortal(boolean everdawn) {
        if (everdawn) {
            this.everdawnPortal = true;
        } else if (!everdawn) {
            this.everdawnPortal = false;
        }
        if (this.player.field_71088_bW > 0) {
            this.player.field_71088_bW = this.player.func_82147_ab();
        } else {
            this.inPortal = true;
        }
    }

    public NonNullList<ItemStack> getArcStacks() {
        return this.arcInventory.arcInventory;
    }

    public boolean wearingArc(EnumArcType arc) {
        for (int index = 0; index < 7; ++index) {
            if (((ItemStack)this.getArcStacks().get(index)).func_77973_b() != ItemsSkies.arcs || ((ItemStack)this.getArcStacks().get(index)).func_77952_i() != arc.getMeta()) continue;
            return true;
        }
        return false;
    }

    public boolean wearingRunicArc() {
        return this.wearingArc(EnumArcType.Runic);
    }

    public int getArcCount(Item item) {
        int count = 0;
        for (int index = 0; index < 7; ++index) {
            if (((ItemStack)this.getArcStacks().get(index)).func_77973_b() != item) continue;
            ++count;
        }
        return count;
    }

    public boolean wearingArmor(Item item) {
        for (int index = 0; index < 4; ++index) {
            if (this.player == null || ((ItemStack)this.player.field_71071_by.field_70460_b.get(index)).func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public boolean isWearingShadowSet() {
        return this.wearingArmor(ItemsSkies.shadow_helmet) && this.wearingArmor(ItemsSkies.shadow_chestplate) && this.wearingArmor(ItemsSkies.shadow_leggings) && this.wearingArmor(ItemsSkies.shadow_boots);
    }

    public static SkiesPlayer get(EntityPlayer player) {
        return (SkiesPlayer)player.getCapability(PlayerSkyManager.SKIES_PLAYER, null);
    }
}

