/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.capability;

import com.legacy.blue_skies.SkiesConfig;
import com.legacy.blue_skies.blocks.BlocksSkies;
import com.legacy.blue_skies.blocks.misc.BlockSkyFire;
import com.legacy.blue_skies.capability.CapabilityHandler;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.items.tools.ItemSkyHoe;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class PlayerEventHandler {
    @SubscribeEvent
    public void onCapabilityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            SkiesPlayer player = CapabilityHandler.get((EntityPlayer)event.getEntityLiving());
            player.onUpdate();
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        SkiesPlayer original = CapabilityHandler.get(event.getOriginal());
        SkiesPlayer clone = CapabilityHandler.get(event.getEntityPlayer());
        NBTTagCompound compound = new NBTTagCompound();
        if (original != null && clone != null) {
            original.writeEntityToNBT(compound);
            clone.readEntityFromNBT(compound);
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        BlockPos firePos;
        if (event.getHitVec() == null) {
            return;
        }
        World world = event.getWorld();
        if (!(world.func_180495_p(firePos = new BlockPos(event.getHitVec())).func_177230_c() instanceof BlockSkyFire)) {
            return;
        }
        world.func_175718_b(1009, firePos, 0);
        world.func_175698_g(firePos);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getItemStack();
        if (state.func_177230_c() instanceof BlockBed && (world.field_73011_w.getDimension() == SkiesConfig.dimension.everbright_dimension_id || world.field_73011_w.getDimension() == SkiesConfig.dimension.everdawn_dimension_id)) {
            event.setCanceled(true);
            player.func_184609_a(EnumHand.MAIN_HAND);
            player.func_180473_a(pos, false);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.set_spawnpoint", new Object[0]), true);
        } else if (stack.func_77973_b() instanceof ItemHoe && !(stack.func_77973_b() instanceof ItemSkyHoe) && world.func_175623_d(pos.func_177984_a())) {
            Block block = state.func_177230_c();
            if (block == BlocksSkies.turquoise_dirt || block == BlocksSkies.turquoise_grass || block == BlocksSkies.everbright_cherry_grass) {
                this.hoeDirt(stack, player, world, pos, BlocksSkies.turquoise_farmland.func_176223_P(), event);
            } else if (block == BlocksSkies.lunar_dirt || block == BlocksSkies.lunar_grass || block == BlocksSkies.everdawn_cherry_grass) {
                this.hoeDirt(stack, player, world, pos, BlocksSkies.lunar_farmland.func_176223_P(), event);
            } else if (block == BlocksSkies.coarse_turquoise_dirt) {
                this.hoeDirt(stack, player, world, pos, BlocksSkies.turquoise_dirt.func_176223_P(), event);
            } else if (block == BlocksSkies.coarse_turquoise_dirt) {
                this.hoeDirt(stack, player, world, pos, BlocksSkies.turquoise_dirt.func_176223_P(), event);
            } else if (block == BlocksSkies.coarse_lunar_dirt) {
                this.hoeDirt(stack, player, world, pos, BlocksSkies.lunar_dirt.func_176223_P(), event);
            }
        } else if (event.getFace() == EnumFacing.UP && (stack.func_77973_b() == Items.field_151014_N || stack.func_77973_b() == Items.field_151081_bc || stack.func_77973_b() == Items.field_151080_bb || stack.func_77973_b() == Items.field_185163_cU || stack.func_77973_b() == Items.field_151174_bG || stack.func_77973_b() == Items.field_151172_bF)) {
            BlockPos seedPos = event.getPos().func_177984_a();
            if (world.func_180495_p(seedPos.func_177977_b()).func_177230_c() != Blocks.field_150458_ak && (world.func_180495_p(seedPos.func_177977_b()).func_177230_c() == BlocksSkies.turquoise_farmland || world.func_180495_p(seedPos.func_177977_b()).func_177230_c() == BlocksSkies.lunar_farmland)) {
                player.func_184609_a(event.getHand());
                if (stack.func_77973_b() == Items.field_151172_bF) {
                    this.plantSeed(stack, player, world, seedPos, BlocksSkies.carrots.func_176223_P());
                } else if (stack.func_77973_b() == Items.field_151174_bG) {
                    this.plantSeed(stack, player, world, seedPos, BlocksSkies.potatoes.func_176223_P());
                } else if (stack.func_77973_b() == Items.field_151014_N) {
                    this.plantSeed(stack, player, world, seedPos, BlocksSkies.wheat.func_176223_P());
                } else if (stack.func_77973_b() == Items.field_185163_cU) {
                    this.plantSeed(stack, player, world, seedPos, BlocksSkies.beetroots.func_176223_P());
                } else if (stack.func_77973_b() == Items.field_151080_bb) {
                    this.plantSeed(stack, player, world, seedPos, BlocksSkies.pumpkin_stem.func_176223_P());
                } else if (stack.func_77973_b() == Items.field_151081_bc) {
                    this.plantSeed(stack, player, world, seedPos, BlocksSkies.melon_stem.func_176223_P());
                }
            }
        } else {
            return;
        }
    }

    protected void hoeDirt(ItemStack stack, EntityPlayer player, World worldIn, BlockPos pos, IBlockState state, PlayerInteractEvent.RightClickBlock event) {
        worldIn.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!worldIn.field_72995_K) {
            worldIn.func_180501_a(pos, state, 11);
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
        player.func_184609_a(event.getHand());
    }

    protected void plantSeed(ItemStack stack, EntityPlayer player, World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            worldIn.func_180501_a(pos, state, 11);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        SkiesPlayer skiesPlayer = SkiesPlayer.get(event.player);
        if (skiesPlayer != null) {
            skiesPlayer.getArcInventory().func_70296_d();
        }
    }

    @SubscribeEvent
    public void onChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        SkiesPlayer skiesPlayer = SkiesPlayer.get(event.player);
        if (skiesPlayer != null) {
            skiesPlayer.onChangedDimension(event.toDim, event.fromDim);
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        SkiesPlayer player;
        if (event.getEntity() instanceof EntityPlayer && (player = SkiesPlayer.get((EntityPlayer)event.getEntity())) != null) {
            player.onPlayerDeath();
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        SkiesPlayer skiesPlayer = SkiesPlayer.get(event.player);
        if (skiesPlayer != null) {
            skiesPlayer.onPlayerRespawn();
        }
    }
}

