/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks;

import com.google.common.cache.LoadingCache;
import com.legacy.blue_skies.SkiesConfig;
import com.legacy.blue_skies.blocks.BlocksSkies;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.client.particle.ParticleBrightPortal;
import com.legacy.blue_skies.client.sounds.SkiesSounds;
import com.legacy.blue_skies.world.TeleporterSkies;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSkyPortal
extends BlockPortal {
    private Block frame;

    public BlockSkyPortal(Block state) {
        this.frame = state;
        this.func_149722_s();
        this.func_149715_a(0.7f);
        this.func_149672_a(SoundType.field_185853_f);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(170) == 0) {
            if (this == BlocksSkies.everdawn_portal) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SkiesSounds.BLOCK_EVERDAWN_PORTAL, SoundCategory.BLOCKS, 0.3f, 1.0f, false);
            } else {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SkiesSounds.BLOCK_EVERBRIGHT_PORTAL, SoundCategory.BLOCKS, 0.4f, rand.nextFloat() * 0.4f + 0.8f, false);
            }
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (float)pos.func_177956_o() + rand.nextFloat();
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() != this && worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            if (this == BlocksSkies.everbright_portal) {
                ParticleBrightPortal particle = new ParticleBrightPortal(worldIn, d0, d1, d2, d3, d4, d5);
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)particle);
                continue;
            }
            worldIn.func_175688_a(EnumParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5, new int[0]);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        int transferDimensionDawn;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        int previousDimensionBright = entity.field_71093_bK;
        int transferDimensionBright = previousDimensionBright == SkiesConfig.dimension.everbright_dimension_id ? 0 : SkiesConfig.dimension.everbright_dimension_id;
        int previousDimensionDawn = entity.field_71093_bK;
        int n = transferDimensionDawn = previousDimensionDawn == SkiesConfig.dimension.everdawn_dimension_id ? 0 : SkiesConfig.dimension.everdawn_dimension_id;
        if (entity instanceof EntityPlayer) {
            if (this == BlocksSkies.everdawn_portal) {
                SkiesPlayer.get((EntityPlayer)entity).setInPortal(true);
            } else {
                SkiesPlayer.get((EntityPlayer)entity).setInPortal(false);
            }
        } else if (!entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU()) {
            if (this == BlocksSkies.everbright_portal) {
                if (entity.field_71088_bW > 0) {
                    entity.field_71088_bW = entity.func_82147_ab();
                } else if (!world.field_72995_K && !pos.equals((Object)previousDimensionBright)) {
                    this.transferEntity(true, entity, server.func_71218_a(previousDimensionBright), server.func_71218_a(transferDimensionBright));
                    entity.field_71088_bW = 300;
                }
            }
            if (this == BlocksSkies.everdawn_portal) {
                if (entity.field_71088_bW > 0) {
                    entity.field_71088_bW = entity.func_82147_ab();
                } else if (!world.field_72995_K && !pos.equals((Object)previousDimensionDawn)) {
                    this.transferEntity(true, entity, server.func_71218_a(previousDimensionDawn), server.func_71218_a(transferDimensionDawn));
                    entity.field_71088_bW = 300;
                }
            }
        }
    }

    private void transferEntity(boolean shouldSpawnPortal, Entity entityIn, WorldServer previousWorldIn, WorldServer newWorldIn) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        entityIn.field_71093_bK = newWorldIn.field_73011_w.getDimension();
        previousWorldIn.func_72973_f(entityIn);
        entityIn.field_70128_L = false;
        if (this == BlocksSkies.everdawn_portal) {
            server.func_184103_al().transferEntityToWorld(entityIn, previousWorldIn.field_73011_w.getDimension(), previousWorldIn, newWorldIn, (Teleporter)new TeleporterSkies(true, newWorldIn));
        }
        if (this == BlocksSkies.everbright_portal) {
            server.func_184103_al().transferEntityToWorld(entityIn, previousWorldIn.field_73011_w.getDimension(), previousWorldIn, newWorldIn, (Teleporter)new TeleporterSkies(false, newWorldIn));
        }
    }

    public boolean func_176548_d(World worldIn, BlockPos pos) {
        Size blockportal$size = new Size(worldIn, pos, EnumFacing.Axis.X, this.frame, (Block)this);
        if (blockportal$size.isValid() && blockportal$size.portalBlockCount == 0) {
            blockportal$size.placePortalBlocks();
            return true;
        }
        Size blockportal$size1 = new Size(worldIn, pos, EnumFacing.Axis.Z, this.frame, (Block)this);
        if (blockportal$size1.isValid() && blockportal$size1.portalBlockCount == 0) {
            blockportal$size1.placePortalBlocks();
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        Size blockportal$size1;
        EnumFacing.Axis enumfacing$axis = (EnumFacing.Axis)state.func_177229_b((IProperty)field_176550_a);
        if (enumfacing$axis == EnumFacing.Axis.X) {
            Size blockportal$size = new Size(worldIn, pos, EnumFacing.Axis.X, this.frame, (Block)this);
            if (!blockportal$size.isValid() || blockportal$size.portalBlockCount < blockportal$size.width * blockportal$size.height) {
                worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        } else if (!(enumfacing$axis != EnumFacing.Axis.Z || (blockportal$size1 = new Size(worldIn, pos, EnumFacing.Axis.Z, this.frame, (Block)this)).isValid() && blockportal$size1.portalBlockCount >= blockportal$size1.width * blockportal$size1.height)) {
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public BlockPattern.PatternHelper func_181089_f(World worldIn, BlockPos p_181089_2_) {
        EnumFacing.Axis enumfacing$axis = EnumFacing.Axis.Z;
        Size blockportal$size = new Size(worldIn, p_181089_2_, EnumFacing.Axis.X, this.frame, (Block)this);
        LoadingCache loadingcache = BlockPattern.func_181627_a((World)worldIn, (boolean)true);
        if (!blockportal$size.isValid()) {
            enumfacing$axis = EnumFacing.Axis.X;
            blockportal$size = new Size(worldIn, p_181089_2_, EnumFacing.Axis.Z, this.frame, (Block)this);
        }
        if (!blockportal$size.isValid()) {
            return new BlockPattern.PatternHelper(p_181089_2_, EnumFacing.NORTH, EnumFacing.UP, loadingcache, 1, 1, 1);
        }
        int[] aint = new int[EnumFacing.AxisDirection.values().length];
        EnumFacing enumfacing = blockportal$size.rightDir.func_176735_f();
        BlockPos blockpos = blockportal$size.bottomLeft.func_177981_b(blockportal$size.getHeight() - 1);
        for (EnumFacing.AxisDirection enumfacing$axisdirection : EnumFacing.AxisDirection.values()) {
            BlockPattern.PatternHelper blockpattern$patternhelper = new BlockPattern.PatternHelper(enumfacing.func_176743_c() == enumfacing$axisdirection ? blockpos : blockpos.func_177967_a(blockportal$size.rightDir, blockportal$size.getWidth() - 1), EnumFacing.func_181076_a((EnumFacing.AxisDirection)enumfacing$axisdirection, (EnumFacing.Axis)enumfacing$axis), EnumFacing.UP, loadingcache, blockportal$size.getWidth(), blockportal$size.getHeight(), 1);
            for (int i = 0; i < blockportal$size.getWidth(); ++i) {
                for (int j = 0; j < blockportal$size.getHeight(); ++j) {
                    BlockWorldState blockworldstate = blockpattern$patternhelper.func_177670_a(i, j, 1);
                    if (blockworldstate.func_177509_a() == null || blockworldstate.func_177509_a().func_185904_a() == Material.field_151579_a) continue;
                    int n = enumfacing$axisdirection.ordinal();
                    aint[n] = aint[n] + 1;
                }
            }
        }
        EnumFacing.AxisDirection enumfacing$axisdirection1 = EnumFacing.AxisDirection.POSITIVE;
        for (EnumFacing.AxisDirection enumfacing$axisdirection2 : EnumFacing.AxisDirection.values()) {
            if (aint[enumfacing$axisdirection2.ordinal()] >= aint[enumfacing$axisdirection1.ordinal()]) continue;
            enumfacing$axisdirection1 = enumfacing$axisdirection2;
        }
        return new BlockPattern.PatternHelper(enumfacing.func_176743_c() == enumfacing$axisdirection1 ? blockpos : blockpos.func_177967_a(blockportal$size.rightDir, blockportal$size.getWidth() - 1), EnumFacing.func_181076_a((EnumFacing.AxisDirection)enumfacing$axisdirection1, (EnumFacing.Axis)enumfacing$axis), EnumFacing.UP, loadingcache, blockportal$size.getWidth(), blockportal$size.getHeight(), 1);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        IBlockState frame_block = this == BlocksSkies.everdawn_portal ? BlocksSkies.lunar_stonebrick.func_176223_P() : BlocksSkies.turquoise_stonebrick.func_176223_P();
        for (int y = -1; y <= 3; ++y) {
            if (placer.func_174811_aO() == EnumFacing.NORTH || placer.func_174811_aO() == EnumFacing.SOUTH) {
                for (int x = -1; x <= 2; ++x) {
                    worldIn.func_180501_a(pos.func_177982_a(x, y, 0), frame_block, 2);
                }
                continue;
            }
            for (int z = -1; z <= 2; ++z) {
                worldIn.func_180501_a(pos.func_177982_a(0, y, z), frame_block, 2);
            }
        }
        for (int y1 = 0; y1 <= 2; ++y1) {
            if (placer.func_174811_aO() == EnumFacing.NORTH || placer.func_174811_aO() == EnumFacing.SOUTH) {
                for (int x1 = 0; x1 <= 1; ++x1) {
                    worldIn.func_180501_a(pos.func_177982_a(x1, y1, 0), this.func_176223_P().func_177226_a((IProperty)field_176550_a, (Comparable)EnumFacing.Axis.X), 2);
                }
                continue;
            }
            for (int z1 = 0; z1 <= 1; ++z1) {
                worldIn.func_180501_a(pos.func_177982_a(0, y1, z1), this.func_176223_P().func_177226_a((IProperty)field_176550_a, (Comparable)EnumFacing.Axis.Z), 2);
            }
        }
    }

    public static class Size {
        private final Block frame;
        private final Block portal;
        private final World world;
        private final EnumFacing.Axis axis;
        private final EnumFacing rightDir;
        private final EnumFacing leftDir;
        private int portalBlockCount;
        private BlockPos bottomLeft;
        private int height;
        private int width;

        public Size(World worldIn, BlockPos p_i45694_2_, EnumFacing.Axis p_i45694_3_, Block frame, Block portal) {
            this.world = worldIn;
            this.axis = p_i45694_3_;
            this.frame = frame;
            this.portal = portal;
            if (p_i45694_3_ == EnumFacing.Axis.X) {
                this.leftDir = EnumFacing.EAST;
                this.rightDir = EnumFacing.WEST;
            } else {
                this.leftDir = EnumFacing.NORTH;
                this.rightDir = EnumFacing.SOUTH;
            }
            BlockPos blockpos = p_i45694_2_;
            while (p_i45694_2_.func_177956_o() > blockpos.func_177956_o() - 21 && p_i45694_2_.func_177956_o() > 0 && this.isEmptyBlock(worldIn.func_180495_p(p_i45694_2_.func_177977_b()).func_177230_c())) {
                p_i45694_2_ = p_i45694_2_.func_177977_b();
            }
            int i = this.getDistanceUntilEdge(p_i45694_2_, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = p_i45694_2_.func_177967_a(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(BlockPos p_180120_1_, EnumFacing p_180120_2_) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.isEmptyBlock(this.world.func_180495_p(blockpos = p_180120_1_.func_177967_a(p_180120_2_, i)).func_177230_c()) && this.world.func_180495_p(blockpos.func_177977_b()).func_177230_c() == this.frame; ++i) {
            }
            Block block = this.world.func_180495_p(p_180120_1_.func_177967_a(p_180120_2_, i)).func_177230_c();
            return block == this.frame ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                    Block block = this.world.func_180495_p(blockpos).func_177230_c();
                    if (!this.isEmptyBlock(block)) break block0;
                    if (block == this.portal) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? (block = this.world.func_180495_p(blockpos.func_177972_a(this.leftDir)).func_177230_c()) != this.frame : i == this.width - 1 && (block = this.world.func_180495_p(blockpos.func_177972_a(this.rightDir)).func_177230_c()) != this.frame) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                if (this.world.func_180495_p(this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height)).func_177230_c() == this.frame) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        protected boolean isEmptyBlock(Block blockIn) {
            return blockIn == Blocks.field_150350_a || blockIn == Blocks.field_150480_ab || blockIn == this.portal;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks() {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
                for (int j = 0; j < this.height; ++j) {
                    this.world.func_180501_a(blockpos.func_177981_b(j), this.portal.func_176223_P().func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)this.axis), 2);
                }
            }
        }
    }
}

