/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.util;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class RenderUtil {
    @OnlyIn(value=Dist.CLIENT)
    private static void renderModel(IBakedModel model, BlockState state, World worldObj, BlockPos blockPos, int alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        try {
            for (Direction Direction2 : Direction.values()) {
                RenderUtil.renderQuads(alpha, worldRenderer, model.func_200117_a(null, Direction2, new Random()), state, worldObj, blockPos);
            }
            RenderUtil.renderQuads(alpha, worldRenderer, model.func_200117_a(null, null, new Random()), state, worldObj, blockPos);
            tessellator.func_78381_a();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderQuads(int alpha, BufferBuilder renderer, List<BakedQuad> quads, BlockState state, World worldObj, BlockPos blockPos) {
        for (BakedQuad bakedquad : quads) {
            int color = bakedquad.func_178211_c() == -1 ? alpha | 0xFFFFFF : RenderUtil.getTint(alpha, bakedquad.func_178211_c(), state, worldObj, blockPos);
            LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)bakedquad, (int)color);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static int getTint(int alpha, int tintIndex, BlockState state, World worldObj, BlockPos blockPos) {
        return alpha | Minecraft.func_71410_x().func_184125_al().func_216860_a(state, (IEnviromentBlockReader)worldObj, blockPos, tintIndex);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderGhostModel(ItemStack itemStack, BlockState state, World worldObj, BlockPos blockPos) {
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(itemStack);
        RenderUtil.renderGhostModel(model, state, worldObj, blockPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderGhostModel(IBakedModel model, BlockState state, World worldObj, BlockPos blockPos) {
        int alpha = -1442840576;
        GlStateManager.bindTexture((int)Minecraft.func_71410_x().func_147117_R().func_110552_b());
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderUtil.renderModel(model, state, worldObj, blockPos, -1442840576);
        GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.depthFunc((int)515);
        RenderUtil.renderModel(model, state, worldObj, blockPos, -1442840576);
        GlStateManager.disableBlend();
    }
}

