/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.tile.functional;

import com.cjm721.overloaded.tile.ModTiles;
import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileItemManipulator
extends TileEntity
implements ITickableTileEntity {
    private static GameProfile FAKEPLAYER = new GameProfile(UUID.fromString("85824917-23F6-4B28-8B12-FAED16A3F66B"), "[Overloaded:Item_Manipulator]");
    private EnergyStorage energyStorage;
    private ItemStackHandler itemStack = new ItemStackHandler();
    private WeakReference<FakePlayer> player;
    private Direction facing;

    public TileItemManipulator() {
        super(ModTiles.itemManipulator);
        this.energyStorage = new EnergyStorage(Integer.MAX_VALUE, Integer.MAX_VALUE, 0);
    }

    public void func_145839_a(CompoundNBT compound) {
        if (compound.func_74764_b("Item")) {
            this.itemStack.deserializeNBT((CompoundNBT)compound.func_74781_a("Item"));
        }
        if (compound.func_74764_b("Energy")) {
            this.energyStorage = new EnergyStorage(Integer.MAX_VALUE, Integer.MAX_VALUE, 0, compound.func_74762_e("Energy"));
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("Item", (INBT)this.itemStack.serializeNBT());
        compound.func_74768_a("Energy", this.energyStorage.getEnergyStored());
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        ItemStack currentItem = this.itemStack.getStackInSlot(0);
        if (currentItem.func_190926_b()) {
            return;
        }
        FakePlayer player = this.getPlayer();
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(this.func_174877_v());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this.energyStorage).cast();
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.itemStack).cast();
        }
        return super.getCapability(capability, facing);
    }

    public TileItemManipulator setFacing(Direction facing) {
        this.facing = facing;
        return this;
    }

    private FakePlayer getPlayer() {
        if (this.player == null || this.player.get() == null) {
            FakePlayer fakePlayer = FakePlayerFactory.get((ServerWorld)((ServerWorld)this.func_145831_w()), (GameProfile)FAKEPLAYER);
            this.player = new WeakReference<FakePlayer>(fakePlayer);
            fakePlayer.func_70012_b((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 0.0f, 0.0f);
            fakePlayer.field_71071_by.func_174888_l();
        }
        return (FakePlayer)this.player.get();
    }

    public void breakBlock() {
        ItemStack storedItem = this.itemStack.getStackInSlot(0);
        if (!storedItem.func_190926_b()) {
            InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (ItemStack)storedItem);
        }
    }
}

