/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.tile.functional;

import com.cjm721.overloaded.tile.ModTiles;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ObjectHolder;

public class TileInfiniteWaterSource
extends TileEntity
implements IFluidHandler {
    @ObjectHolder(value="minecraft:water")
    private static Fluid WATER;

    public TileInfiniteWaterSource() {
        super(ModTiles.infiniteWaterSource);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction fluidAction) {
        return new FluidStack(WATER, maxDrain);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(capability, facing);
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (tank != 0) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(WATER, Integer.MAX_VALUE);
    }

    public int getTankCapacity(int tank) {
        return Integer.MAX_VALUE;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return tank == 0 && stack.getFluid().func_207187_a(WATER);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isFluidValid(0, resource)) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(WATER, resource.getAmount());
    }
}

