/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.storage.item;

import com.cjm721.overloaded.util.IDataUpdate;
import javax.annotation.Nonnull;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;

public class ProcessingItemStorage
implements IItemHandler,
INBTSerializable<CompoundNBT> {
    private final int inputSlots;
    private final int outputSlots;
    @Nonnull
    private final IDataUpdate dataUpdate;
    @Nonnull
    private NonNullList<ItemStack> input;
    @Nonnull
    private NonNullList<ItemStack> output;

    public ProcessingItemStorage(int inputSlots, int outputSlots, IDataUpdate dataUpdate) {
        this.inputSlots = inputSlots;
        this.input = NonNullList.func_191197_a((int)inputSlots, (Object)ItemStack.field_190927_a);
        this.outputSlots = outputSlots;
        this.output = NonNullList.func_191197_a((int)outputSlots, (Object)ItemStack.field_190927_a);
        this.dataUpdate = dataUpdate;
    }

    public int getSlots() {
        return this.inputSlots + this.outputSlots;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return slot < this.inputSlots ? (ItemStack)this.input.get(slot) : (ItemStack)this.output.get(slot - this.inputSlots);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        ItemStack returnStack;
        ItemStack itemStack = returnStack = slot < this.inputSlots ? this.insertItem(this.input, slot, stack, simulate) : this.insertItem(this.output, slot - this.inputSlots, stack, simulate);
        if (!simulate && stack.func_190916_E() != returnStack.func_190916_E()) {
            this.dataUpdate.dataUpdated();
        }
        return returnStack;
    }

    @Nonnull
    private ItemStack insertItem(NonNullList<ItemStack> inventory, int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (simulate) {
            return (ItemStack)inventory.get(slot);
        }
        return (ItemStack)inventory.set(slot, (Object)stack);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!simulate) {
            return ItemStackHelper.func_188382_a(slot < this.inputSlots ? this.input : this.output, (int)(slot < this.inputSlots ? slot : slot - this.inputSlots), (int)amount);
        }
        ItemStack toReturn = (slot < this.inputSlots ? (ItemStack)this.input.get(slot) : (ItemStack)this.output.get(slot - this.inputSlots)).func_77946_l();
        toReturn.func_190920_e(Math.min(toReturn.func_190916_E(), amount));
        if (!simulate && toReturn.func_190916_E() != 0) {
            this.dataUpdate.dataUpdated();
        }
        return toReturn;
    }

    public int getSlotLimit(int slot) {
        return slot < this.inputSlots ? ((ItemStack)this.input.get(slot)).func_77976_d() : ((ItemStack)this.output.get(slot - this.inputSlots)).func_77976_d();
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return slot < this.inputSlots + this.outputSlots;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT storage = new CompoundNBT();
        CompoundNBT inputNBT = new CompoundNBT();
        CompoundNBT outputNBT = new CompoundNBT();
        ItemStackHelper.func_191282_a((CompoundNBT)inputNBT, this.input);
        ItemStackHelper.func_191282_a((CompoundNBT)outputNBT, this.output);
        storage.func_218657_a("Input", (INBT)inputNBT);
        storage.func_218657_a("Output", (INBT)outputNBT);
        return storage;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("Input")) {
            ItemStackHelper.func_191283_b((CompoundNBT)nbt.func_74775_l("Input"), this.input);
        }
        if (nbt.func_74764_b("Output")) {
            ItemStackHelper.func_191283_b((CompoundNBT)nbt.func_74775_l("Output"), this.output);
        }
    }
}

