/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.storage.item;

import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.storage.item.IHyperHandlerItem;
import com.cjm721.overloaded.storage.stacks.intint.LongItemStack;
import com.cjm721.overloaded.util.IDataUpdate;
import com.cjm721.overloaded.util.NumberUtil;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class LongItemStorage
implements IItemHandler,
IHyperHandlerItem,
INBTSerializable<CompoundNBT> {
    @Nonnull
    private final IDataUpdate dataUpdate;
    @Nonnull
    private LongItemStack longItemStack;

    public LongItemStorage(@Nonnull IDataUpdate dataUpdate) {
        this.dataUpdate = dataUpdate;
        this.longItemStack = new LongItemStack(ItemStack.field_190927_a, 0L);
    }

    public int getSlots() {
        return OverloadedConfig.INSTANCE.specialConfig.infinityBarrelAdditionalSlot ? 2 : 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot != 0) {
            return ItemStack.field_190927_a;
        }
        if (!this.longItemStack.getItemStack().func_190926_b()) {
            this.longItemStack.getItemStack().func_190920_e((int)Math.min(Integer.MAX_VALUE, this.longItemStack.getAmount()));
            return this.longItemStack.getItemStack();
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        LongItemStack result = this.give(new LongItemStack(stack, stack.func_190916_E()), !simulate);
        if (result.getAmount() == 0L) {
            return ItemStack.field_190927_a;
        }
        ItemStack toReturn = stack.func_77946_l();
        toReturn.func_190920_e(result.getAmount().intValue());
        return toReturn;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        LongItemStack result = this.take(new LongItemStack(ItemStack.field_190927_a, amount), !simulate);
        if (result.getAmount() == 0L) {
            return ItemStack.field_190927_a;
        }
        ItemStack toReturn = result.getItemStack().func_77946_l();
        toReturn.func_190920_e(result.getAmount().intValue());
        return toReturn;
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        if (!this.longItemStack.getItemStack().func_190926_b()) {
            ItemStack stack = this.longItemStack.getItemStack();
            stack.func_190920_e(1);
            compound.func_218657_a("Item", (INBT)stack.serializeNBT());
            compound.func_74772_a("Count", this.longItemStack.getAmount().longValue());
        }
        return compound;
    }

    public void deserializeNBT(CompoundNBT compound) {
        ItemStack storedItem;
        ItemStack itemStack = storedItem = compound.func_74764_b("Item") ? ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound.func_74781_a("Item"))) : null;
        if (storedItem != null) {
            long storedAmount = compound.func_74764_b("Count") ? compound.func_74763_f("Count") : 0L;
            this.longItemStack = new LongItemStack(storedItem, storedAmount);
        }
    }

    @Override
    @Nonnull
    public LongItemStack status() {
        return this.longItemStack;
    }

    @Override
    @Nonnull
    public LongItemStack give(@Nonnull LongItemStack stack, boolean doAction) {
        if (this.longItemStack.getItemStack().func_190926_b()) {
            if (doAction) {
                this.longItemStack = new LongItemStack(stack.getItemStack(), stack.getAmount());
                this.dataUpdate.dataUpdated();
            }
            return LongItemStack.EMPTY_STACK;
        }
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)this.longItemStack.getItemStack(), (ItemStack)stack.getItemStack())) {
            NumberUtil.AddReturn<Long> result = NumberUtil.addToMax(this.longItemStack.getAmount(), stack.getAmount());
            if (doAction) {
                this.longItemStack.setAmount((Long)result.result);
                this.dataUpdate.dataUpdated();
            }
            return new LongItemStack(stack.getItemStack(), (Long)result.overflow);
        }
        return stack;
    }

    @Override
    @Nonnull
    public LongItemStack take(@Nonnull LongItemStack stack, boolean doAction) {
        if (this.longItemStack.getItemStack().func_190926_b()) {
            return LongItemStack.EMPTY_STACK;
        }
        long result = Math.min(stack.getAmount(), this.longItemStack.getAmount());
        LongItemStack toReturn = new LongItemStack(this.longItemStack.getItemStack(), result);
        if (doAction) {
            this.longItemStack.removeAmount(result);
            if (this.longItemStack.getAmount() == 0L) {
                this.longItemStack.setItemStack(ItemStack.field_190927_a);
            }
            this.dataUpdate.dataUpdated();
        }
        return toReturn;
    }
}

