/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.storage.fluid;

import com.cjm721.overloaded.storage.fluid.IHyperHandlerFluid;
import com.cjm721.overloaded.storage.stacks.intint.LongFluidStack;
import com.cjm721.overloaded.util.FluidUtil;
import com.cjm721.overloaded.util.IDataUpdate;
import com.cjm721.overloaded.util.NumberUtil;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class LongFluidStorage
implements IFluidHandler,
IHyperHandlerFluid,
INBTSerializable<CompoundNBT> {
    @Nonnull
    private final IDataUpdate dataUpdate;
    @Nonnull
    private LongFluidStack storedFluid;

    public LongFluidStorage(@Nonnull IDataUpdate dataUpdate) {
        this.dataUpdate = dataUpdate;
        this.storedFluid = new LongFluidStack(null, 0L);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction fluidAction) {
        LongFluidStack fluidStack = this.give(new LongFluidStack(resource, resource.getAmount()), fluidAction.execute());
        return (int)((long)resource.getAmount() - fluidStack.amount);
    }

    @Nonnull
    public FluidStack drain(@Nonnull FluidStack resource, IFluidHandler.FluidAction fluidAction) {
        LongFluidStack result = this.take(new LongFluidStack(resource, resource.getAmount()), fluidAction.execute());
        if (result.amount == 0L) {
            return FluidStack.EMPTY;
        }
        FluidStack toReturn = resource.copy();
        toReturn.setAmount((int)result.amount);
        return toReturn;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction fluidAction) {
        LongFluidStack result = this.take(new LongFluidStack(null, maxDrain), fluidAction.execute());
        if (result.amount == 0L) {
            return FluidStack.EMPTY;
        }
        FluidStack toReturn = result.fluidStack.copy();
        toReturn.setAmount((int)result.amount);
        return toReturn;
    }

    public void deserializeNBT(CompoundNBT compound) {
        FluidStack fluidStack = compound.func_74764_b("Fluid") ? FluidStack.loadFluidStackFromNBT((CompoundNBT)((CompoundNBT)compound.func_74781_a("Fluid"))) : null;
        long amount = compound.func_74764_b("Count") ? compound.func_74763_f("Count") : 0L;
        this.storedFluid = new LongFluidStack(fluidStack, amount);
    }

    @Nonnull
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        if (this.storedFluid.fluidStack != null) {
            CompoundNBT tag = new CompoundNBT();
            this.storedFluid.fluidStack.writeToNBT(tag);
            compound.func_218657_a("Fluid", (INBT)tag);
            compound.func_74772_a("Count", this.storedFluid.amount);
        }
        return compound;
    }

    public LongFluidStack getFluidStack() {
        return this.storedFluid;
    }

    @Override
    @Nonnull
    public LongFluidStack status() {
        return this.storedFluid;
    }

    @Override
    @Nonnull
    public LongFluidStack take(@Nonnull LongFluidStack stack, boolean doAction) {
        if (this.storedFluid.fluidStack == null) {
            return LongFluidStack.EMPTY_STACK;
        }
        if (stack.fluidStack != null && !FluidUtil.fluidsAreEqual(this.storedFluid.fluidStack, stack.fluidStack)) {
            return LongFluidStack.EMPTY_STACK;
        }
        LongFluidStack toReturn = new LongFluidStack(this.storedFluid.fluidStack, Math.min(this.storedFluid.amount, stack.amount));
        if (doAction) {
            this.storedFluid.amount -= toReturn.amount;
            if (this.storedFluid.amount == 0L) {
                this.storedFluid = LongFluidStack.EMPTY_STACK;
            }
            this.dataUpdate.dataUpdated();
        }
        return toReturn;
    }

    @Override
    @Nonnull
    public LongFluidStack give(@Nonnull LongFluidStack fluidStack, boolean doAction) {
        if (this.storedFluid.fluidStack == null) {
            if (doAction) {
                this.storedFluid = fluidStack;
                this.dataUpdate.dataUpdated();
            }
            return LongFluidStack.EMPTY_STACK;
        }
        if (FluidUtil.fluidsAreEqual(this.storedFluid.fluidStack, fluidStack.fluidStack)) {
            NumberUtil.AddReturn<Long> value = NumberUtil.addToMax(this.storedFluid.amount, fluidStack.amount);
            if (doAction) {
                this.storedFluid.amount = (Long)value.result;
                this.dataUpdate.dataUpdated();
            }
            return new LongFluidStack(this.storedFluid.fluidStack, (Long)value.overflow);
        }
        return fluidStack;
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int i) {
        return this.storedFluid.fluidStack;
    }

    public int getTankCapacity(int i) {
        return Integer.MAX_VALUE;
    }

    public boolean isFluidValid(int i, @Nonnull FluidStack fluidStack) {
        return this.storedFluid.fluidStack.isFluidEqual(fluidStack);
    }
}

