/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.storage.crafting;

import com.cjm721.overloaded.util.IDataUpdate;
import com.cjm721.overloaded.util.NBTHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class EnergyInventoryBasedRecipeProcessor<T extends IRecipe<IInventory>>
implements IItemHandlerModifiable,
IEnergyStorage,
INBTSerializable<CompoundNBT> {
    private final IRecipeType<T> recipeType;
    private final Supplier<World> worldSupplier;
    private final int maxEnergy;
    private final int slots;
    @Nonnull
    private final IDataUpdate dataUpdate;
    @Nonnull
    private List<ItemStack> input;
    @Nonnull
    private List<ItemStack> output;
    private int currentEnergy;

    EnergyInventoryBasedRecipeProcessor(IRecipeType recipeType, Supplier<World> worldSupplier, int maxEnergy, int slots, @Nonnull IDataUpdate dataUpdate) {
        this.recipeType = recipeType;
        this.worldSupplier = worldSupplier;
        this.maxEnergy = maxEnergy;
        this.slots = slots;
        this.dataUpdate = dataUpdate;
        this.input = new ArrayList<ItemStack>();
        this.output = new ArrayList<ItemStack>();
        this.currentEnergy = 0;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.maxEnergy - this.currentEnergy, maxReceive);
        if (!simulate) {
            this.currentEnergy += energyReceived;
            this.tryProcessRecipes(!this.isOnServer());
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.currentEnergy, maxExtract);
        if (!simulate) {
            this.currentEnergy -= energyExtracted;
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.currentEnergy;
    }

    public int getMaxEnergyStored() {
        return this.maxEnergy;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public int getSlots() {
        return this.slots + this.slots;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot < this.slots && slot < this.input.size()) {
            return this.input.get(slot);
        }
        if (slot >= this.slots && slot - this.slots < this.output.size()) {
            return this.output.get(slot - this.slots);
        }
        return ItemStack.field_190927_a;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.setItem(slot, stack);
    }

    public ItemStack setItem(int slot, ItemStack stack) {
        ItemStack toReturn;
        if (slot < this.slots) {
            if (slot >= this.input.size()) {
                if (!stack.func_190926_b()) {
                    this.input.add(stack);
                }
                toReturn = ItemStack.field_190927_a;
            } else if (stack.func_190926_b()) {
                toReturn = this.input.get(slot);
                this.input.remove(slot);
            } else {
                toReturn = this.input.set(slot, stack);
            }
        } else if ((slot -= this.slots) >= this.output.size()) {
            if (!stack.func_190926_b()) {
                this.output.add(stack);
            }
            toReturn = ItemStack.field_190927_a;
        } else if (stack.func_190926_b()) {
            toReturn = this.output.get(slot);
            this.output.remove(slot);
        } else {
            toReturn = this.output.set(slot, stack);
        }
        this.tryProcessRecipes(!this.isOnServer());
        return toReturn;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot >= this.slots) {
            return stack;
        }
        ItemStack returnStack = this.insertItem(this.input, slot, stack, simulate);
        if (!simulate && slot < this.slots && stack.func_190916_E() != returnStack.func_190916_E()) {
            this.tryProcessRecipes(!this.isOnServer());
        }
        return returnStack;
    }

    @Nonnull
    private ItemStack insertItem(List<ItemStack> inventory, int slot, @Nonnull ItemStack stack, boolean simulate) {
        ItemStack returnStack;
        if (slot >= this.slots) {
            return stack;
        }
        if (slot >= inventory.size()) {
            if (!simulate) {
                inventory.add(stack);
            }
            return ItemStack.field_190927_a;
        }
        ItemStack currentItem = inventory.get(slot);
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)currentItem, (ItemStack)(returnStack = stack.func_77946_l()))) {
            int originalCount = currentItem.func_190916_E();
            int newCount = Math.min(currentItem.func_77976_d(), originalCount + returnStack.func_190916_E());
            if (!simulate) {
                currentItem.func_190920_e(newCount);
            }
            returnStack.func_190920_e(returnStack.func_190916_E() + originalCount - newCount);
        }
        return returnStack;
    }

    private ItemStack insertItem(List<ItemStack> container, ItemStack stack, boolean simulate) {
        ItemStack inFlightStack = stack.func_77946_l();
        for (int i = 0; i < container.size() && !inFlightStack.func_190926_b(); ++i) {
            ItemStack storedStack = container.get(i).func_77946_l();
            if (storedStack.func_190926_b()) {
                if (!simulate) {
                    container.set(i, inFlightStack.func_77946_l());
                }
                inFlightStack = ItemStack.field_190927_a;
                continue;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)storedStack, (ItemStack)inFlightStack)) continue;
            int originalCount = storedStack.func_190916_E();
            int newCount = Math.min(storedStack.func_77976_d(), originalCount + inFlightStack.func_190916_E());
            if (!simulate) {
                storedStack.func_190920_e(newCount);
                container.set(i, storedStack.func_77946_l());
            }
            inFlightStack.func_190920_e(inFlightStack.func_190916_E() + originalCount - newCount);
        }
        if (!inFlightStack.func_190926_b() && container.size() < this.slots) {
            if (!simulate) {
                container.add(inFlightStack.func_77946_l());
            }
            return ItemStack.field_190927_a;
        }
        return inFlightStack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!simulate) {
            return ItemStackHelper.func_188382_a(slot < this.slots ? this.input : this.output, (int)(slot < this.slots ? slot : slot - this.slots), (int)amount);
        }
        ItemStack toReturn = slot < this.slots ? (this.input.size() > slot ? this.input.get(slot) : ItemStack.field_190927_a) : (slot - this.slots < this.output.size() ? this.output.get(slot - this.slots) : ItemStack.field_190927_a);
        toReturn = toReturn.func_77946_l();
        toReturn.func_190920_e(Math.min(toReturn.func_190916_E(), amount));
        if (!simulate && toReturn.func_190916_E() != 0) {
            if (slot >= this.slots) {
                this.tryProcessRecipes(!this.isOnServer());
            }
            this.dataUpdate.dataUpdated();
        }
        return toReturn;
    }

    public int getSlotLimit(int slot) {
        if (slot < this.slots && slot < this.input.size()) {
            return this.input.get(slot).func_77976_d();
        }
        if (slot >= this.slots && slot - this.slots < this.output.size()) {
            return this.output.get(slot).func_77976_d();
        }
        return ItemStack.field_190927_a.func_77976_d();
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return slot < this.slots;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT storage = new CompoundNBT();
        storage.func_218657_a("Input", (INBT)NBTHelper.serializeItems(this.input));
        storage.func_218657_a("Output", (INBT)NBTHelper.serializeItems(this.output));
        storage.func_74768_a("Energy", this.currentEnergy);
        return storage;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("Input")) {
            this.input = NBTHelper.deseralizeItems(nbt.func_150295_c("Input", 10));
        }
        if (nbt.func_74764_b("Output")) {
            this.output = NBTHelper.deseralizeItems(nbt.func_150295_c("Output", 10));
        }
        this.currentEnergy = nbt.func_74762_e("Energy");
    }

    public void setCurrentEnergy(int energy) {
        this.currentEnergy = energy;
    }

    private boolean isOnServer() {
        return this.worldSupplier != null && this.worldSupplier.get() != null && !this.worldSupplier.get().field_72995_K;
    }

    private void tryProcessRecipes(boolean simulate) {
        for (int i = Math.min(this.slots, this.input.size()) - 1; i >= 0; --i) {
            ItemStack leftOvers = this.processRecipeAndStoreOutput(this.input.get(i), simulate);
            if (simulate) continue;
            if (leftOvers.func_190926_b()) {
                this.input.remove(i);
                continue;
            }
            this.input.set(i, leftOvers);
        }
        this.dataUpdate.dataUpdated();
    }

    private List<T> getRecipe(Inventory inventory) {
        return this.worldSupplier.get().func_199532_z().func_215370_b(this.recipeType, (IInventory)inventory, this.worldSupplier.get());
    }

    private ItemStack processRecipeAndStoreOutput(ItemStack stack, boolean simulate) {
        ItemStack outputLeftOvers;
        int energyCost;
        ItemStack result;
        Inventory inventory = new Inventory(new ItemStack[]{stack.func_77946_l()});
        List<T> recipesForInput = this.getRecipe(inventory);
        if (recipesForInput.isEmpty()) {
            return inventory.func_70301_a(0);
        }
        IRecipe recipe = (IRecipe)recipesForInput.get(0);
        while (!inventory.func_70301_a(0).func_190926_b() && !(result = recipe.func_77572_b((IInventory)inventory)).func_190926_b() && (energyCost = this.energyCostPerRecipeOperation(recipe)) == this.extractEnergy(energyCost, true) && (outputLeftOvers = this.insertItem(this.output, result, true)).func_190926_b()) {
            this.insertItem(this.output, result, simulate);
            this.extractEnergy(energyCost, simulate);
            int deduct = ((Ingredient)recipe.func_192400_c().get(0)).func_193365_a()[0].func_190916_E();
            inventory.func_70301_a(0).func_190918_g(deduct);
        }
        return inventory.func_70301_a(0);
    }

    abstract int energyCostPerRecipeOperation(T var1);
}

