/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.client.render.tile;

import com.cjm721.overloaded.tile.functional.TilePlayerInterface;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlayerInterfaceRenderer
extends TileEntityRenderer<TilePlayerInterface> {
    private UUID uuidCache;
    private ItemStack stackCache;

    public void render(TilePlayerInterface te, double x, double y, double z, float partialTicks, int destroyStage) {
        GlStateManager.pushLightingAttributes();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.disableRescaleNormal();
        this.renderPlayer(te);
        GlStateManager.popMatrix();
        GlStateManager.popAttributes();
    }

    private void renderPlayer(TilePlayerInterface te) {
        UUID uuid = te.getPlacer();
        if (uuid == null) {
            return;
        }
        PlayerEntity player = te.func_145831_w().func_217371_b(uuid);
        if (player == null) {
            if (uuid.equals(this.uuidCache)) {
                this.renderItem(this.stackCache);
            } else {
                this.uuidCache = uuid;
                CompoundNBT tag = new CompoundNBT();
                tag.func_74778_a("SkullOwner", uuid.toString());
                this.stackCache = new ItemStack((IItemProvider)Items.field_196184_dx, 1, tag);
                this.renderItem(this.stackCache);
            }
            return;
        }
        RenderHelper.func_74519_b();
        GlStateManager.enableLighting();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.5, (double)0.3, (double)0.5);
        GlStateManager.scaled((double)0.2f, (double)0.2f, (double)0.2f);
        long angle = System.currentTimeMillis() / 10L % 360L;
        GlStateManager.rotated((double)angle, (double)0.0, (double)1.0, (double)0.0);
        boolean shadow = Minecraft.func_71410_x().func_175598_ae().func_178627_a();
        Minecraft.func_71410_x().func_175598_ae().func_178633_a(false);
        Minecraft.func_71410_x().func_175598_ae().func_188391_a((Entity)player, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        Minecraft.func_71410_x().func_175598_ae().func_178633_a(shadow);
        GlStateManager.popMatrix();
    }

    private void renderItem(ItemStack stack) {
        RenderHelper.func_74519_b();
        GlStateManager.enableLighting();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.5, (double)0.65, (double)0.5);
        GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        long angle = System.currentTimeMillis() / 10L % 360L;
        GlStateManager.rotated((double)angle, (double)0.0, (double)1.0, (double)0.0);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.NONE);
        GlStateManager.popMatrix();
    }
}

