/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.client.gui.button;

import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GenericSlider
extends AbstractSlider {
    private final String baseText;
    private boolean dragging;
    private final float minValue;
    private final float maxValue;

    public GenericSlider(int x, int y, float minValue, float maxValue, float currentValue, String baseText) {
        super(x, y, 150, 20, GenericSlider.scaleDown(currentValue, minValue, maxValue));
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.baseText = baseText;
        this.resetDisplayString();
    }

    private void resetDisplayString() {
        this.setMessage(String.format("%s %.2f", this.baseText, this.getEffectiveValue()));
    }

    public double getEffectiveValue() {
        return GenericSlider.scaleUp(this.value, this.minValue, this.maxValue);
    }

    private static double scaleUp(double unScaled, double min, double max) {
        return (max - min) * unScaled + min;
    }

    private static double scaleDown(double scaled, double min, double max) {
        scaled = MathHelper.func_151237_a((double)scaled, (double)min, (double)max);
        return (scaled - min) / (max - min);
    }

    public void setBasedOnEffectiveValue(float effectiveValue) {
        this.value = GenericSlider.scaleDown(effectiveValue, this.minValue, this.maxValue);
        this.resetDisplayString();
    }

    protected void updateMessage() {
        this.resetDisplayString();
    }

    protected void applyValue() {
    }
}

