/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.client.gui;

import com.cjm721.overloaded.Overloaded;
import com.cjm721.overloaded.capabilities.CapabilityGenericDataStorage;
import com.cjm721.overloaded.client.gui.button.GenericSlider;
import com.cjm721.overloaded.client.gui.button.GuiPositiveFloatTextField;
import com.cjm721.overloaded.client.gui.button.ToggleButton;
import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.item.functional.armor.ItemMultiHelmet;
import com.cjm721.overloaded.network.packets.MultiArmorSettingsMessage;
import com.cjm721.overloaded.storage.IGenericDataStorage;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;

@OnlyIn(value=Dist.CLIENT)
public class MultiArmorGuiScreen
extends Screen {
    private GenericSlider flightSpeed;
    private GenericSlider groundSpeed;
    private ToggleButton noClipFlightLock;
    private GuiPositiveFloatTextField flightSpeedTextBox;
    private GuiPositiveFloatTextField groundSpeedTextBox;
    private ToggleButton flightEnabled;
    private ToggleButton feedEnabled;
    private ToggleButton healEnabled;
    private ToggleButton removeHarmfulEnabled;
    private ToggleButton giveAirEnabled;
    private ToggleButton extinguishEnabled;

    public MultiArmorGuiScreen() {
        super((ITextComponent)new StringTextComponent("The TITLE HOW IS THIS SHOWN"));
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        super.init();
        LazyOptional<IGenericDataStorage> opData = MultiArmorGuiScreen.getHelmetDataStorage((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        if (!opData.isPresent()) {
            this.minecraft.func_147108_a(null);
            this.minecraft.field_71439_g.func_146105_b((ITextComponent)new StringTextComponent("Multi-Helmet not equipped."), true);
            return;
        }
        IGenericDataStorage data = (IGenericDataStorage)opData.orElseThrow(() -> new RuntimeException("Impossible Condition"));
        Map<String, Float> floats = data.getFloatMap();
        Map<String, Boolean> booleans = data.getBooleanMap();
        this.addButton((Widget)new Button(this.width / 2, this.height / 4 + 100, 150, 20, "Save", b -> {
            MultiArmorSettingsMessage message = new MultiArmorSettingsMessage((float)this.flightSpeed.getEffectiveValue(), (float)this.groundSpeed.getEffectiveValue(), this.noClipFlightLock.getBooleanState(), this.flightEnabled.getBooleanState(), this.feedEnabled.getBooleanState(), this.healEnabled.getBooleanState(), this.removeHarmfulEnabled.getBooleanState(), this.giveAirEnabled.getBooleanState(), this.extinguishEnabled.getBooleanState());
            Overloaded.proxy.networkWrapper.sendToServer((Object)message);
            this.minecraft.func_147108_a(null);
        }));
        this.addButton((Widget)new Button(this.width / 2 - 150, this.height / 4 + 100, 150, 20, "Cancel", b -> this.minecraft.func_147108_a(null)));
        float flightSpeedValue = floats.getOrDefault("flight_speed", Float.valueOf(0.1f)).floatValue();
        this.flightSpeed = (GenericSlider)this.addButton((Widget)new GenericSlider(this.width / 2 - 150, this.height / 4, 0.0f, (float)OverloadedConfig.INSTANCE.multiArmorConfig.maxFlightSpeed, flightSpeedValue, "Flight Speed:"));
        this.flightSpeedTextBox = (GuiPositiveFloatTextField)this.addButton((Widget)new GuiPositiveFloatTextField(this.font, this.flightSpeed.x, this.flightSpeed.y, this.flightSpeed.getWidth(), this.flightSpeed.getHeight(), flightSpeedValue, 0.0f, (float)OverloadedConfig.INSTANCE.multiArmorConfig.maxFlightSpeed));
        this.flightSpeedTextBox.func_146189_e(false);
        this.flightEnabled = (ToggleButton)this.addButton((Widget)new ToggleButton(this.width / 2 - 150, this.height / 4 + 20, booleans.getOrDefault("flight", true), "Flight:"));
        float groundSpeedValue = floats.getOrDefault("ground_speed", Float.valueOf(0.2f)).floatValue();
        this.groundSpeed = (GenericSlider)this.addButton((Widget)new GenericSlider(this.width / 2, this.height / 4, 0.0f, (float)OverloadedConfig.INSTANCE.multiArmorConfig.maxGroundSpeed, groundSpeedValue, "Ground Speed:"));
        this.groundSpeedTextBox = (GuiPositiveFloatTextField)this.addButton((Widget)new GuiPositiveFloatTextField(this.font, this.groundSpeed.x, this.groundSpeed.y, this.groundSpeed.getWidth(), this.groundSpeed.getHeight(), groundSpeedValue, 0.0f, (float)OverloadedConfig.INSTANCE.multiArmorConfig.maxGroundSpeed));
        this.groundSpeedTextBox.func_146189_e(false);
        this.feedEnabled = (ToggleButton)this.addButton((Widget)new ToggleButton(this.width / 2, this.height / 4 + 20, booleans.getOrDefault("feed", true), "Feeder:"));
        this.healEnabled = (ToggleButton)this.addButton((Widget)new ToggleButton(this.width / 2 - 150, this.height / 4 + 40, booleans.getOrDefault("heal", true), "Healer:"));
        this.removeHarmfulEnabled = (ToggleButton)this.addButton((Widget)new ToggleButton(this.width / 2, this.height / 4 + 40, booleans.getOrDefault("remove_harmful", true), "Remove Harmful Potions:"));
        this.giveAirEnabled = (ToggleButton)this.addButton((Widget)new ToggleButton(this.width / 2 - 150, this.height / 4 + 60, booleans.getOrDefault("give_air", true), "Airer:"));
        this.extinguishEnabled = (ToggleButton)this.addButton((Widget)new ToggleButton(this.width / 2, this.height / 4 + 60, booleans.getOrDefault("extinguish", true), "Extinguisher:"));
        this.noClipFlightLock = (ToggleButton)this.addButton((Widget)new ToggleButton(this.width / 2 - 75, this.height / 4 + 80, booleans.getOrDefault("noclip_flight_lock", true), "No Clip Flight Lock:"));
    }

    @Nullable
    private static LazyOptional<IGenericDataStorage> getHelmetDataStorage(PlayerEntity player) {
        for (ItemStack stack : player.func_184193_aE()) {
            if (!(stack.func_77973_b() instanceof ItemMultiHelmet)) continue;
            return stack.getCapability(CapabilityGenericDataStorage.GENERIC_DATA_STORAGE);
        }
        return LazyOptional.empty();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.flightSpeedTextBox.mouseClicked(mouseX, mouseY, mouseButton);
        this.groundSpeedTextBox.mouseClicked(mouseX, mouseY, mouseButton);
        switch (mouseButton) {
            case 0: {
                break;
            }
            case 1: {
                if (this.flightSpeed.visible) {
                    this.flightSpeedTextBox.func_146189_e(true);
                    this.flightSpeed.visible = false;
                    this.flightSpeedTextBox.func_146180_a(Float.toString((float)this.flightSpeed.getEffectiveValue()));
                    this.groundSpeedTextBox.func_146189_e(true);
                    this.groundSpeed.visible = false;
                    this.groundSpeedTextBox.func_146180_a(Float.toString((float)this.groundSpeed.getEffectiveValue()));
                    break;
                }
                this.flightSpeedTextBox.func_146189_e(false);
                this.flightSpeed.visible = true;
                this.flightSpeed.setBasedOnEffectiveValue(this.flightSpeedTextBox.getFloatValue());
                this.groundSpeedTextBox.func_146189_e(false);
                this.groundSpeed.visible = true;
                this.groundSpeed.setBasedOnEffectiveValue(this.groundSpeedTextBox.getFloatValue());
                break;
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }
}

