/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.ambientsounds;

import com.creativemd.ambientsounds.AmbientDimension;
import com.creativemd.ambientsounds.AmbientEngine;
import com.creativemd.ambientsounds.AmbientEnviroment;
import com.creativemd.ambientsounds.AmbientRegion;
import com.creativemd.ambientsounds.AmbientSound;
import com.creativemd.ambientsounds.AmbientSoundEngine;
import com.creativemd.ambientsounds.utils.Pair;
import com.creativemd.ambientsounds.utils.PairList;
import com.google.common.base.Strings;
import com.mojang.blaze3d.platform.GlStateManager;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.config.GuiUtils;

public class AmbientTickHandler {
    private static Minecraft mc = Minecraft.func_71410_x();
    public AmbientSoundEngine soundEngine;
    public AmbientEnviroment enviroment = null;
    public AmbientEngine engine;
    public int timer = 0;
    public boolean showDebugInfo = false;
    private static DecimalFormat df = new DecimalFormat("0.##");

    public void setEngine(AmbientEngine engine) {
        this.engine = engine;
    }

    @SubscribeEvent
    public void onClientChat(ClientChatEvent event) {
        String message = event.getMessage();
        if (message.startsWith("/ambient-reload")) {
            if (this.engine != null) {
                this.engine.stopEngine();
            }
            this.setEngine(AmbientEngine.loadAmbientEngine(this.soundEngine));
            event.setCanceled(true);
        } else if (message.startsWith("/ambient-debug")) {
            this.showDebugInfo = !this.showDebugInfo;
            event.setCanceled(true);
        }
    }

    private String format(Object value) {
        if (value instanceof Double || value instanceof Float) {
            return df.format(value);
        }
        return value.toString();
    }

    private String format(PairList<String, Object> details) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Pair pair : details) {
            if (!first) {
                builder.append(",");
            } else {
                first = false;
            }
            builder.append(TextFormatting.YELLOW + (String)pair.key + TextFormatting.RESET + ":" + this.format(pair.value));
        }
        return builder.toString();
    }

    @SubscribeEvent
    public void onRender(TickEvent.RenderTickEvent event) {
        if (this.showDebugInfo && event.phase == TickEvent.Phase.END && this.engine != null && !mc.func_147113_T() && this.enviroment != null && AmbientTickHandler.mc.field_71441_e != null) {
            GlStateManager.pushMatrix();
            ArrayList<String> list = new ArrayList<String>();
            AmbientDimension dimension = this.engine.getDimension((World)AmbientTickHandler.mc.field_71441_e);
            PairList<String, Object> details = new PairList<String, Object>();
            details.add("night", Boolean.valueOf(this.enviroment.night));
            details.add("rain", Boolean.valueOf(this.enviroment.raining));
            details.add("storm", Boolean.valueOf(this.enviroment.thundering));
            details.add("b-volume", Double.valueOf(this.enviroment.biomeVolume));
            details.add("underwater", Double.valueOf(this.enviroment.underwater));
            details.add("dim-name", DimensionType.func_212678_a((DimensionType)AmbientTickHandler.mc.field_71441_e.field_73011_w.getDimension().func_186058_p()).func_110623_a());
            list.add(this.format(details));
            details.clear();
            for (Pair pair : this.enviroment.biomes) {
                details.add(((AmbientEnviroment.BiomeArea)pair.key).biome.func_210773_k(), pair.value);
            }
            list.add(this.format(details));
            details.clear();
            details.add("dimension", (Object)dimension);
            details.add("playing", (Object)this.engine.soundEngine.playingCount());
            details.add("light", (Object)this.enviroment.blocks.averageLight);
            details.add("outside", (Object)this.enviroment.blocks.outsideVolume);
            details.add("height", (Object)(df.format(this.enviroment.relativeHeight) + "," + df.format(this.enviroment.averageHeight) + "," + df.format(this.enviroment.player.field_70163_u - (double)this.enviroment.minHeight) + "," + df.format(this.enviroment.player.field_70163_u - (double)this.enviroment.maxHeight)));
            list.add(this.format(details));
            details.clear();
            for (AmbientRegion ambientRegion : this.engine.activeRegions) {
                details.add("region", (Object)(TextFormatting.DARK_GREEN + ambientRegion.name + TextFormatting.RESET));
                details.add("playing", (Object)ambientRegion.playing.size());
                list.add(this.format(details));
                details.clear();
                for (AmbientSound sound : ambientRegion.playing) {
                    if (!sound.isPlaying()) continue;
                    String text = "";
                    if (sound.stream1 != null) {
                        details.add("n", (Object)sound.stream1.location);
                        details.add("v", (Object)sound.stream1.volume);
                        details.add("i", (Object)sound.stream1.index);
                        details.add("p", (Object)sound.stream1.pitch);
                        details.add("t", (Object)sound.stream1.ticksPlayed);
                        details.add("d", (Object)sound.stream1.duration);
                        text = "[" + this.format(details) + "]";
                        details.clear();
                    }
                    if (sound.stream2 != null) {
                        details.add("n", (Object)sound.stream2.location);
                        details.add("v", (Object)sound.stream2.volume);
                        details.add("i", (Object)sound.stream2.index);
                        details.add("p", (Object)sound.stream2.pitch);
                        details.add("t", (Object)sound.stream2.ticksPlayed);
                        details.add("d", (Object)sound.stream2.duration);
                        text = text + "[" + this.format(details) + "]";
                        details.clear();
                    }
                    list.add(text);
                }
            }
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                if (Strings.isNullOrEmpty((String)string)) continue;
                AmbientTickHandler.mc.field_71466_p.getClass();
                int j = 9;
                int k = AmbientTickHandler.mc.field_71466_p.func_78256_a(string);
                int i1 = 2 + j * i;
                GuiUtils.drawGradientRect((int)0, (int)1, (int)(i1 - 1), (int)(2 + k + 1), (int)(i1 + j - 1), (int)-1873784752, (int)-1873784752);
                AmbientTickHandler.mc.field_71466_p.func_211126_b(string, 2.0f, (float)i1, 0xE0E0E0);
            }
            GlStateManager.popMatrix();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (this.soundEngine == null) {
                this.soundEngine = new AmbientSoundEngine(mc.func_147118_V(), AmbientTickHandler.mc.field_71474_y);
                if (this.engine != null) {
                    this.engine.soundEngine = this.soundEngine;
                }
            }
            if (this.engine == null) {
                this.setEngine(AmbientEngine.loadAmbientEngine(this.soundEngine));
            }
            if (this.engine == null) {
                return;
            }
            ClientWorld world = AmbientTickHandler.mc.field_71441_e;
            ClientPlayerEntity player = AmbientTickHandler.mc.field_71439_g;
            if (world != null && player != null && AmbientTickHandler.mc.field_71474_y.func_186711_a(SoundCategory.AMBIENT) > 0.0f) {
                AmbientDimension newDimension;
                if (this.enviroment == null) {
                    this.enviroment = new AmbientEnviroment((PlayerEntity)player);
                }
                if (this.enviroment.dimension != (newDimension = this.engine.getDimension((World)world))) {
                    this.engine.changeDimension(this.enviroment, newDimension);
                    this.enviroment.dimension = newDimension;
                }
                if (this.timer % this.engine.enviromentTickTime == 0) {
                    this.enviroment.world = world;
                    this.enviroment.player = player;
                    this.enviroment.biomeVolume = 1.0;
                    this.enviroment.setHeight(this.engine.calculateAverageHeight((World)world, (PlayerEntity)player));
                    this.enviroment.biomeVolume = 1.0;
                    if (this.enviroment.dimension != null) {
                        this.enviroment.dimension.manipulateEnviroment(this.enviroment);
                    }
                    if (this.enviroment.biomeVolume > 0.0) {
                        this.enviroment.biomes = this.engine.calculateBiomes((World)world, (PlayerEntity)player, this.enviroment.biomeVolume);
                    } else if (this.enviroment.biomes != null) {
                        this.enviroment.biomes.clear();
                    } else {
                        this.enviroment.biomes = new PairList();
                    }
                    this.enviroment.blocks.updateAllDirections(this.engine);
                }
                if (this.timer % this.engine.soundTickTime == 0) {
                    this.enviroment.setSunAngle(world.func_72826_c(mc.func_184121_ak()));
                    this.enviroment.updateWorld();
                    int depth = 0;
                    if (player.func_208600_a(FluidTags.field_206959_a)) {
                        AxisAlignedBB bb = player.func_174813_aQ().func_72314_b((double)-0.1f, (double)-0.4f, (double)-0.1f);
                        while (world.func_72875_a(bb, Material.field_151586_h)) {
                            ++depth;
                            bb = bb.func_72317_d(0.0, 1.0, 0.0);
                        }
                        --depth;
                    }
                    this.enviroment.setUnderwater(depth);
                    this.engine.tick(this.enviroment);
                }
                this.engine.fastTick();
                ++this.timer;
            } else if (!this.engine.activeRegions.isEmpty()) {
                this.engine.stopEngine();
            }
        }
    }
}

