/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util.pooled.cache;

import io.github.cadiboo.nocubes.util.pooled.cache.XYZCache;
import javax.annotation.Nonnull;

public final class DensityCache
extends XYZCache
implements AutoCloseable {
    private static final ThreadLocal<DensityCache> POOL = ThreadLocal.withInitial(() -> new DensityCache(0, 0, 0, 0, 0, 0));
    @Nonnull
    private float[] cache;
    private boolean inUse;

    private DensityCache(int startPaddingX, int startPaddingY, int startPaddingZ, int sizeX, int sizeY, int sizeZ) {
        super(startPaddingX, startPaddingY, startPaddingZ, sizeX, sizeY, sizeZ);
        this.cache = new float[sizeX * sizeY * sizeZ];
        this.inUse = false;
    }

    @Nonnull
    public static DensityCache retain(int startPaddingX, int startPaddingY, int startPaddingZ, int sizeX, int sizeY, int sizeZ) {
        DensityCache pooled = POOL.get();
        if (pooled.inUse) {
            throw new IllegalStateException("DensityCache is already in use!");
        }
        pooled.inUse = true;
        pooled.startPaddingX = startPaddingX;
        pooled.startPaddingY = startPaddingY;
        pooled.startPaddingZ = startPaddingZ;
        if (pooled.sizeX == sizeX && pooled.sizeY == sizeY && pooled.sizeZ == sizeZ) {
            return pooled;
        }
        pooled.sizeX = sizeX;
        pooled.sizeY = sizeY;
        pooled.sizeZ = sizeZ;
        int size = sizeX * sizeY * sizeZ;
        if (pooled.cache.length < size || (float)pooled.cache.length > (float)size * 1.25f) {
            pooled.cache = new float[size];
        }
        return pooled;
    }

    @Nonnull
    public float[] getDensityCache() {
        return this.cache;
    }

    @Override
    public void close() {
        this.inUse = false;
    }
}

