/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util.pooled;

import io.github.cadiboo.nocubes.util.pooled.Vec3;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public final class Face
implements AutoCloseable {
    private static final ArrayList<Face> POOL = new ArrayList();
    @Nonnull
    private Vec3 vertex0;
    @Nonnull
    private Vec3 vertex1;
    @Nonnull
    private Vec3 vertex2;
    @Nonnull
    private Vec3 vertex3;

    private Face(@Nonnull Vec3 vertex0, @Nonnull Vec3 vertex1, @Nonnull Vec3 vertex2, @Nonnull Vec3 vertex3) {
        this.vertex0 = vertex0;
        this.vertex1 = vertex1;
        this.vertex2 = vertex2;
        this.vertex3 = vertex3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static Face retain(@Nonnull Vec3 vertex0, @Nonnull Vec3 vertex1, @Nonnull Vec3 vertex2, @Nonnull Vec3 vertex3) {
        ArrayList<Face> arrayList = POOL;
        synchronized (arrayList) {
            Face pooled;
            if (!POOL.isEmpty() && (pooled = POOL.remove(POOL.size() - 1)) != null) {
                pooled.vertex0 = vertex0;
                pooled.vertex1 = vertex1;
                pooled.vertex2 = vertex2;
                pooled.vertex3 = vertex3;
                return pooled;
            }
        }
        return new Face(vertex0, vertex1, vertex2, vertex3);
    }

    @Nonnull
    public static Face retain(@Nonnull Vec3 vertex0, @Nonnull Vec3 vertex1, @Nonnull Vec3 vertex2) {
        return Face.retain(vertex0.copy(), vertex0, vertex1, vertex2);
    }

    @Nonnull
    public Vec3 getVertex0() {
        return this.vertex0;
    }

    @Nonnull
    public Vec3 getVertex1() {
        return this.vertex1;
    }

    @Nonnull
    public Vec3 getVertex2() {
        return this.vertex2;
    }

    @Nonnull
    public Vec3 getVertex3() {
        return this.vertex3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<Face> arrayList = POOL;
        synchronized (arrayList) {
            if (POOL.size() < 2000) {
                POOL.add(this);
            }
        }
    }
}

