/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Profiler1122 {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static volatile boolean profilingEnabled;
    private final List<String> sectionList = Lists.newArrayList();
    private final LongList timestampList = new LongArrayList();
    private final Object2LongMap<String> profilingMap = new Object2LongArrayMap();
    private String profilingSection = "";

    public static synchronized boolean isProfilingEnabled() {
        return profilingEnabled;
    }

    public void clearProfiling() {
        this.profilingMap.clear();
        this.profilingSection = "";
        this.sectionList.clear();
    }

    public void startSection(String name) {
        if (profilingEnabled) {
            if (!this.profilingSection.isEmpty()) {
                this.profilingSection = this.profilingSection + ".";
            }
            this.profilingSection = this.profilingSection + name;
            this.sectionList.add(this.profilingSection);
            this.timestampList.add(System.nanoTime());
        }
    }

    public void startSection(Supplier<String> nameSupplier) {
        if (profilingEnabled) {
            this.startSection(nameSupplier.get());
        }
    }

    public void endSection() {
        if (profilingEnabled) {
            long i = System.nanoTime();
            long j = this.timestampList.removeLong(this.timestampList.size() - 1);
            this.sectionList.remove(this.sectionList.size() - 1);
            long k = i - j;
            if (this.profilingMap.containsKey((Object)this.profilingSection)) {
                this.profilingMap.put((Object)this.profilingSection, this.profilingMap.getLong((Object)this.profilingSection) + k);
            } else {
                this.profilingMap.put((Object)this.profilingSection, k);
            }
            if (k > 100000000L) {
                LOGGER.warn("Something's taking too long! '{}' took aprox {} ms", (Object)this.profilingSection, (Object)((double)k / 1000000.0));
            }
            this.profilingSection = this.sectionList.isEmpty() ? "" : this.sectionList.get(this.sectionList.size() - 1);
        }
    }

    public List<Result> getProfilingData(String profilerName) {
        if (!profilingEnabled) {
            return Collections.emptyList();
        }
        Object2LongMap<String> profilingMap = this.profilingMap;
        long i = profilingMap.getOrDefault("root", 0L);
        long j = profilingMap.getOrDefault(profilerName, -1L);
        ArrayList list = Lists.newArrayList();
        if (!profilerName.isEmpty()) {
            profilerName = profilerName + ".";
        }
        long k = 0L;
        for (String s : profilingMap.keySet()) {
            if (s.length() <= profilerName.length() || !s.startsWith(profilerName) || s.indexOf(".", profilerName.length() + 1) >= 0) continue;
            k += ((Long)profilingMap.get(s)).longValue();
        }
        float f = k;
        if (k < j) {
            k = j;
        }
        if (i < k) {
            i = k;
        }
        for (String s1 : profilingMap.keySet()) {
            if (s1.length() <= profilerName.length() || !s1.startsWith(profilerName) || s1.indexOf(".", profilerName.length() + 1) >= 0) continue;
            long l = (Long)profilingMap.get(s1);
            double d0 = (double)l * 100.0 / (double)k;
            double d1 = (double)l * 100.0 / (double)i;
            String s2 = s1.substring(profilerName.length());
            list.add(new Result(s2, d0, d1));
        }
        for (String s3 : profilingMap.keySet()) {
            profilingMap.put(s3, (Long)profilingMap.get(s3) * 999L / 1000L);
        }
        if ((float)k > f) {
            list.add(new Result("unspecified", (double)((float)k - f) * 100.0 / (double)k, (double)((float)k - f) * 100.0 / (double)i));
        }
        Collections.sort(list);
        list.add(0, new Result(profilerName, 100.0, (double)k * 100.0 / (double)i));
        return list;
    }

    public void endStartSection(String name) {
        this.endSection();
        this.startSection(name);
    }

    public String getNameOfLastSection() {
        List<String> sectionList = this.sectionList;
        return sectionList.isEmpty() ? "[UNKNOWN]" : sectionList.get(sectionList.size() - 1);
    }

    public void endStartSection(Supplier<String> nameSupplier) {
        this.endSection();
        this.startSection(nameSupplier);
    }

    public static final class Result
    implements Comparable<Result> {
        public double usePercentage;
        public double totalUsePercentage;
        public String profilerName;

        public Result(String profilerName, double usePercentage, double totalUsePercentage) {
            this.profilerName = profilerName;
            this.usePercentage = usePercentage;
            this.totalUsePercentage = totalUsePercentage;
        }

        @Override
        public int compareTo(Result other) {
            if (other.usePercentage < this.usePercentage) {
                return -1;
            }
            return other.usePercentage > this.usePercentage ? 1 : other.profilerName.compareTo(this.profilerName);
        }

        public int getColor() {
            return (this.profilerName.hashCode() & 0xAAAAAA) + 0x444444;
        }
    }
}

