/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util;

import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.config.Config;
import io.github.cadiboo.nocubes.mesh.MeshGenerator;
import io.github.cadiboo.nocubes.util.BadAutoUpdater;
import io.github.cadiboo.nocubes.util.IsSmoothable;
import io.github.cadiboo.nocubes.util.ModProfiler;
import io.github.cadiboo.nocubes.util.pooled.Vec3;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.material.Material;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.fluid.IFluidState;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;

public final class ModUtil {
    public static final Direction[] DIRECTION_VALUES = Direction.values();
    public static final int DIRECTION_VALUES_LENGTH = DIRECTION_VALUES.length;
    public static final Random RANDOM = new Random();
    public static final int COMMAND_PERMISSION_LEVEL = 2;

    public static float getIndividualBlockDensity(boolean shouldSmooth, BlockState state) {
        if (shouldSmooth) {
            if (state.func_177230_c() == Blocks.field_150433_aE) {
                int value = (Integer)state.func_177229_b((IProperty)SnowBlock.field_176315_a);
                if (value == 1) {
                    return 1.0f;
                }
                return -((float)(value - 1) * 0.125f);
            }
            return state.func_177230_c() == Blocks.field_150357_h ? -1.0005f : -1.0f;
        }
        if (state.func_200132_m()) {
            return 0.0f;
        }
        return 1.0f;
    }

    public static Vec3 offsetVertex(Vec3 vec3) {
        long rand = (long)(vec3.x * 3129871.0) ^ (long)vec3.z * 116129781L ^ (long)vec3.y;
        rand = rand * rand * 42317861L + rand * 11L;
        vec3.x += ((double)((float)(rand >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
        vec3.y += ((double)((float)(rand >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
        vec3.z += ((double)((float)(rand >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        return vec3;
    }

    public static void launchUpdateDaemon(@Nonnull ModContainer modContainer) {
        new Thread(() -> {
            block8: while (true) {
                VersionChecker.CheckResult checkResult = VersionChecker.getResult((IModInfo)modContainer.getModInfo());
                switch (checkResult.status) {
                    default: {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException var4) {
                            Thread.currentThread().interrupt();
                        }
                        continue block8;
                    }
                    case OUTDATED: {
                        try {
                            BadAutoUpdater.update(modContainer, checkResult.target.toString(), "Cadiboo");
                            break block8;
                        }
                        catch (Exception var3) {
                            throw new RuntimeException(var3);
                        }
                    }
                    case FAILED: 
                    case UP_TO_DATE: 
                    case AHEAD: 
                    case BETA: 
                    case BETA_OUTDATED: 
                }
                break;
            }
        }, modContainer.getModInfo().getDisplayName() + " Update Daemon").start();
    }

    public static boolean isDeveloperWorkspace() {
        String target = System.getenv().get("target");
        if (target == null) {
            return false;
        }
        return target.contains("userdev");
    }

    public static byte getMeshSizeX(int initialSize, MeshGenerator meshGenerator) {
        return (byte)(initialSize + meshGenerator.getSizeXExtension());
    }

    public static byte getMeshSizeY(int initialSize, MeshGenerator meshGenerator) {
        return (byte)(initialSize + meshGenerator.getSizeYExtension());
    }

    public static byte getMeshSizeZ(int initialSize, MeshGenerator meshGenerator) {
        return (byte)(initialSize + meshGenerator.getSizeZExtension());
    }

    public static IFluidState getFluidState(World world, BlockPos pos) {
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        int currentChunkPosX = posX >> 4;
        int currentChunkPosZ = posZ >> 4;
        Chunk currentChunk = world.func_212866_a_(currentChunkPosX, currentChunkPosZ);
        int extendRange = Config.extendFluidsRange.getRange();
        if (extendRange == 0) {
            return currentChunk.func_205751_b(posX, posY, posZ);
        }
        BlockState state = currentChunk.func_180495_p(pos);
        if (!state.nocubes_isTerrainSmoothable) {
            return state.func_204520_s();
        }
        IFluidState fluidState = state.func_204520_s();
        if (!fluidState.func_206888_e()) {
            return fluidState;
        }
        int maxXOffset = extendRange;
        int maxZOffset = extendRange;
        IFluidState state1 = currentChunk.func_205751_b(posX, posY + 1, posZ);
        if (state1.func_206889_d()) {
            return state1;
        }
        for (int xOffset = -maxXOffset; xOffset <= maxXOffset; ++xOffset) {
            for (int zOffset = -maxZOffset; zOffset <= maxZOffset; ++zOffset) {
                IFluidState state12;
                if (xOffset == 0 && zOffset == 0) continue;
                int checkX = posX + xOffset;
                int checkZ = posZ + zOffset;
                if (currentChunkPosX != checkX >> 4 || currentChunkPosZ != checkZ >> 4) {
                    currentChunkPosX = checkX >> 4;
                    currentChunkPosZ = checkZ >> 4;
                    currentChunk = world.func_212866_a_(currentChunkPosX, currentChunkPosZ);
                }
                if (!(state12 = currentChunk.func_205751_b(checkX, posY, checkZ)).func_206889_d()) continue;
                return state12;
            }
        }
        return fluidState;
    }

    public static boolean doesTerrainCauseSuffocation(IBlockReader reader, BlockPos pos) {
        float density = 0.0f;
        try (ModProfiler ignored = ModProfiler.get().start("Collisions calculate cube density");
             BlockPos.PooledMutableBlockPos pooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            int startX = pos.func_177958_n();
            int startY = pos.func_177956_o();
            int startZ = pos.func_177952_p();
            for (int zOffset = 0; zOffset < 2; ++zOffset) {
                for (int yOffset = 0; yOffset < 2; ++yOffset) {
                    for (int xOffset = 0; xOffset < 2; ++xOffset) {
                        pooledMutableBlockPos.func_181079_c(startX - xOffset, startY - yOffset, startZ - zOffset);
                        BlockState testState = reader.func_180495_p((BlockPos)pooledMutableBlockPos);
                        density += ModUtil.getIndividualBlockDensity(IsSmoothable.TERRAIN_SMOOTHABLE.apply(testState), testState);
                    }
                }
            }
        }
        return density > -4.0f;
    }

    public static boolean isMaterialGrass(Material material) {
        return material == Material.field_151582_l || material == Material.field_151577_b;
    }

    public static boolean isMaterialLeaves(Material material) {
        return material == Material.field_151584_j;
    }

    public static byte getRelativePos(int chunkPos, int blockPos) {
        int blockPosChunkPos = blockPos >> 4 << 4;
        if (chunkPos == blockPosChunkPos) {
            return ModUtil.getRelativePos(blockPos);
        }
        return (byte)(blockPos - chunkPos);
    }

    public static byte getRelativePos(int blockPos) {
        return (byte)(blockPos & 0xF);
    }

    public static void preloadClass(@Nonnull String qualifiedName, @Nonnull String simpleName) {
        try {
            NoCubes.LOGGER.info("Loading class \"" + simpleName + "\"...");
            ClassLoader classLoader = NoCubes.class.getClassLoader();
            long startTime = System.nanoTime();
            Class.forName(qualifiedName, false, classLoader);
            NoCubes.LOGGER.info("Loaded class \"" + simpleName + "\" in " + (System.nanoTime() - startTime) + " nano seconds");
            NoCubes.LOGGER.info("Initialising class \"" + simpleName + "\"...");
            Class.forName(qualifiedName, true, classLoader);
            NoCubes.LOGGER.info("Initialised \"" + simpleName + "\"");
        }
        catch (ClassNotFoundException e) {
            CrashReport crashReport = CrashReport.func_85055_a((Throwable)e, (String)("Failed to load class \"" + simpleName + "\". This should not be possible!"));
            crashReport.func_85058_a("Loading class");
            throw new ReportedException(crashReport);
        }
    }
}

