/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.network;

import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.config.Config;
import io.github.cadiboo.nocubes.mesh.MeshGeneratorType;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public final class S2CSetTerrainMeshGenerator {
    private final MeshGeneratorType newGenerator;

    public S2CSetTerrainMeshGenerator(MeshGeneratorType meshGeneratorType) {
        this.newGenerator = meshGeneratorType;
    }

    public static void encode(S2CSetTerrainMeshGenerator msg, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(msg.newGenerator.ordinal());
    }

    public static S2CSetTerrainMeshGenerator decode(PacketBuffer packetBuffer) {
        return new S2CSetTerrainMeshGenerator(MeshGeneratorType.VALUES[packetBuffer.readInt()]);
    }

    public static void handle(S2CSetTerrainMeshGenerator msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            MeshGeneratorType newGenerator;
            Config.terrainMeshGenerator = newGenerator = msg.newGenerator;
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("nocubes.setTerrainMeshGenerator", new Object[]{newGenerator}));
            if (Config.renderSmoothTerrain) {
                ClientUtil.tryReloadRenderers();
            }
        }));
        context.setPacketHandled(true);
    }
}

