/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.network;

import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.client.gui.toast.BlockStateToast;
import io.github.cadiboo.nocubes.config.Config;
import io.github.cadiboo.nocubes.util.StateHolder;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public final class S2CRemoveTerrainSmoothable {
    private final int blockStateId;

    public S2CRemoveTerrainSmoothable(int blockStateId) {
        this.blockStateId = blockStateId;
    }

    public static void encode(S2CRemoveTerrainSmoothable msg, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(msg.blockStateId);
    }

    public static S2CRemoveTerrainSmoothable decode(PacketBuffer packetBuffer) {
        return new S2CRemoveTerrainSmoothable(packetBuffer.readInt());
    }

    public static void handle(S2CRemoveTerrainSmoothable msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> S2CRemoveTerrainSmoothable.handleOnClient(msg)));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleOnClient(S2CRemoveTerrainSmoothable msg) {
        int blockStateId = msg.blockStateId;
        BlockState blockState = Block.func_196257_b((int)blockStateId);
        if (blockState == StateHolder.AIR_DEFAULT) {
            NoCubes.LOGGER.error("Trying to remove invalid terrain smoothable blockstate: " + blockStateId);
            return;
        }
        blockState.nocubes_isTerrainSmoothable = false;
        Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new BlockStateToast.RemoveTerrain(blockState, BlockPos.field_177992_a));
        if (Config.renderSmoothTerrain) {
            ClientUtil.tryReloadRenderers();
        }
    }
}

