/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.network;

import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.config.Config;
import io.github.cadiboo.nocubes.config.ConfigHelper;
import io.github.cadiboo.nocubes.mesh.MeshGeneratorType;
import io.github.cadiboo.nocubes.network.S2CSetTerrainMeshGenerator;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public final class C2SRequestSetTerrainMeshGenerator {
    private final MeshGeneratorType newGenerator;

    public C2SRequestSetTerrainMeshGenerator(MeshGeneratorType meshGeneratorType) {
        this.newGenerator = meshGeneratorType;
    }

    public static void encode(C2SRequestSetTerrainMeshGenerator msg, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(msg.newGenerator.ordinal());
    }

    public static C2SRequestSetTerrainMeshGenerator decode(PacketBuffer packetBuffer) {
        return new C2SRequestSetTerrainMeshGenerator(MeshGeneratorType.VALUES[packetBuffer.readInt()]);
    }

    public static void handle(C2SRequestSetTerrainMeshGenerator msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity sender = context.getSender();
            if (sender == null) {
                return;
            }
            if (sender.func_211513_k(2)) {
                MeshGeneratorType newGenerator;
                Config.terrainMeshGenerator = newGenerator = msg.newGenerator;
                ConfigHelper.setTerrainMeshGenerator(newGenerator);
                NoCubes.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new S2CSetTerrainMeshGenerator(newGenerator));
            } else {
                sender.func_145747_a((ITextComponent)new TranslationTextComponent("nocubes.setTerrainMeshGeneratorNoPermission", new Object[0]));
            }
        });
        context.setPacketHandled(true);
    }
}

