/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.network;

import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.config.ConfigHelper;
import io.github.cadiboo.nocubes.network.S2CAddTerrainSmoothable;
import io.github.cadiboo.nocubes.util.StateHolder;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public final class C2SRequestAddTerrainSmoothable {
    private final int blockStateId;

    public C2SRequestAddTerrainSmoothable(int blockStateId) {
        this.blockStateId = blockStateId;
    }

    public static void encode(C2SRequestAddTerrainSmoothable msg, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(msg.blockStateId);
    }

    public static C2SRequestAddTerrainSmoothable decode(PacketBuffer packetBuffer) {
        return new C2SRequestAddTerrainSmoothable(packetBuffer.readInt());
    }

    public static void handle(C2SRequestAddTerrainSmoothable msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity sender = context.getSender();
            if (sender == null) {
                return;
            }
            if (sender.func_211513_k(2)) {
                int blockStateId = msg.blockStateId;
                BlockState blockState = Block.func_196257_b((int)blockStateId);
                if (blockState == StateHolder.AIR_DEFAULT) {
                    NoCubes.LOGGER.error("Trying to add invalid terrain smoothable blockstate: " + blockStateId);
                    return;
                }
                ConfigHelper.addTerrainSmoothable(blockState);
                NoCubes.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new S2CAddTerrainSmoothable(blockStateId));
            } else {
                sender.func_145747_a((ITextComponent)new TranslationTextComponent("nocubes.addTerrainSmoothableNoPermission", new Object[0]));
            }
        });
        context.setPacketHandled(true);
    }
}

