/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.config;

import io.github.cadiboo.nocubes.config.ConfigHelper;
import io.github.cadiboo.nocubes.mesh.MeshGeneratorType;
import io.github.cadiboo.nocubes.util.ExtendFluidsRange;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.common.ForgeConfigSpec;

final class ServerConfig {
    @Nonnull
    final ForgeConfigSpec.ConfigValue<List<? extends String>> terrainSmoothable;
    @Nonnull
    final ForgeConfigSpec.ConfigValue<ExtendFluidsRange> extendFluidsRange;
    @Nonnull
    final ForgeConfigSpec.ConfigValue<MeshGeneratorType> terrainMeshGenerator;
    @Nonnull
    final ForgeConfigSpec.BooleanValue terrainCollisions;

    ServerConfig(@Nonnull ForgeConfigSpec.Builder builder) {
        builder.push("general");
        this.terrainSmoothable = builder.comment("The list of terrain smoothable blockstates").translation("nocubes.config.terrainSmoothable").defineList("terrainSmoothable", ConfigHelper.getDefaultTerrainSmoothable(), o -> o instanceof String);
        this.extendFluidsRange = builder.comment("The range at which to extend fluids into smoothable blocks").translation("nocubes.config.extendFluidsRange").defineEnum("extendFluidsRange", (Enum)ExtendFluidsRange.OneBlock);
        this.terrainMeshGenerator = builder.comment("The mesh generator that generates the terrain").translation("nocubes.config.terrainMeshGenerator").defineEnum("terrainMeshGenerator", (Enum)MeshGeneratorType.SurfaceNets);
        this.terrainCollisions = builder.comment("If realistic terrain collisions should be calculated").translation("nocubes.config.terrainCollisions").define("terrainCollisions", true);
        builder.pop();
    }
}

