/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.collision;

import io.github.cadiboo.nocubes.collision.CollisionHandler;
import io.github.cadiboo.nocubes.collision.StolenReposeCode;
import io.github.cadiboo.nocubes.config.Config;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisRotation;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public final class VoxelShapesHandler {
    public static double getAllowedOffset(AxisAlignedBB collisionBox, IWorldReader worldReader, double desiredOffset, ISelectionContext context, AxisRotation rotationAxis, Stream<VoxelShape> possibleHits, AxisRotation reversedRotation, Direction.Axis rotX, Direction.Axis rotY, Direction.Axis rotZ) {
        Entity entity = context.getEntity();
        if (!Config.terrainCollisions) {
            return VoxelShapesHandler.getVanillaAllowedOffset(collisionBox, worldReader, desiredOffset, context, rotationAxis, possibleHits, reversedRotation, rotX, rotY, rotZ);
        }
        if (CollisionHandler.shouldApplyMeshCollisions(entity)) {
            return VoxelShapesHandler.getMeshAllowedOffset(collisionBox, worldReader, desiredOffset, context, rotationAxis, possibleHits, reversedRotation, rotX, rotY, rotZ);
        }
        if (CollisionHandler.shouldApplyReposeCollisions(entity)) {
            return VoxelShapesHandler.getReposeAllowedOffset(collisionBox, worldReader, desiredOffset, context, rotationAxis, possibleHits, reversedRotation, rotX, rotY, rotZ);
        }
        return VoxelShapesHandler.getVanillaAllowedOffset(collisionBox, worldReader, desiredOffset, context, rotationAxis, possibleHits, reversedRotation, rotX, rotY, rotZ);
    }

    private static double getMeshAllowedOffset(AxisAlignedBB collisionBox, IWorldReader worldReader, double desiredOffset, ISelectionContext selectionContext, AxisRotation rotationAxis, Stream<VoxelShape> possibleHits, AxisRotation reversedRotation, Direction.Axis rotX, Direction.Axis rotY, Direction.Axis rotZ) {
        double[] adouble = new double[]{desiredOffset};
        possibleHits.forEach(shape -> {
            adouble[0] = shape.func_212430_a(rotZ, collisionBox, adouble[0]);
        });
        return adouble[0];
    }

    private static double getVanillaAllowedOffset(AxisAlignedBB collisionBox, IWorldReader worldReader, double desiredOffset, ISelectionContext selectionContext, AxisRotation rotationAxis, Stream<VoxelShape> possibleHits, AxisRotation reversedRotation, Direction.Axis rotX, Direction.Axis rotY, Direction.Axis rotZ) {
        try (BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            int minXm1 = MathHelper.func_76128_c((double)(collisionBox.func_197745_a(rotX) - 1.0E-7)) - 1;
            int maxXp1 = MathHelper.func_76128_c((double)(collisionBox.func_197742_b(rotX) + 1.0E-7)) + 1;
            int minYm1 = MathHelper.func_76128_c((double)(collisionBox.func_197745_a(rotY) - 1.0E-7)) - 1;
            int maxYp1 = MathHelper.func_76128_c((double)(collisionBox.func_197742_b(rotY) + 1.0E-7)) + 1;
            double minZ = collisionBox.func_197745_a(rotZ) - 1.0E-7;
            double maxZ = collisionBox.func_197742_b(rotZ) + 1.0E-7;
            boolean over0 = desiredOffset > 0.0;
            int initialZ = over0 ? MathHelper.func_76128_c((double)(collisionBox.func_197742_b(rotZ) - 1.0E-7)) - 1 : MathHelper.func_76128_c((double)(collisionBox.func_197745_a(rotZ) + 1.0E-7)) + 1;
            int diffFloored = VoxelShapes.func_216385_a((double)desiredOffset, (double)minZ, (double)maxZ);
            int p1orm1 = over0 ? 1 : -1;
            int z = initialZ;
            while (!(over0 ? z > diffFloored : z < diffFloored)) {
                for (int x = minXm1; x <= maxXp1; ++x) {
                    for (int y = minYm1; y <= maxYp1; ++y) {
                        int numBoundariesTouched = 0;
                        if (x == minXm1 || x == maxXp1) {
                            ++numBoundariesTouched;
                        }
                        if (y == minYm1 || y == maxYp1) {
                            ++numBoundariesTouched;
                        }
                        if (z == initialZ || z == diffFloored) {
                            ++numBoundariesTouched;
                        }
                        if (numBoundariesTouched >= 3) continue;
                        pos.func_218295_a(reversedRotation, x, y, z);
                        BlockState blockstate = worldReader.func_180495_p((BlockPos)pos);
                        if (numBoundariesTouched == 1 && !blockstate.func_215704_f() || numBoundariesTouched == 2 && blockstate.func_177230_c() != Blocks.field_196603_bb) continue;
                        desiredOffset = blockstate.func_215685_b((IBlockReader)worldReader, (BlockPos)pos, selectionContext).func_212430_a(rotZ, collisionBox.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p())), desiredOffset);
                        if (Math.abs(desiredOffset) < 1.0E-7) {
                            double d = 0.0;
                            return d;
                        }
                        diffFloored = VoxelShapes.func_216385_a((double)desiredOffset, (double)minZ, (double)maxZ);
                    }
                }
                z += p1orm1;
            }
        }
        double[] adouble = new double[]{desiredOffset};
        possibleHits.forEach(shape -> {
            adouble[0] = shape.func_212430_a(rotZ, collisionBox, adouble[0]);
        });
        return adouble[0];
    }

    private static double getReposeAllowedOffset(AxisAlignedBB collisionBox, IWorldReader worldReader, double desiredOffset, ISelectionContext selectionContext, AxisRotation rotationAxis, Stream<VoxelShape> possibleHits, AxisRotation reversedRotation, Direction.Axis rotX, Direction.Axis rotY, Direction.Axis rotZ) {
        try (BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            int minXm1 = MathHelper.func_76128_c((double)(collisionBox.func_197745_a(rotX) - 1.0E-7)) - 1;
            int maxXp1 = MathHelper.func_76128_c((double)(collisionBox.func_197742_b(rotX) + 1.0E-7)) + 1;
            int minYm1 = MathHelper.func_76128_c((double)(collisionBox.func_197745_a(rotY) - 1.0E-7)) - 1;
            int maxYp1 = MathHelper.func_76128_c((double)(collisionBox.func_197742_b(rotY) + 1.0E-7)) + 1;
            double minZ = collisionBox.func_197745_a(rotZ) - 1.0E-7;
            double maxZ = collisionBox.func_197742_b(rotZ) + 1.0E-7;
            boolean over0 = desiredOffset > 0.0;
            int initialZ = over0 ? MathHelper.func_76128_c((double)(collisionBox.func_197742_b(rotZ) - 1.0E-7)) - 1 : MathHelper.func_76128_c((double)(collisionBox.func_197745_a(rotZ) + 1.0E-7)) + 1;
            int diffFloored = VoxelShapes.func_216385_a((double)desiredOffset, (double)minZ, (double)maxZ);
            int p1orm1 = over0 ? 1 : -1;
            int z = initialZ;
            while (!(over0 ? z > diffFloored : z < diffFloored)) {
                for (int x = minXm1; x <= maxXp1; ++x) {
                    for (int y = minYm1; y <= maxYp1; ++y) {
                        int numBoundariesTouched = 0;
                        if (x == minXm1 || x == maxXp1) {
                            ++numBoundariesTouched;
                        }
                        if (y == minYm1 || y == maxYp1) {
                            ++numBoundariesTouched;
                        }
                        if (z == initialZ || z == diffFloored) {
                            ++numBoundariesTouched;
                        }
                        if (numBoundariesTouched >= 3) continue;
                        pos.func_218295_a(reversedRotation, x, y, z);
                        BlockState blockstate = worldReader.func_180495_p((BlockPos)pos);
                        if (numBoundariesTouched == 1 && !blockstate.func_215704_f() || numBoundariesTouched == 2 && blockstate.func_177230_c() != Blocks.field_196603_bb) continue;
                        VoxelShape unOffsetCollisionShape = blockstate.nocubes_isTerrainSmoothable ? StolenReposeCode.getCollisionShape(blockstate, worldReader, (BlockPos)pos, selectionContext) : blockstate.func_215685_b((IBlockReader)worldReader, (BlockPos)pos, selectionContext);
                        desiredOffset = unOffsetCollisionShape.func_212430_a(rotZ, collisionBox.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p())), desiredOffset);
                        if (Math.abs(desiredOffset) < 1.0E-7) {
                            double d = 0.0;
                            return d;
                        }
                        diffFloored = VoxelShapes.func_216385_a((double)desiredOffset, (double)minZ, (double)maxZ);
                    }
                }
                z += p1orm1;
            }
        }
        double[] adouble = new double[]{desiredOffset};
        possibleHits.forEach(shape -> {
            adouble[0] = shape.func_212430_a(rotZ, collisionBox, adouble[0]);
        });
        return adouble[0];
    }
}

