/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.collision;

import com.google.common.collect.ImmutableList;
import io.github.cadiboo.nocubes.util.IsSmoothable;
import io.github.cadiboo.nocubes.util.ModProfiler;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.StateHolder;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.border.WorldBorder;

final class StolenReposeCode {
    StolenReposeCode() {
    }

    public static VoxelShape getCollisionShape(BlockState stateIn, IWorldReader worldIn, BlockPos posIn, ISelectionContext context) {
        VoxelShape collisionShape = StolenReposeCode.getStateCollisionShape(stateIn, (IBlockReader)worldIn, posIn, context);
        if (collisionShape.func_197766_b()) {
            return collisionShape;
        }
        float density = StolenReposeCode.getDensity(worldIn, posIn);
        if (density > -1.0f) {
            return VoxelShapes.func_197880_a();
        }
        if (StolenReposeCode.canSlopeAt(stateIn, (IBlockReader)worldIn, posIn, collisionShape, context)) {
            try (ModProfiler ignored = ModProfiler.get().start("Collisions getSlopingCollisionShape");){
                VoxelShape voxelShape = StolenReposeCode.getSlopingCollisionShape(stateIn, worldIn, posIn, context);
                return voxelShape;
            }
        }
        return collisionShape;
    }

    private static float getDensity(IWorldReader reader, BlockPos pos) {
        float density = 0.0f;
        try (ModProfiler ignored = ModProfiler.get().start("Collisions calculate cube density");
             BlockPos.PooledMutableBlockPos pooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            WorldBorder worldBorder = reader.func_175723_af();
            int startX = pos.func_177958_n();
            int startY = pos.func_177956_o();
            int startZ = pos.func_177952_p();
            for (int zOffset = 0; zOffset < 2; ++zOffset) {
                for (int yOffset = 0; yOffset < 2; ++yOffset) {
                    for (int xOffset = 0; xOffset < 2; ++xOffset) {
                        pooledMutableBlockPos.func_181079_c(startX - xOffset, startY - yOffset, startZ - zOffset);
                        if (!reader.func_175667_e((BlockPos)pooledMutableBlockPos) || !worldBorder.func_177746_a((BlockPos)pooledMutableBlockPos)) {
                            density += 1.0f;
                            continue;
                        }
                        BlockState testState = reader.func_180495_p((BlockPos)pooledMutableBlockPos);
                        density += ModUtil.getIndividualBlockDensity(IsSmoothable.TERRAIN_SMOOTHABLE.apply(testState), testState);
                    }
                }
            }
        }
        return density;
    }

    private static VoxelShape getSlopingCollisionShape(BlockState state, IWorldReader world, BlockPos pos, ISelectionContext context) {
        double height = StolenReposeCode.blockHeight(pos, (IBlockReader)world, state, context);
        VoxelShape shape = VoxelShapes.func_197880_a();
        for (Direction direction : Direction.OrdinalDirections) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)StolenReposeCode.cornerBox(pos, direction, height, world, context), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return shape;
    }

    private static VoxelShape cornerBox(BlockPos pos, Direction direction, double blockHeight, IWorldReader world, ISelectionContext context) {
        double stepHeight = blockHeight - 0.5;
        int dirX = direction.x;
        int dirZ = direction.z;
        double height = StolenReposeCode.stepHigh(pos.func_177982_a(dirX, 0, 0), stepHeight, world, context) && StolenReposeCode.stepHigh(pos.func_177982_a(0, 0, dirZ), stepHeight, world, context) && StolenReposeCode.stepHigh(pos.func_177982_a(dirX, 0, dirZ), stepHeight, world, context) ? blockHeight : stepHeight;
        return VoxelShapes.func_197873_a((double)Math.max(0.0, (double)dirX / 2.0), (double)0.0, (double)Math.max(0.0, (double)dirZ / 2.0), (double)Math.max(0.5, (double)dirX), (double)height, (double)Math.max(0.5, (double)dirZ));
    }

    private static boolean stepHigh(BlockPos offsetPos, double stepHeight, IWorldReader world, ISelectionContext context) {
        if (!world.func_175667_e(offsetPos) || !world.func_175723_af().func_177746_a(offsetPos)) {
            return true;
        }
        BlockState neighbor = world.func_180495_p(offsetPos);
        return StolenReposeCode.blockHeight(offsetPos, (IBlockReader)world, neighbor, context) >= stepHeight;
    }

    private static double blockHeight(BlockPos pos, IBlockReader world, BlockState blockState, ISelectionContext context) {
        return StolenReposeCode.getStateCollisionShape(blockState, world, pos, context).func_197758_c(Direction.Axis.Y);
    }

    private static boolean canSlopeAt(BlockState state, IBlockReader worldIn, BlockPos pos, VoxelShape collisionBoundingBox, ISelectionContext context) {
        boolean flag = collisionBoundingBox != null && collisionBoundingBox.func_197758_c(Direction.Axis.Y) > 0.5;
        BlockPos posUp = pos.func_177984_a();
        return IsSmoothable.TERRAIN_SMOOTHABLE.apply(state) && flag && StolenReposeCode.getStateCollisionShape(worldIn.func_180495_p(posUp), worldIn, posUp, context).func_197766_b();
    }

    @Nonnull
    private static VoxelShape getStateCollisionShape(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (state == StateHolder.SNOW_LAYER_DEFAULT) {
            return VoxelShapes.func_197880_a();
        }
        return state.func_215685_b(world, pos, context);
    }

    private static enum Direction {
        North(0, -1),
        South(0, 1),
        East(1, 0),
        West(-1, 0),
        NorthEast(Direction.North.x + Direction.East.x, Direction.North.z + Direction.East.z),
        NorthWest(Direction.North.x + Direction.West.x, Direction.North.z + Direction.West.z),
        SouthEast(Direction.South.x + Direction.East.x, Direction.South.z + Direction.East.z),
        SouthWest(Direction.South.x + Direction.West.x, Direction.South.z + Direction.West.z);

        public static final ImmutableList<Direction> OrdinalDirections;
        private final int x;
        private final int z;

        private Direction(int x, int z) {
            this.x = x;
            this.z = z;
        }

        static {
            OrdinalDirections = ImmutableList.of((Object)((Object)NorthEast), (Object)((Object)NorthWest), (Object)((Object)SouthEast), (Object)((Object)SouthWest));
        }
    }
}

