/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.collision;

import io.github.cadiboo.nocubes.util.ModProfiler;
import io.github.cadiboo.nocubes.util.pooled.Face;
import io.github.cadiboo.nocubes.util.pooled.Vec3;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public final class MeshCollisionUtil {
    static void addIntersectingFaceShapesToList(List<VoxelShape> outShapes, Face face, ModProfiler profiler, double maxYLevel, Predicate<VoxelShape> doesShapeIntersect, boolean offsetShapes) {
        profiler.start("interpolate");
        Vec3 v0 = face.getVertex0();
        Vec3 v1 = face.getVertex1();
        Vec3 v2 = face.getVertex2();
        Vec3 v3 = face.getVertex3();
        Vec3 v0v1 = MeshCollisionUtil.interp(v0, v1, 0.5f);
        Vec3 v1v2 = MeshCollisionUtil.interp(v1, v2, 0.5f);
        Vec3 v2v3 = MeshCollisionUtil.interp(v2, v3, 0.5f);
        Vec3 v3v0 = MeshCollisionUtil.interp(v3, v0, 0.5f);
        Vec3 v0v1v1v2 = MeshCollisionUtil.interp(v0v1, v1v2, 0.5f);
        Vec3 v1v2v2v3 = MeshCollisionUtil.interp(v1v2, v2v3, 0.5f);
        Vec3 v2v3v3v0 = MeshCollisionUtil.interp(v2v3, v3v0, 0.5f);
        Vec3 v3v0v0v1 = MeshCollisionUtil.interp(v3v0, v0v1, 0.5f);
        profiler.endStartSection("createShapes");
        VoxelShape v0v1shape = MeshCollisionUtil.createShape(v0v1, maxYLevel, offsetShapes);
        VoxelShape v1v2shape = MeshCollisionUtil.createShape(v1v2, maxYLevel, offsetShapes);
        VoxelShape v2v3shape = MeshCollisionUtil.createShape(v2v3, maxYLevel, offsetShapes);
        VoxelShape v3v0shape = MeshCollisionUtil.createShape(v3v0, maxYLevel, offsetShapes);
        VoxelShape v0v1v1v2shape = MeshCollisionUtil.createShape(v0v1v1v2, maxYLevel, offsetShapes);
        VoxelShape v1v2v2v3shape = MeshCollisionUtil.createShape(v1v2v2v3, maxYLevel, offsetShapes);
        VoxelShape v2v3v3v0shape = MeshCollisionUtil.createShape(v2v3v3v0, maxYLevel, offsetShapes);
        VoxelShape v3v0v0v1shape = MeshCollisionUtil.createShape(v3v0v0v1, maxYLevel, offsetShapes);
        profiler.endStartSection("addShapes");
        MeshCollisionUtil.addShape(outShapes, v0v1shape, doesShapeIntersect);
        MeshCollisionUtil.addShape(outShapes, v1v2shape, doesShapeIntersect);
        MeshCollisionUtil.addShape(outShapes, v2v3shape, doesShapeIntersect);
        MeshCollisionUtil.addShape(outShapes, v3v0shape, doesShapeIntersect);
        MeshCollisionUtil.addShape(outShapes, v0v1v1v2shape, doesShapeIntersect);
        MeshCollisionUtil.addShape(outShapes, v1v2v2v3shape, doesShapeIntersect);
        MeshCollisionUtil.addShape(outShapes, v2v3v3v0shape, doesShapeIntersect);
        MeshCollisionUtil.addShape(outShapes, v3v0v0v1shape, doesShapeIntersect);
        profiler.endSection();
        v0.close();
        v1.close();
        v2.close();
        v3.close();
        v0v1.close();
        v1v2.close();
        v2v3.close();
        v3v0.close();
        v0v1v1v2.close();
        v1v2v2v3.close();
        v2v3v3v0.close();
        v3v0v0v1.close();
    }

    private static void addShape(List<VoxelShape> collidingShapes, VoxelShape shape, Predicate<VoxelShape> doesShapeIntersect) {
        if (doesShapeIntersect.test(shape)) {
            collidingShapes.add(shape);
        }
    }

    private static Vec3 interp(Vec3 v0, Vec3 v1, float t) {
        return Vec3.retain(v0.x + (double)t * (v1.x - v0.x), v0.y + (double)t * (v1.y - v0.y), v0.z + (double)t * (v1.z - v0.z));
    }

    private static VoxelShape createShape(Vec3 vec3, double maxY, boolean offsetShape) {
        boolean isYOverMax;
        float boxRadius = 0.15f;
        double vy = vec3.y;
        double vx = vec3.x;
        double vz = vec3.z;
        boolean bl = isYOverMax = vy + (double)0.15f > maxY;
        if (offsetShape) {
            return VoxelShapes.func_197873_a((double)(vx - (double)0.15f), (double)(isYOverMax ? vy - (double)0.15f - (double)0.15f : vy - (double)0.15f), (double)(vz - (double)0.15f), (double)(vx + (double)0.15f), (double)(isYOverMax ? vy : vy + (double)0.15f), (double)(vz + (double)0.15f));
        }
        return VoxelShapes.func_197873_a((double)-0.15f, (double)(isYOverMax ? (double)-0.3f : (double)-0.15f), (double)-0.15f, (double)0.15f, (double)(isYOverMax ? 0.0 : (double)0.15f), (double)0.15f);
    }
}

