/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.collision;

import io.github.cadiboo.nocubes.collision.StolenReposeCode;
import io.github.cadiboo.nocubes.config.Config;
import java.util.ArrayList;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.IChunk;

public final class CollisionHandler {
    public static boolean shouldApplyMeshCollisions(@Nullable Entity entity) {
        return false;
    }

    public static boolean shouldApplyReposeCollisions(@Nullable Entity entity) {
        return entity instanceof ItemEntity || entity instanceof LivingEntity;
    }

    @Nonnull
    public static Stream<VoxelShape> getCollisionShapes(IWorldReader _this, Entity entity, AxisAlignedBB aabb, int minXm1, int maxXp1, int minYm1, int maxYp1, int minZm1, int maxZp1, ISelectionContext context) {
        if (!Config.terrainCollisions) {
            return CollisionHandler.getVanillaCollisions(_this, entity, aabb, minXm1, maxXp1, minYm1, maxYp1, minZm1, maxZp1, context);
        }
        if (CollisionHandler.shouldApplyMeshCollisions(entity)) {
            return CollisionHandler.getMeshCollisions(_this, entity, aabb, minXm1, maxXp1, minYm1, maxYp1, minZm1, maxZp1, context);
        }
        if (CollisionHandler.shouldApplyReposeCollisions(entity)) {
            return CollisionHandler.getReposeCollisions(_this, entity, aabb, minXm1, maxXp1, minYm1, maxYp1, minZm1, maxZp1, context);
        }
        return CollisionHandler.getVanillaCollisions(_this, entity, aabb, minXm1, maxXp1, minYm1, maxYp1, minZm1, maxZp1, context);
    }

    /*
     * Exception decompiling
     */
    public static Stream<VoxelShape> getMeshCollisions(IWorldReader _this, Entity entity, AxisAlignedBB aabb, int minXm1, int maxXp1, int minYm1, int maxYp1, int minZm1, int maxZp1, ISelectionContext context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 8 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Stream<VoxelShape> getFallbackMeshCollisions(IWorldReader _this, Entity entity, AxisAlignedBB aabb, int minXm1, int maxXp1, int minYm1, int maxYp1, int minZm1, int maxZp1, ISelectionContext context) {
        return CollisionHandler.getVanillaCollisions(_this, entity, aabb, minXm1, maxXp1, minYm1, maxYp1, minZm1, maxZp1, context);
    }

    private static Stream<VoxelShape> getReposeCollisions(IWorldReader _this, Entity entity, AxisAlignedBB aabb, int minXm1, int maxXp1, int minYm1, int maxYp1, int minZm1, int maxZp1, ISelectionContext context) {
        ArrayList<VoxelShape> collidingShapes = new ArrayList<VoxelShape>();
        VoxelShape aabbShape = VoxelShapes.func_197881_a((AxisAlignedBB)aabb);
        try (BlockPos.PooledMutableBlockPos pooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (int z = minZm1; z < maxZp1; ++z) {
                for (int y = minYm1; y < maxYp1; ++y) {
                    for (int x = minXm1; x < maxXp1; ++x) {
                        pooledMutableBlockPos.func_181079_c(x, y, z);
                        BlockState blockState = _this.func_180495_p((BlockPos)pooledMutableBlockPos);
                        VoxelShape offsetCollisionShape = blockState.nocubes_isTerrainSmoothable ? StolenReposeCode.getCollisionShape(blockState, _this, (BlockPos)pooledMutableBlockPos, context).func_197751_a((double)x, (double)y, (double)z) : blockState.func_215685_b((IBlockReader)_this, (BlockPos)pooledMutableBlockPos, context).func_197751_a((double)x, (double)y, (double)z);
                        if (!VoxelShapes.func_197879_c((VoxelShape)aabbShape, (VoxelShape)offsetCollisionShape, (IBooleanFunction)IBooleanFunction.field_223238_i_)) continue;
                        collidingShapes.add(offsetCollisionShape);
                    }
                }
            }
        }
        return collidingShapes.stream();
    }

    private static Stream<VoxelShape> getVanillaCollisions(final IWorldReader _this, final Entity entity, AxisAlignedBB aabb, int minXm1, int maxXp1, int minYm1, int maxYp1, int minZm1, int maxZp1, final ISelectionContext context) {
        final CubeCoordinateIterator cubecoordinateiterator = new CubeCoordinateIterator(minXm1, minYm1, minZm1, maxXp1, maxYp1, maxZp1);
        final BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        final VoxelShape voxelshape = VoxelShapes.func_197881_a((AxisAlignedBB)aabb);
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<VoxelShape>(Long.MAX_VALUE, 1280){
            boolean isEntityNull;
            {
                super(x0, x1);
                this.isEntityNull = entity == null;
            }

            @Override
            public boolean tryAdvance(Consumer<? super VoxelShape> p_tryAdvance_1_) {
                VoxelShape voxelshape3;
                if (!this.isEntityNull) {
                    this.isEntityNull = true;
                    VoxelShape voxelshape1 = _this.func_175723_af().func_222521_a();
                    boolean flag = VoxelShapes.func_197879_c((VoxelShape)voxelshape1, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)entity.func_174813_aQ().func_186664_h(1.0E-7)), (IBooleanFunction)IBooleanFunction.field_223238_i_);
                    boolean flag1 = VoxelShapes.func_197879_c((VoxelShape)voxelshape1, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)entity.func_174813_aQ().func_186662_g(1.0E-7)), (IBooleanFunction)IBooleanFunction.field_223238_i_);
                    if (!flag && flag1) {
                        p_tryAdvance_1_.accept((VoxelShape)voxelshape1);
                        return true;
                    }
                }
                while (true) {
                    VoxelShape voxelshape2;
                    int i2;
                    int l1;
                    IChunk ichunk;
                    if (!cubecoordinateiterator.func_218301_a()) {
                        return false;
                    }
                    int j2 = cubecoordinateiterator.func_218304_b();
                    int k2 = cubecoordinateiterator.func_218302_c();
                    int l2 = cubecoordinateiterator.func_218303_d();
                    int k1 = cubecoordinateiterator.func_223473_e();
                    if (k1 == 3 || (ichunk = _this.func_217353_a(l1 = j2 >> 4, i2 = l2 >> 4, _this.func_217342_O(), false)) == null) continue;
                    blockpos$mutableblockpos.func_181079_c(j2, k2, l2);
                    BlockState blockstate = ichunk.func_180495_p((BlockPos)blockpos$mutableblockpos);
                    if ((k1 != 1 || blockstate.func_215704_f()) && (k1 != 2 || blockstate.func_177230_c() == Blocks.field_196603_bb) && VoxelShapes.func_197879_c((VoxelShape)voxelshape, (VoxelShape)(voxelshape3 = (voxelshape2 = blockstate.func_215685_b((IBlockReader)_this, (BlockPos)blockpos$mutableblockpos, context)).func_197751_a((double)j2, (double)k2, (double)l2)), (IBooleanFunction)IBooleanFunction.field_223238_i_)) break;
                }
                p_tryAdvance_1_.accept((VoxelShape)voxelshape3);
                return true;
            }
        }, false);
    }

    private static /* synthetic */ boolean lambda$getMeshCollisions$0(VoxelShape aabbShape, VoxelShape checkShape) {
        return VoxelShapes.func_197879_c((VoxelShape)aabbShape, (VoxelShape)checkShape, (IBooleanFunction)IBooleanFunction.field_223238_i_);
    }
}

