/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.render;

import io.github.cadiboo.nocubes.client.ClientCacheUtil;
import io.github.cadiboo.nocubes.client.LazyBlockColorCache;
import io.github.cadiboo.nocubes.client.LazyPackedLightCache;
import io.github.cadiboo.nocubes.client.UVHelper;
import io.github.cadiboo.nocubes.client.render.MeshRenderer;
import io.github.cadiboo.nocubes.client.render.OptimisedFluidBlockRenderer;
import io.github.cadiboo.nocubes.config.Config;
import io.github.cadiboo.nocubes.mesh.MeshDispatcher;
import io.github.cadiboo.nocubes.mesh.MeshGenerator;
import io.github.cadiboo.nocubes.mesh.MeshGeneratorType;
import io.github.cadiboo.nocubes.mesh.generator.OldNoCubes;
import io.github.cadiboo.nocubes.util.CacheUtil;
import io.github.cadiboo.nocubes.util.IsSmoothable;
import io.github.cadiboo.nocubes.util.ModProfiler;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.pooled.Face;
import io.github.cadiboo.nocubes.util.pooled.FaceList;
import io.github.cadiboo.nocubes.util.pooled.Vec3;
import io.github.cadiboo.nocubes.util.pooled.Vec3b;
import io.github.cadiboo.nocubes.util.pooled.cache.DensityCache;
import io.github.cadiboo.nocubes.util.pooled.cache.SmoothableCache;
import io.github.cadiboo.nocubes.util.pooled.cache.StateCache;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.chunk.ChunkRender;
import net.minecraft.client.renderer.chunk.ChunkRenderTask;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.BiomeColors;

public final class RenderDispatcher {
    private static final Predicate<BlockState> IS_BLOCK_STATE_GRASS = blockState -> ModUtil.isMaterialGrass(blockState.func_185904_a());
    private static final Predicate<BlockState> IS_BLOCK_STATE_LEAVES = blockState -> ModUtil.isMaterialLeaves(blockState.func_185904_a());
    private static final Predicate<BlockState> ALWAYS_TRUE = blockState -> true;

    public static void renderChunk(@Nonnull ChunkRender chunkRender, @Nonnull BlockPos chunkRenderPos, @Nonnull ChunkRenderTask chunkRenderTask, @Nonnull CompiledChunk compiledChunk, @Nonnull IWorld world, @Nonnull IEnviromentBlockReader chunkRenderCache, @Nonnull boolean[] usedBlockRenderLayers, @Nonnull Random random, @Nonnull BlockRendererDispatcher blockRendererDispatcher) {
        MeshGenerator meshGenerator;
        int chunkRenderPosX = chunkRenderPos.func_177958_n();
        int chunkRenderPosY = chunkRenderPos.func_177956_o();
        int chunkRenderPosZ = chunkRenderPos.func_177952_p();
        int stateCachePaddingX = 0;
        int stateCachePaddingY = 0;
        int stateCachePaddingZ = 0;
        int stateCacheEndX = 0;
        int stateCacheEndY = 0;
        int stateCacheEndZ = 0;
        stateCachePaddingX = 2;
        stateCachePaddingY = 2;
        stateCachePaddingZ = 2;
        stateCacheEndX = 18;
        stateCacheEndY = 18;
        stateCacheEndZ = 18;
        if (Config.renderSmoothTerrain) {
            meshGenerator = Config.terrainMeshGenerator.getMeshGenerator();
            stateCacheEndX = Math.max(stateCacheEndX, ModUtil.getMeshSizeX(17, meshGenerator));
            stateCacheEndY = Math.max(stateCacheEndY, ModUtil.getMeshSizeY(17, meshGenerator));
            stateCacheEndZ = Math.max(stateCacheEndZ, ModUtil.getMeshSizeZ(17, meshGenerator));
            stateCachePaddingX = Math.max(stateCachePaddingX, 1);
            stateCachePaddingY = Math.max(stateCachePaddingY, 1);
            stateCachePaddingZ = Math.max(stateCachePaddingZ, 1);
        }
        if (Config.renderSmoothLeaves) {
            meshGenerator = Config.leavesMeshGenerator.getMeshGenerator();
            stateCacheEndX = Math.max(stateCacheEndX, ModUtil.getMeshSizeX(17, meshGenerator));
            stateCacheEndY = Math.max(stateCacheEndY, ModUtil.getMeshSizeY(17, meshGenerator));
            stateCacheEndZ = Math.max(stateCacheEndZ, ModUtil.getMeshSizeZ(17, meshGenerator));
            stateCachePaddingX = Math.max(stateCachePaddingX, 1);
            stateCachePaddingY = Math.max(stateCachePaddingY, 1);
            stateCachePaddingZ = Math.max(stateCachePaddingZ, 1);
        }
        if (Config.renderSmoothTerrain || Config.renderSmoothLeaves) {
            stateCacheEndX = Math.max(stateCacheEndX, 18);
            stateCacheEndY = Math.max(stateCacheEndY, 18);
            stateCacheEndZ = Math.max(stateCacheEndZ, 18);
            stateCachePaddingX = Math.max(stateCachePaddingX, 2);
            stateCachePaddingY = Math.max(stateCachePaddingY, 2);
            stateCachePaddingZ = Math.max(stateCachePaddingZ, 2);
        }
        try (BlockPos.PooledMutableBlockPos pooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
             StateCache stateCache = CacheUtil.generateStateCache(chunkRenderPosX - stateCachePaddingX, chunkRenderPosY - stateCachePaddingY, chunkRenderPosZ - stateCachePaddingZ, chunkRenderPosX + stateCacheEndX, chunkRenderPosY + stateCacheEndY, chunkRenderPosZ + stateCacheEndZ, stateCachePaddingX, stateCachePaddingY, stateCachePaddingZ, (IWorldReader)world, pooledMutableBlockPos);
             LazyPackedLightCache lazyPackedLightCache = ClientCacheUtil.generateLazyPackedLightCache(chunkRenderPosX - 2, chunkRenderPosY - 2, chunkRenderPosZ - 2, chunkRenderPosX + 18, chunkRenderPosY + 18, chunkRenderPosZ + 18, 2, 2, 2, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, stateCache, chunkRenderCache);){
            MeshGenerator meshGenerator2;
            block116: {
                if (Config.renderSmoothTerrain) {
                    meshGenerator2 = Config.terrainMeshGenerator.getMeshGenerator();
                    byte meshSizeX = ModUtil.getMeshSizeX(17, meshGenerator2);
                    byte meshSizeY = ModUtil.getMeshSizeY(17, meshGenerator2);
                    byte meshSizeZ = ModUtil.getMeshSizeZ(17, meshGenerator2);
                    try (SmoothableCache smoothableCache = CacheUtil.generateSmoothableCache(chunkRenderPosX - 1, chunkRenderPosY - 1, chunkRenderPosZ - 1, chunkRenderPosX + meshSizeX, chunkRenderPosY + meshSizeY, chunkRenderPosZ + meshSizeZ, 1, 1, 1, stateCache, IsSmoothable.TERRAIN_SMOOTHABLE);
                         DensityCache densityCache = CacheUtil.generateDensityCache(chunkRenderPosX - 1, chunkRenderPosY - 1, chunkRenderPosZ - 1, chunkRenderPosX + meshSizeX - 1, chunkRenderPosY + meshSizeY - 1, chunkRenderPosZ + meshSizeZ - 1, 1, 1, 1, stateCache, smoothableCache);){
                        try (LazyBlockColorCache lazyBlockColorCache = ClientCacheUtil.generateLazyBlockColorCache(chunkRenderPosX - 2, chunkRenderPosY - 2, chunkRenderPosZ - 2, chunkRenderPosX + 18, chunkRenderPosY + 18, chunkRenderPosZ + 18, 2, 2, 2, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, chunkRenderCache, BiomeColors.field_180290_c, ALWAYS_TRUE);
                             ModProfiler ignored = ModProfiler.get().start("OptimisedFluidBlockRenderer_renderChunkDensity");){
                            OptimisedFluidBlockRenderer.renderChunk(chunkRender, chunkRenderPos, chunkRenderTask, compiledChunk, chunkRenderCache, usedBlockRenderLayers, random, blockRendererDispatcher, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, pooledMutableBlockPos, stateCache, lazyPackedLightCache, lazyBlockColorCache, Config.terrainMeshGenerator == MeshGeneratorType.OldNoCubes ? null : densityCache);
                        }
                        RenderDispatcher.renderTerrainChunk(chunkRender, chunkRenderPos, chunkRenderTask, compiledChunk, chunkRenderCache, usedBlockRenderLayers, random, blockRendererDispatcher, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, pooledMutableBlockPos, stateCache, lazyPackedLightCache, meshGenerator2, meshSizeX, meshSizeY, meshSizeZ, smoothableCache, densityCache);
                        break block116;
                    }
                }
                try (LazyBlockColorCache lazyBlockColorCache = ClientCacheUtil.generateLazyBlockColorCache(chunkRenderPosX - 2, chunkRenderPosY - 2, chunkRenderPosZ - 2, chunkRenderPosX + 18, chunkRenderPosY + 18, chunkRenderPosZ + 18, 2, 2, 2, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, chunkRenderCache, BiomeColors.field_180290_c, ALWAYS_TRUE);
                     ModProfiler ignored = ModProfiler.get().start("OptimisedFluidBlockRenderer_renderChunk");){
                    OptimisedFluidBlockRenderer.renderChunk(chunkRender, chunkRenderPos, chunkRenderTask, compiledChunk, chunkRenderCache, usedBlockRenderLayers, random, blockRendererDispatcher, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, pooledMutableBlockPos, stateCache, lazyPackedLightCache, lazyBlockColorCache, null);
                }
            }
            if (Config.renderSmoothLeaves) {
                meshGenerator2 = Config.leavesMeshGenerator.getMeshGenerator();
                byte meshSizeX = ModUtil.getMeshSizeX(17, meshGenerator2);
                byte meshSizeY = ModUtil.getMeshSizeY(17, meshGenerator2);
                byte meshSizeZ = ModUtil.getMeshSizeZ(17, meshGenerator2);
                RenderDispatcher.renderLeavesChunk(chunkRender, chunkRenderPos, chunkRenderTask, compiledChunk, chunkRenderCache, usedBlockRenderLayers, random, blockRendererDispatcher, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, pooledMutableBlockPos, stateCache, lazyPackedLightCache, meshGenerator2, meshSizeX, meshSizeY, meshSizeZ);
            }
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.func_85055_a((Throwable)e, (String)"Error rendering NoCubes chunk!");
            crashReport.func_85058_a("Rendering chunk");
            throw new ReportedException(crashReport);
        }
    }

    private static void renderTerrainChunk(@Nonnull ChunkRender chunkRender, @Nonnull BlockPos chunkRenderPos, @Nonnull ChunkRenderTask chunkRenderTask, @Nonnull CompiledChunk compiledChunk, @Nonnull IEnviromentBlockReader chunkRenderCache, @Nonnull boolean[] usedBlockRenderLayers, @Nonnull Random random, @Nonnull BlockRendererDispatcher blockRendererDispatcher, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, BlockPos.PooledMutableBlockPos pooledMutableBlockPos, StateCache stateCache, LazyPackedLightCache lazyPackedLightCache, MeshGenerator meshGenerator, byte meshSizeX, byte meshSizeY, byte meshSizeZ, SmoothableCache smoothableCache, DensityCache densityCache) {
        try (BlockPos.PooledMutableBlockPos texturePooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
             LazyBlockColorCache lazyBlockColorCache = ClientCacheUtil.generateLazyBlockColorCache(chunkRenderPosX - 2, chunkRenderPosY - 2, chunkRenderPosZ - 2, chunkRenderPosX + 18, chunkRenderPosY + 18, chunkRenderPosZ + 18, 2, 2, 2, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, chunkRenderCache, BiomeColors.field_180291_a, IS_BLOCK_STATE_GRASS);){
            HashMap<Vec3b, FaceList> mesh = Config.terrainMeshGenerator == MeshGeneratorType.OldNoCubes ? OldNoCubes.generateChunk(chunkRenderPos, (IBlockReader)chunkRenderCache, IsSmoothable.TERRAIN_SMOOTHABLE, pooledMutableBlockPos) : MeshDispatcher.offsetChunkMesh(chunkRenderPos, meshGenerator.generateChunk(densityCache.getDensityCache(), new byte[]{meshSizeX, meshSizeY, meshSizeZ}));
            MeshRenderer.renderMesh(chunkRender, chunkRenderTask, compiledChunk, chunkRenderPos, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, chunkRenderCache, stateCache, blockRendererDispatcher, random, lazyPackedLightCache, lazyBlockColorCache, mesh, smoothableCache, pooledMutableBlockPos, texturePooledMutableBlockPos, usedBlockRenderLayers, false, true, true);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void renderLeavesChunk(@Nonnull ChunkRender chunkRender, @Nonnull BlockPos chunkRenderPos, @Nonnull ChunkRenderTask generator, @Nonnull CompiledChunk compiledChunk, @Nonnull IEnviromentBlockReader chunkRenderCache, @Nonnull boolean[] usedBlockRenderLayers, @Nonnull Random random, @Nonnull BlockRendererDispatcher blockRendererDispatcher, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, BlockPos.PooledMutableBlockPos pooledMutableBlockPos, StateCache stateCache, LazyPackedLightCache lazyPackedLightCache, MeshGenerator meshGenerator, byte meshSizeX, byte meshSizeY, byte meshSizeZ) {
        texturePooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        var19_19 = null;
        try {
            lazyBlockColorCache = ClientCacheUtil.generateLazyBlockColorCache(chunkRenderPosX - 2, chunkRenderPosY - 2, chunkRenderPosZ - 2, chunkRenderPosX + 18, chunkRenderPosY + 18, chunkRenderPosZ + 18, 2, 2, 2, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, chunkRenderCache, BiomeColors.field_180289_b, RenderDispatcher.IS_BLOCK_STATE_LEAVES);
            var21_23 = null;
            try {
                switch (1.$SwitchMap$io$github$cadiboo$nocubes$util$SmoothLeavesType[Config.smoothLeavesType.ordinal()]) {
                    case 1: {
                        for (Block smoothableBlock : Config.leavesSmoothableBlocks) {
                            isSmoothable = (IsSmoothable)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/block/BlockState;)Z, lambda$renderLeavesChunk$3(net.minecraft.block.Block net.minecraft.block.BlockState ), (Lnet/minecraft/block/BlockState;)Z)((Block)smoothableBlock);
                            smoothableCache = CacheUtil.generateSmoothableCache(chunkRenderPosX - 1, chunkRenderPosY - 1, chunkRenderPosZ - 1, chunkRenderPosX + meshSizeX, chunkRenderPosY + meshSizeY, chunkRenderPosZ + meshSizeZ, 1, 1, 1, stateCache, isSmoothable);
                            var26_35 = null;
                            try {
                                densityCache = CacheUtil.generateDensityCache(chunkRenderPosX - 1, chunkRenderPosY - 1, chunkRenderPosZ - 1, chunkRenderPosX + meshSizeX - 1, chunkRenderPosY + meshSizeY - 1, chunkRenderPosZ + meshSizeZ - 1, 1, 1, 1, stateCache, smoothableCache);
                                var28_43 = null;
                                try {
                                    mesh = Config.leavesMeshGenerator == MeshGeneratorType.OldNoCubes ? OldNoCubes.generateChunk(chunkRenderPos, (IBlockReader)chunkRenderCache, isSmoothable, pooledMutableBlockPos) : MeshDispatcher.offsetChunkMesh(chunkRenderPos, meshGenerator.generateChunk(densityCache.getDensityCache(), new byte[]{meshSizeX, meshSizeY, meshSizeZ}));
                                    MeshRenderer.renderMesh(chunkRender, generator, compiledChunk, chunkRenderPos, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, chunkRenderCache, stateCache, blockRendererDispatcher, random, lazyPackedLightCache, lazyBlockColorCache, mesh, smoothableCache, pooledMutableBlockPos, texturePooledMutableBlockPos, usedBlockRenderLayers, true, true, false);
                                }
                                catch (Throwable var29_46) {
                                    var28_43 = var29_46;
                                    throw var29_46;
                                }
                                finally {
                                    if (densityCache == null) continue;
                                    if (var28_43 != null) {
                                        try {
                                            densityCache.close();
                                        }
                                        catch (Throwable var29_45) {
                                            var28_43.addSuppressed(var29_45);
                                        }
                                        continue;
                                    }
                                    densityCache.close();
                                }
                            }
                            catch (Throwable densityCache) {
                                var26_35 = densityCache;
                                throw densityCache;
                            }
                            finally {
                                if (smoothableCache == null) continue;
                                if (var26_35 != null) {
                                    try {
                                        smoothableCache.close();
                                    }
                                    catch (Throwable densityCache) {
                                        var26_35.addSuppressed(densityCache);
                                    }
                                    continue;
                                }
                                smoothableCache.close();
                            }
                        }
                        break;
                    }
                    case 2: {
                        isSmoothable = IsSmoothable.LEAVES_SMOOTHABLE;
                        smoothableCache = CacheUtil.generateSmoothableCache(chunkRenderPosX - 1, chunkRenderPosY - 1, chunkRenderPosZ - 1, chunkRenderPosX + meshSizeX, chunkRenderPosY + meshSizeY, chunkRenderPosZ + meshSizeZ, 1, 1, 1, stateCache, isSmoothable);
                        var24_30 = null;
                        densityCache = CacheUtil.generateDensityCache(chunkRenderPosX - 1, chunkRenderPosY - 1, chunkRenderPosZ - 1, chunkRenderPosX + meshSizeX - 1, chunkRenderPosY + meshSizeY - 1, chunkRenderPosZ + meshSizeZ - 1, 1, 1, 1, stateCache, smoothableCache);
                        var26_36 = null;
                        try {
                            mesh = Config.leavesMeshGenerator == MeshGeneratorType.OldNoCubes ? OldNoCubes.generateChunk(chunkRenderPos, (IBlockReader)chunkRenderCache, isSmoothable, pooledMutableBlockPos) : MeshDispatcher.offsetChunkMesh(chunkRenderPos, meshGenerator.generateChunk(densityCache.getDensityCache(), new byte[]{meshSizeX, meshSizeY, meshSizeZ}));
                            MeshRenderer.renderMesh(chunkRender, generator, compiledChunk, chunkRenderPos, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, chunkRenderCache, stateCache, blockRendererDispatcher, random, lazyPackedLightCache, lazyBlockColorCache, mesh, smoothableCache, pooledMutableBlockPos, texturePooledMutableBlockPos, usedBlockRenderLayers, true, true, false);
                        }
                        catch (Throwable var27_42) {
                            var26_36 = var27_42;
                            throw var27_42;
                        }
                        finally {
                            if (densityCache != null) {
                                if (var26_36 != null) {
                                    try {
                                        densityCache.close();
                                    }
                                    catch (Throwable var27_41) {
                                        var26_36.addSuppressed(var27_41);
                                    }
                                } else {
                                    densityCache.close();
                                }
                            }
                        }
                        if (smoothableCache == null) ** break;
                        if (var24_30 == null) ** GOTO lbl84
                        try {
                            smoothableCache.close();
                            ** break;
lbl79:
                            // 1 sources

                        }
                        catch (Throwable var25_33) {
                            var24_30.addSuppressed(var25_33);
                            ** break;
                        }
lbl83:
                        // 1 sources

                        break;
lbl84:
                        // 1 sources

                        smoothableCache.close();
                        ** break;
lbl86:
                        // 1 sources

                        break;
                        catch (Throwable var25_34) {
                            try {
                                var24_30 = var25_34;
                                throw var25_34;
                            }
                            catch (Throwable var36_53) {
                                if (smoothableCache != null) {
                                    if (var24_30 != null) {
                                        try {
                                            smoothableCache.close();
                                        }
                                        catch (Throwable var37_54) {
                                            var24_30.addSuppressed(var37_54);
                                        }
                                    } else {
                                        smoothableCache.close();
                                    }
                                }
                                throw var36_53;
                            }
                        }
                    }
                    ** default:
lbl103:
                    // 1 sources

                    break;
                }
            }
            catch (Throwable var22_26) {
                var21_23 = var22_26;
                throw var22_26;
            }
            finally {
                if (lazyBlockColorCache != null) {
                    if (var21_23 != null) {
                        try {
                            lazyBlockColorCache.close();
                        }
                        catch (Throwable var22_25) {
                            var21_23.addSuppressed(var22_25);
                        }
                    } else {
                        lazyBlockColorCache.close();
                    }
                }
            }
        }
        catch (Throwable var20_22) {
            var19_19 = var20_22;
            throw var20_22;
        }
        finally {
            if (texturePooledMutableBlockPos != null) {
                if (var19_19 != null) {
                    try {
                        texturePooledMutableBlockPos.close();
                    }
                    catch (Throwable var20_21) {
                        var19_19.addSuppressed(var20_21);
                    }
                } else {
                    texturePooledMutableBlockPos.close();
                }
            }
        }
    }

    public static void renderSmoothBlockDamage(Tessellator tessellatorIn, BufferBuilder bufferBuilderIn, BlockPos blockpos, BlockState iblockstate, IEnviromentBlockReader world, TextureAtlasSprite textureatlassprite) {
        MeshGeneratorType meshGeneratorType;
        IsSmoothable isSmoothable;
        if (iblockstate.func_185901_i() != BlockRenderType.MODEL) {
            return;
        }
        if (Config.renderSmoothTerrain && iblockstate.nocubes_isTerrainSmoothable) {
            isSmoothable = IsSmoothable.TERRAIN_SMOOTHABLE;
            meshGeneratorType = Config.terrainMeshGenerator;
        } else if (Config.renderSmoothLeaves && iblockstate.nocubes_isLeavesSmoothable) {
            isSmoothable = IsSmoothable.LEAVES_SMOOTHABLE;
            meshGeneratorType = Config.leavesMeshGenerator;
        } else {
            return;
        }
        tessellatorIn.func_78381_a();
        bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        try (FaceList faces = MeshDispatcher.generateBlockMeshOffset(blockpos, (IBlockReader)world, isSmoothable, meshGeneratorType);){
            float minU = UVHelper.getMinU(textureatlassprite);
            float maxU = UVHelper.getMaxU(textureatlassprite);
            float minV = UVHelper.getMinV(textureatlassprite);
            float maxV = UVHelper.getMaxV(textureatlassprite);
            int packed = iblockstate.func_215684_a(world, blockpos);
            int lightmapSkyLight = packed >> 16 & 0xFFFF;
            int lightmapBlockLight = packed & 0xFFFF;
            int facesSize = faces.size();
            for (int faceIndex = 0; faceIndex < facesSize; ++faceIndex) {
                try (Face face = (Face)faces.get(faceIndex);
                     Vec3 v0 = face.getVertex0();
                     Vec3 v1 = face.getVertex1();
                     Vec3 v2 = face.getVertex2();
                     Vec3 v3 = face.getVertex3();){
                    bufferBuilderIn.func_181662_b(v0.x, v0.y, v0.z).func_181669_b(255, 255, 255, 255).func_187315_a((double)minU, (double)minV).func_187314_a(lightmapSkyLight, lightmapBlockLight).func_181675_d();
                    bufferBuilderIn.func_181662_b(v1.x, v1.y, v1.z).func_181669_b(255, 255, 255, 255).func_187315_a((double)minU, (double)maxV).func_187314_a(lightmapSkyLight, lightmapBlockLight).func_181675_d();
                    bufferBuilderIn.func_181662_b(v2.x, v2.y, v2.z).func_181669_b(255, 255, 255, 255).func_187315_a((double)maxU, (double)maxV).func_187314_a(lightmapSkyLight, lightmapBlockLight).func_181675_d();
                    bufferBuilderIn.func_181662_b(v3.x, v3.y, v3.z).func_181669_b(255, 255, 255, 255).func_187315_a((double)maxU, (double)minV).func_187314_a(lightmapSkyLight, lightmapBlockLight).func_181675_d();
                    continue;
                }
            }
        }
        tessellatorIn.func_78381_a();
        bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        bufferBuilderIn.func_78914_f();
    }

    private static /* synthetic */ boolean lambda$renderLeavesChunk$3(Block smoothableBlock, BlockState checkState) {
        return IsSmoothable.LEAVES_SMOOTHABLE.apply(checkState) && checkState.func_177230_c() == smoothableBlock;
    }
}

