/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.render;

import io.github.cadiboo.nocubes.client.ClientEventSubscriber;
import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.client.LazyBlockColorCache;
import io.github.cadiboo.nocubes.client.LazyPackedLightCache;
import io.github.cadiboo.nocubes.client.optifine.OptiFineCompatibility;
import io.github.cadiboo.nocubes.client.render.SmoothLightingFluidBlockRenderer;
import io.github.cadiboo.nocubes.util.pooled.cache.DensityCache;
import io.github.cadiboo.nocubes.util.pooled.cache.StateCache;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.StainedGlassBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FluidBlockRenderer;
import net.minecraft.client.renderer.chunk.ChunkRender;
import net.minecraft.client.renderer.chunk.ChunkRenderTask;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.fluid.EmptyFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.client.ForgeHooksClient;

public final class OptimisedFluidBlockRenderer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderChunk(@Nonnull ChunkRender chunkRender, @Nonnull BlockPos chunkRenderPos, @Nonnull ChunkRenderTask generator, @Nonnull CompiledChunk compiledChunk, @Nonnull IEnviromentBlockReader chunkRenderCache, @Nonnull boolean[] usedBlockRenderLayers, @Nonnull Random random, @Nonnull BlockRendererDispatcher blockRendererDispatcher, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, BlockPos.PooledMutableBlockPos pooledMutableBlockPos, StateCache stateCache, LazyPackedLightCache lazyPackedLightCache, LazyBlockColorCache lazyBlockColorsCache, @Nullable DensityCache densityCache) {
        int densityCacheSizeX;
        int densityCacheSizeY;
        int densityCacheStartPaddingX;
        int densityCacheStartPaddingY;
        int densityCacheStartPaddingZ;
        float[] densityArray;
        IFluidState[] fluidStateArray = stateCache.getFluidStates();
        BlockState[] blockStateArray = stateCache.getBlockStates();
        int stateCacheSizeX = stateCache.sizeX;
        int stateCacheSizeY = stateCache.sizeY;
        int stateCacheStartPaddingX = stateCache.startPaddingX;
        int stateCacheStartPaddingY = stateCache.startPaddingY;
        int stateCacheStartPaddingZ = stateCache.startPaddingZ;
        if (densityCache == null) {
            densityArray = null;
            densityCacheStartPaddingZ = 0;
            densityCacheStartPaddingY = 0;
            densityCacheStartPaddingX = 0;
            densityCacheSizeY = 0;
            densityCacheSizeX = 0;
        } else {
            densityArray = densityCache.getDensityCache();
            densityCacheSizeX = densityCache.sizeX;
            densityCacheSizeY = densityCache.sizeY;
            densityCacheStartPaddingX = densityCache.startPaddingX;
            densityCacheStartPaddingY = densityCache.startPaddingY;
            densityCacheStartPaddingZ = densityCache.startPaddingZ;
        }
        SmoothLightingFluidBlockRenderer smoothLightingFluidBlockRenderer = ClientEventSubscriber.smoothLightingBlockFluidRenderer;
        FluidBlockRenderer fluidRenderer = blockRendererDispatcher.field_175025_e;
        if (smoothLightingFluidBlockRenderer == null || fluidRenderer == null) {
            String renderer = fluidRenderer == null ? "Vanilla Fluid Renderer" : "Smooth Lighting Fluid Renderer";
            CrashReport crashReport = CrashReport.func_85055_a((Throwable)new NullPointerException(), (String)(renderer + " is null!"));
            crashReport.func_85058_a("Rendering chunk");
            throw new ReportedException(crashReport);
        }
        TextureAtlasSprite atlasSpriteWaterOverlay = fluidRenderer.field_187501_d;
        TextureAtlasSprite[] atlasSpritesLava = fluidRenderer.field_178272_a;
        TextureAtlasSprite[] atlasSpritesWater = fluidRenderer.field_178271_b;
        int[] lazyPackedLightCacheCache = lazyPackedLightCache.cache;
        int lazyPackedLightCacheSizeX = lazyPackedLightCache.sizeX;
        int lazyPackedLightCacheSizeY = lazyPackedLightCache.sizeY;
        int lazyPackedLightCacheStartPaddingX = lazyPackedLightCache.startPaddingX;
        int lazyPackedLightCacheStartPaddingZ = lazyPackedLightCache.startPaddingZ;
        int lazyPackedLightCacheStartPaddingY = lazyPackedLightCache.startPaddingY;
        int lazyPackedLightCacheDiffX = stateCache.startPaddingX - lazyPackedLightCacheStartPaddingX;
        int lazyPackedLightCacheDiffY = stateCache.startPaddingY - lazyPackedLightCacheStartPaddingY;
        int lazyPackedLightCacheDiffZ = stateCache.startPaddingZ - lazyPackedLightCacheStartPaddingZ;
        IEnviromentBlockReader lazyPackedLightCacheReader = lazyPackedLightCache.reader;
        int[] lazyBlockColorsCacheCache = lazyBlockColorsCache.cache;
        int lazyBlockColorsCacheSizeX = lazyBlockColorsCache.sizeX;
        int lazyBlockColorsCacheSizeY = lazyBlockColorsCache.sizeY;
        int lazyBlockColorsCacheStartPaddingX = lazyBlockColorsCache.startPaddingX;
        int lazyBlockColorsCacheStartPaddingZ = lazyBlockColorsCache.startPaddingZ;
        int lazyBlockColorsCacheStartPaddingY = lazyBlockColorsCache.startPaddingY;
        int biomeBlendRadius = Minecraft.func_71410_x().field_71474_y.field_205217_U;
        int d = biomeBlendRadius * 2 + 1;
        int lazyBlockColorsCacheArea = d * d;
        int lazyBlockColorsCacheMax = biomeBlendRadius + 1;
        IEnviromentBlockReader lazyBlockColorsCacheReader = lazyBlockColorsCache.reader;
        BiomeColors.IColorResolver lazyBlockColorsCacheColorResolver = lazyBlockColorsCache.colorResolver;
        for (int z = 0; z < 16; ++z) {
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    int index = stateCache.getIndex(stateCacheStartPaddingX + x, stateCacheStartPaddingY + y, stateCacheStartPaddingZ + z, stateCacheSizeX, stateCacheSizeY);
                    IFluidState fluidState = fluidStateArray[index];
                    if (fluidState.func_206888_e()) continue;
                    pooledMutableBlockPos.func_181079_c(chunkRenderPosX + x, chunkRenderPosY + y, chunkRenderPosZ + z);
                    for (int i = 0; i < ClientUtil.BLOCK_RENDER_LAYER_VALUES_LENGTH; ++i) {
                        BlockRenderLayer initialBlockRenderLayer = ClientUtil.BLOCK_RENDER_LAYER_VALUES[i];
                        if (!fluidState.canRenderInLayer(initialBlockRenderLayer)) continue;
                        BlockRenderLayer correctedBlockRenderLayer = ClientUtil.getCorrectRenderLayer(initialBlockRenderLayer);
                        int correctedBlockRenderLayerOrdinal = correctedBlockRenderLayer.ordinal();
                        ForgeHooksClient.setRenderLayer((BlockRenderLayer)correctedBlockRenderLayer);
                        BufferBuilder bufferBuilder = ClientUtil.startOrContinueBufferBuilder(generator, correctedBlockRenderLayerOrdinal, compiledChunk, correctedBlockRenderLayer, chunkRender, chunkRenderPos);
                        OptiFineCompatibility.pushShaderThing(fluidState, (BlockPos)pooledMutableBlockPos, chunkRenderCache, bufferBuilder);
                        try {
                            int n = correctedBlockRenderLayerOrdinal;
                            usedBlockRenderLayers[n] = usedBlockRenderLayers[n] | OptimisedFluidBlockRenderer.renderBlock(smoothLightingFluidBlockRenderer, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, x, y, z, fluidStateArray, blockStateArray, stateCacheSizeX, stateCacheSizeY, stateCacheStartPaddingX, stateCacheStartPaddingY, stateCacheStartPaddingZ, stateCache, densityArray, densityCacheSizeX, densityCacheSizeY, densityCacheStartPaddingX, densityCacheStartPaddingY, densityCacheStartPaddingZ, densityCache, lazyPackedLightCache, lazyPackedLightCacheCache, lazyPackedLightCacheSizeX, lazyPackedLightCacheSizeY, lazyPackedLightCacheStartPaddingX, lazyPackedLightCacheStartPaddingY, lazyPackedLightCacheStartPaddingZ, lazyPackedLightCacheDiffX, lazyPackedLightCacheDiffY, lazyPackedLightCacheDiffZ, lazyPackedLightCacheReader, lazyBlockColorsCache, lazyBlockColorsCacheCache, lazyBlockColorsCacheSizeX, lazyBlockColorsCacheSizeY, lazyBlockColorsCacheStartPaddingX, lazyBlockColorsCacheStartPaddingY, lazyBlockColorsCacheStartPaddingZ, biomeBlendRadius, lazyBlockColorsCacheArea, lazyBlockColorsCacheMax, lazyBlockColorsCacheReader, lazyBlockColorsCacheColorResolver, fluidState, bufferBuilder, chunkRenderCache, pooledMutableBlockPos, atlasSpriteWaterOverlay, atlasSpritesLava, atlasSpritesWater);
                            continue;
                        }
                        finally {
                            OptiFineCompatibility.popShaderThing(bufferBuilder);
                        }
                    }
                }
            }
        }
    }

    private static boolean renderBlock(SmoothLightingFluidBlockRenderer fluidRenderer, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, int relativeX, int relativeY, int relativeZ, IFluidState[] fluidStateArray, BlockState[] blockStateArray, int stateCacheSizeX, int stateCacheSizeY, int stateCacheStartPaddingX, int stateCacheStartPaddingY, int stateCacheStartPaddingZ, StateCache stateCache, float[] densityArray, int densityCacheSizeX, int densityCacheSizeY, int densityCacheStartPaddingX, int densityCacheStartPaddingY, int densityCacheStartPaddingZ, @Nullable DensityCache densityCache, LazyPackedLightCache lazyPackedLightCache, int[] lazyPackedLightCacheCache, int lazyPackedLightCacheSizeX, int lazyPackedLightCacheSizeY, int lazyPackedLightCacheStartPaddingX, int lazyPackedLightCacheStartPaddingY, int lazyPackedLightCacheStartPaddingZ, int lazyPackedLightCacheDiffX, int lazyPackedLightCacheDiffY, int lazyPackedLightCacheDiffZ, IEnviromentBlockReader lazyPackedLightCacheReader, LazyBlockColorCache lazyBlockColorsCache, int[] lazyBlockColorsCacheCache, int lazyBlockColorsCacheSizeX, int lazyBlockColorsCacheSizeY, int lazyBlockColorsCacheStartPaddingX, int lazyBlockColorsCacheStartPaddingY, int lazyBlockColorsCacheStartPaddingZ, int biomeBlendRadius, int lazyBlockColorsCacheArea, int lazyBlockColorsCacheMax, IEnviromentBlockReader lazyBlockColorsCacheReader, BiomeColors.IColorResolver lazyBlockColorsCacheColorResolver, IFluidState state, BufferBuilder buffer, IEnviromentBlockReader chunkRenderCache, BlockPos.PooledMutableBlockPos pooledMutableBlockPos, TextureAtlasSprite atlasSpriteWaterOverlay, TextureAtlasSprite[] atlasSpritesLava, TextureAtlasSprite[] atlasSpritesWater) {
        float blue0;
        float blue1;
        float blue2;
        float blue3;
        float green0;
        float green1;
        float green2;
        float green3;
        float red0;
        float red1;
        float red2;
        float red3;
        int light0;
        int light1;
        int light2;
        int light3;
        float blue;
        float green;
        float red;
        TextureAtlasSprite[] atextureatlassprite;
        boolean shouldRenderEast;
        int x = chunkRenderPosX + relativeX;
        int y = chunkRenderPosY + relativeY;
        int z = chunkRenderPosZ + relativeZ;
        int stateCacheOffsetX = stateCacheStartPaddingX + relativeX;
        int stateCacheOffsetY = stateCacheStartPaddingY + relativeY;
        int stateCacheOffsetZ = stateCacheStartPaddingZ + relativeZ;
        int lazyPackedLightCacheOffsetX = lazyPackedLightCacheStartPaddingX + relativeX;
        int lazyPackedLightCacheOffsetY = lazyPackedLightCacheStartPaddingY + relativeY;
        int lazyPackedLightCacheOffsetZ = lazyPackedLightCacheStartPaddingZ + relativeZ;
        int lazyBlockColorsCacheOffsetX = lazyBlockColorsCacheStartPaddingX + relativeX;
        int lazyBlockColorsCacheOffsetY = lazyBlockColorsCacheStartPaddingY + relativeY;
        int lazyBlockColorsCacheOffsetZ = lazyBlockColorsCacheStartPaddingZ + relativeZ;
        int densityCacheOffsetX = densityCacheStartPaddingX + relativeX;
        int densityCacheOffsetY = densityCacheStartPaddingY + relativeY;
        int densityCacheOffsetZ = densityCacheStartPaddingZ + relativeZ;
        Fluid fluid = state.func_206886_c();
        int upIndex = stateCache.getIndex(stateCacheOffsetX, stateCacheOffsetY + 1, stateCacheOffsetZ, stateCacheSizeX, stateCacheSizeY);
        IFluidState upFluidState = fluidStateArray[upIndex];
        BlockState upBlockState = blockStateArray[upIndex];
        int downIndex = stateCache.getIndex(stateCacheOffsetX, stateCacheOffsetY - 1, stateCacheOffsetZ, stateCacheSizeX, stateCacheSizeY);
        IFluidState downFluidState = fluidStateArray[downIndex];
        BlockState downBlockState = blockStateArray[downIndex];
        int northIndex = stateCache.getIndex(stateCacheOffsetX, stateCacheOffsetY, stateCacheOffsetZ - 1, stateCacheSizeX, stateCacheSizeY);
        IFluidState northFluidState = fluidStateArray[northIndex];
        BlockState northBlockState = blockStateArray[northIndex];
        int southIndex = stateCache.getIndex(stateCacheOffsetX, stateCacheOffsetY, stateCacheOffsetZ + 1, stateCacheSizeX, stateCacheSizeY);
        IFluidState southFluidState = fluidStateArray[southIndex];
        BlockState southBlockState = blockStateArray[southIndex];
        int westIndex = stateCache.getIndex(stateCacheOffsetX - 1, stateCacheOffsetY, stateCacheOffsetZ, stateCacheSizeX, stateCacheSizeY);
        IFluidState westFluidState = fluidStateArray[westIndex];
        BlockState westBlockState = blockStateArray[westIndex];
        int eastIndex = stateCache.getIndex(stateCacheOffsetX + 1, stateCacheOffsetY, stateCacheOffsetZ, stateCacheSizeX, stateCacheSizeY);
        IFluidState eastFluidState = fluidStateArray[eastIndex];
        BlockState eastBlockState = blockStateArray[eastIndex];
        boolean shouldRenderDown = !downFluidState.func_206886_c().func_207187_a(fluid) && !downBlockState.func_200132_m();
        boolean shouldRenderUp = !upFluidState.func_206886_c().func_207187_a(fluid) && !upBlockState.func_200132_m();
        boolean shouldRenderNorth = !northFluidState.func_206886_c().func_207187_a(fluid) && !northBlockState.func_200132_m();
        boolean shouldRenderSouth = !southFluidState.func_206886_c().func_207187_a(fluid) && !southBlockState.func_200132_m();
        boolean shouldRenderWest = !westFluidState.func_206886_c().func_207187_a(fluid) && !westBlockState.func_200132_m();
        boolean bl = shouldRenderEast = !eastFluidState.func_206886_c().func_207187_a(fluid) && !eastBlockState.func_200132_m();
        if (densityCache != null) {
            shouldRenderDown &= densityArray[densityCache.getIndex(densityCacheOffsetX, densityCacheOffsetY - 1, densityCacheOffsetZ, densityCacheSizeX, densityCacheSizeY)] > -6.0f;
            shouldRenderUp &= densityArray[densityCache.getIndex(densityCacheOffsetX, densityCacheOffsetY + 1, densityCacheOffsetZ, densityCacheSizeX, densityCacheSizeY)] > -6.0f;
            shouldRenderNorth &= densityArray[densityCache.getIndex(densityCacheOffsetX, densityCacheOffsetY, densityCacheOffsetZ - 1, densityCacheSizeX, densityCacheSizeY)] > -6.0f;
            shouldRenderSouth &= densityArray[densityCache.getIndex(densityCacheOffsetX, densityCacheOffsetY, densityCacheOffsetZ + 1, densityCacheSizeX, densityCacheSizeY)] > -6.0f;
            shouldRenderWest &= densityArray[densityCache.getIndex(densityCacheOffsetX - 1, densityCacheOffsetY, densityCacheOffsetZ, densityCacheSizeX, densityCacheSizeY)] > -6.0f;
            shouldRenderEast &= densityArray[densityCache.getIndex(densityCacheOffsetX + 1, densityCacheOffsetY, densityCacheOffsetZ, densityCacheSizeX, densityCacheSizeY)] > -6.0f;
        }
        if (!(shouldRenderUp || shouldRenderDown || shouldRenderEast || shouldRenderWest || shouldRenderNorth || shouldRenderSouth)) {
            return false;
        }
        boolean isLava = state.func_206884_a(FluidTags.field_206960_b);
        TextureAtlasSprite[] textureAtlasSpriteArray = atextureatlassprite = isLava ? atlasSpritesLava : atlasSpritesWater;
        if (isLava) {
            red = 1.0f;
            green = 1.0f;
            blue = 1.0f;
        } else {
            int waterColor = OptimisedFluidBlockRenderer.getWaterColor(lazyBlockColorsCacheOffsetX, lazyBlockColorsCacheOffsetY, lazyBlockColorsCacheOffsetZ, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, lazyBlockColorsCache, lazyBlockColorsCacheCache, lazyBlockColorsCacheSizeX, lazyBlockColorsCacheSizeY, biomeBlendRadius, lazyBlockColorsCacheArea, lazyBlockColorsCacheMax, lazyBlockColorsCacheReader, lazyBlockColorsCacheColorResolver, pooledMutableBlockPos);
            red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
            green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
            blue = (float)(waterColor & 0xFF) / 255.0f;
        }
        boolean wasAnythingRendered = false;
        float fluidHeight = OptimisedFluidBlockRenderer.getFluidHeight(fluidStateArray, blockStateArray, stateCache, stateCacheSizeX, stateCacheSizeY, stateCacheOffsetX, stateCacheOffsetY, stateCacheOffsetZ, fluid);
        float fluidHeightSouth = OptimisedFluidBlockRenderer.getFluidHeight(fluidStateArray, blockStateArray, stateCache, stateCacheSizeX, stateCacheSizeY, stateCacheOffsetX, stateCacheOffsetY, stateCacheOffsetZ + 1, fluid);
        float fluidHeightEastSouth = OptimisedFluidBlockRenderer.getFluidHeight(fluidStateArray, blockStateArray, stateCache, stateCacheSizeX, stateCacheSizeY, stateCacheOffsetX + 1, stateCacheOffsetY, stateCacheOffsetZ + 1, fluid);
        float fluidHeightEast = OptimisedFluidBlockRenderer.getFluidHeight(fluidStateArray, blockStateArray, stateCache, stateCacheSizeX, stateCacheSizeY, stateCacheOffsetX + 1, stateCacheOffsetY, stateCacheOffsetZ, fluid);
        boolean smoothLighting = fluidRenderer.smoothLighting();
        boolean colors = fluidRenderer.colors();
        if (shouldRenderUp) {
            if (isLava) {
                light3 = 0xF000F0;
                light2 = 0xF000F0;
                light1 = 0xF000F0;
                light0 = 0xF000F0;
                red3 = 1.0f;
                red2 = 1.0f;
                red1 = 1.0f;
                red0 = 1.0f;
                green3 = 1.0f;
                green2 = 1.0f;
                green1 = 1.0f;
                green0 = 1.0f;
                blue3 = 1.0f;
                blue2 = 1.0f;
                blue1 = 1.0f;
                blue0 = 1.0f;
            } else {
                if (!smoothLighting) {
                    int combinedLightUpMax;
                    light0 = combinedLightUpMax = OptimisedFluidBlockRenderer.getCombinedLightUpMax(lazyPackedLightCacheOffsetX, lazyPackedLightCacheOffsetY, lazyPackedLightCacheOffsetZ, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, stateCache, stateCacheSizeX, stateCacheSizeY, lazyPackedLightCache, lazyPackedLightCacheCache, lazyPackedLightCacheSizeX, lazyPackedLightCacheSizeY, lazyPackedLightCacheStartPaddingX, lazyPackedLightCacheStartPaddingY, lazyPackedLightCacheStartPaddingZ, lazyPackedLightCacheDiffX, lazyPackedLightCacheDiffY, lazyPackedLightCacheDiffZ, lazyPackedLightCacheReader, pooledMutableBlockPos);
                    light1 = combinedLightUpMax;
                    light2 = combinedLightUpMax;
                    light3 = combinedLightUpMax;
                } else {
                    light0 = OptimisedFluidBlockRenderer.getCombinedLightUpMax(lazyPackedLightCacheOffsetX, lazyPackedLightCacheOffsetY, lazyPackedLightCacheOffsetZ, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, stateCache, stateCacheSizeX, stateCacheSizeY, lazyPackedLightCache, lazyPackedLightCacheCache, lazyPackedLightCacheSizeX, lazyPackedLightCacheSizeY, lazyPackedLightCacheStartPaddingX, lazyPackedLightCacheStartPaddingY, lazyPackedLightCacheStartPaddingZ, lazyPackedLightCacheDiffX, lazyPackedLightCacheDiffY, lazyPackedLightCacheDiffZ, lazyPackedLightCacheReader, pooledMutableBlockPos);
                    light1 = OptimisedFluidBlockRenderer.getCombinedLightUpMax(lazyPackedLightCacheOffsetX, lazyPackedLightCacheOffsetY, lazyPackedLightCacheOffsetZ + 1, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, stateCache, stateCacheSizeX, stateCacheSizeY, lazyPackedLightCache, lazyPackedLightCacheCache, lazyPackedLightCacheSizeX, lazyPackedLightCacheSizeY, lazyPackedLightCacheStartPaddingX, lazyPackedLightCacheStartPaddingY, lazyPackedLightCacheStartPaddingZ, lazyPackedLightCacheDiffX, lazyPackedLightCacheDiffY, lazyPackedLightCacheDiffZ, lazyPackedLightCacheReader, pooledMutableBlockPos);
                    light2 = OptimisedFluidBlockRenderer.getCombinedLightUpMax(lazyPackedLightCacheOffsetX + 1, lazyPackedLightCacheOffsetY, lazyPackedLightCacheOffsetZ + 1, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, stateCache, stateCacheSizeX, stateCacheSizeY, lazyPackedLightCache, lazyPackedLightCacheCache, lazyPackedLightCacheSizeX, lazyPackedLightCacheSizeY, lazyPackedLightCacheStartPaddingX, lazyPackedLightCacheStartPaddingY, lazyPackedLightCacheStartPaddingZ, lazyPackedLightCacheDiffX, lazyPackedLightCacheDiffY, lazyPackedLightCacheDiffZ, lazyPackedLightCacheReader, pooledMutableBlockPos);
                    light3 = OptimisedFluidBlockRenderer.getCombinedLightUpMax(lazyPackedLightCacheOffsetX + 1, lazyPackedLightCacheOffsetY, lazyPackedLightCacheOffsetZ, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, stateCache, stateCacheSizeX, stateCacheSizeY, lazyPackedLightCache, lazyPackedLightCacheCache, lazyPackedLightCacheSizeX, lazyPackedLightCacheSizeY, lazyPackedLightCacheStartPaddingX, lazyPackedLightCacheStartPaddingY, lazyPackedLightCacheStartPaddingZ, lazyPackedLightCacheDiffX, lazyPackedLightCacheDiffY, lazyPackedLightCacheDiffZ, lazyPackedLightCacheReader, pooledMutableBlockPos);
                }
                if (!colors) {
                    red2 = red3 = red;
                    red1 = red3;
                    red0 = red3;
                    green2 = green3 = green;
                    green1 = green3;
                    green0 = green3;
                    blue2 = blue3 = blue;
                    blue1 = blue3;
                    blue0 = blue3;
                } else {
                    red0 = red;
                    green0 = green;
                    blue0 = blue;
                    int waterColor1 = OptimisedFluidBlockRenderer.getWaterColor(lazyBlockColorsCacheOffsetX, lazyBlockColorsCacheOffsetY, lazyBlockColorsCacheOffsetZ + 1, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, lazyBlockColorsCache, lazyBlockColorsCacheCache, lazyBlockColorsCacheSizeX, lazyBlockColorsCacheSizeY, biomeBlendRadius, lazyBlockColorsCacheArea, lazyBlockColorsCacheMax, lazyBlockColorsCacheReader, lazyBlockColorsCacheColorResolver, pooledMutableBlockPos);
                    red1 = (float)(waterColor1 >> 16 & 0xFF) / 255.0f;
                    green1 = (float)(waterColor1 >> 8 & 0xFF) / 255.0f;
                    blue1 = (float)(waterColor1 & 0xFF) / 255.0f;
                    int waterColor2 = OptimisedFluidBlockRenderer.getWaterColor(lazyBlockColorsCacheOffsetX + 1, lazyBlockColorsCacheOffsetY, lazyBlockColorsCacheOffsetZ + 1, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, lazyBlockColorsCache, lazyBlockColorsCacheCache, lazyBlockColorsCacheSizeX, lazyBlockColorsCacheSizeY, biomeBlendRadius, lazyBlockColorsCacheArea, lazyBlockColorsCacheMax, lazyBlockColorsCacheReader, lazyBlockColorsCacheColorResolver, pooledMutableBlockPos);
                    red2 = (float)(waterColor2 >> 16 & 0xFF) / 255.0f;
                    green2 = (float)(waterColor2 >> 8 & 0xFF) / 255.0f;
                    blue2 = (float)(waterColor2 & 0xFF) / 255.0f;
                    int waterColor3 = OptimisedFluidBlockRenderer.getWaterColor(lazyBlockColorsCacheOffsetX + 1, lazyBlockColorsCacheOffsetY, lazyBlockColorsCacheOffsetZ, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, lazyBlockColorsCache, lazyBlockColorsCacheCache, lazyBlockColorsCacheSizeX, lazyBlockColorsCacheSizeY, biomeBlendRadius, lazyBlockColorsCacheArea, lazyBlockColorsCacheMax, lazyBlockColorsCacheReader, lazyBlockColorsCacheColorResolver, pooledMutableBlockPos);
                    red3 = (float)(waterColor3 >> 16 & 0xFF) / 255.0f;
                    green3 = (float)(waterColor3 >> 8 & 0xFF) / 255.0f;
                    blue3 = (float)(waterColor3 & 0xFF) / 255.0f;
                }
            }
            wasAnythingRendered |= fluidRenderer.renderUp(buffer, atextureatlassprite, red0, green0, blue0, red1, green1, blue1, red2, green2, blue2, red3, green3, blue3, fluidHeight, fluidHeightSouth, fluidHeightEastSouth, fluidHeightEast, x, y, z, light0, light1, light2, light3, state.func_205586_a((IBlockReader)chunkRenderCache, (BlockPos)pooledMutableBlockPos.func_181079_c(x, y + 1, z)), state.func_215673_c((IBlockReader)chunkRenderCache, (BlockPos)pooledMutableBlockPos.func_181079_c(x, y, z)), MathHelper.func_180187_c((int)x, (int)y, (int)z));
        }
        if (shouldRenderDown) {
            if (isLava) {
                light3 = 0xF000F0;
                light2 = 0xF000F0;
                light1 = 0xF000F0;
                light0 = 0xF000F0;
                red3 = 1.0f;
                red2 = 1.0f;
                red1 = 1.0f;
                red0 = 1.0f;
                green3 = 1.0f;
                green2 = 1.0f;
                green1 = 1.0f;
                green0 = 1.0f;
                blue3 = 1.0f;
                blue2 = 1.0f;
                blue1 = 1.0f;
                blue0 = 1.0f;
            } else {
                int lazyPackedLightCacheOffsetYMinus1 = lazyPackedLightCacheOffsetY - 1;
                if (!smoothLighting) {
                    int downCombinedLightUpMax;
                    light0 = downCombinedLightUpMax = OptimisedFluidBlockRenderer.getCombinedLightUpMax(lazyPackedLightCacheOffsetX, lazyPackedLightCacheOffsetYMinus1, lazyPackedLightCacheOffsetZ, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, stateCache, stateCacheSizeX, stateCacheSizeY, lazyPackedLightCache, lazyPackedLightCacheCache, lazyPackedLightCacheSizeX, lazyPackedLightCacheSizeY, lazyPackedLightCacheStartPaddingX, lazyPackedLightCacheStartPaddingY, lazyPackedLightCacheStartPaddingZ, lazyPackedLightCacheDiffX, lazyPackedLightCacheDiffY, lazyPackedLightCacheDiffZ, lazyPackedLightCacheReader, pooledMutableBlockPos);
                    light1 = downCombinedLightUpMax;
                    light2 = downCombinedLightUpMax;
                    light3 = downCombinedLightUpMax;
                } else {
                    light0 = OptimisedFluidBlockRenderer.getCombinedLightUpMax(lazyPackedLightCacheOffsetX, lazyPackedLightCacheOffsetYMinus1, lazyPackedLightCacheOffsetZ + 1, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, stateCache, stateCacheSizeX, stateCacheSizeY, lazyPackedLightCache, lazyPackedLightCacheCache, lazyPackedLightCacheSizeX, lazyPackedLightCacheSizeY, lazyPackedLightCacheStartPaddingX, lazyPackedLightCacheStartPaddingY, lazyPackedLightCacheStartPaddingZ, lazyPackedLightCacheDiffX, lazyPackedLightCacheDiffY, lazyPackedLightCacheDiffZ, lazyPackedLightCacheReader, pooledMutableBlockPos);
                    light1 = OptimisedFluidBlockRenderer.getCombinedLightUpMax(lazyPackedLightCacheOffsetX, lazyPackedLightCacheOffsetYMinus1, lazyPackedLightCacheOffsetZ, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, stateCache, stateCacheSizeX, stateCacheSizeY, lazyPackedLightCache, lazyPackedLightCacheCache, lazyPackedLightCacheSizeX, lazyPackedLightCacheSizeY, lazyPackedLightCacheStartPaddingX, lazyPackedLightCacheStartPaddingY, lazyPackedLightCacheStartPaddingZ, lazyPackedLightCacheDiffX, lazyPackedLightCacheDiffY, lazyPackedLightCacheDiffZ, lazyPackedLightCacheReader, pooledMutableBlockPos);
                    light2 = OptimisedFluidBlockRenderer.getCombinedLightUpMax(lazyPackedLightCacheOffsetX + 1, lazyPackedLightCacheOffsetYMinus1, lazyPackedLightCacheOffsetZ, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, stateCache, stateCacheSizeX, stateCacheSizeY, lazyPackedLightCache, lazyPackedLightCacheCache, lazyPackedLightCacheSizeX, lazyPackedLightCacheSizeY, lazyPackedLightCacheStartPaddingX, lazyPackedLightCacheStartPaddingY, lazyPackedLightCacheStartPaddingZ, lazyPackedLightCacheDiffX, lazyPackedLightCacheDiffY, lazyPackedLightCacheDiffZ, lazyPackedLightCacheReader, pooledMutableBlockPos);
                    light3 = OptimisedFluidBlockRenderer.getCombinedLightUpMax(lazyPackedLightCacheOffsetX + 1, lazyPackedLightCacheOffsetYMinus1, lazyPackedLightCacheOffsetZ + 1, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, stateCache, stateCacheSizeX, stateCacheSizeY, lazyPackedLightCache, lazyPackedLightCacheCache, lazyPackedLightCacheSizeX, lazyPackedLightCacheSizeY, lazyPackedLightCacheStartPaddingX, lazyPackedLightCacheStartPaddingY, lazyPackedLightCacheStartPaddingZ, lazyPackedLightCacheDiffX, lazyPackedLightCacheDiffY, lazyPackedLightCacheDiffZ, lazyPackedLightCacheReader, pooledMutableBlockPos);
                }
                if (!colors) {
                    red2 = red3 = red;
                    red1 = red3;
                    red0 = red3;
                    green2 = green3 = green;
                    green1 = green3;
                    green0 = green3;
                    blue2 = blue3 = blue;
                    blue1 = blue3;
                    blue0 = blue3;
                } else {
                    int waterColor0 = OptimisedFluidBlockRenderer.getWaterColor(lazyBlockColorsCacheOffsetX, lazyBlockColorsCacheOffsetY - 1, lazyBlockColorsCacheOffsetZ + 1, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, lazyBlockColorsCache, lazyBlockColorsCacheCache, lazyBlockColorsCacheSizeX, lazyBlockColorsCacheSizeY, biomeBlendRadius, lazyBlockColorsCacheArea, lazyBlockColorsCacheMax, lazyBlockColorsCacheReader, lazyBlockColorsCacheColorResolver, pooledMutableBlockPos);
                    red0 = (float)(waterColor0 >> 16 & 0xFF) / 255.0f;
                    green0 = (float)(waterColor0 >> 8 & 0xFF) / 255.0f;
                    blue0 = (float)(waterColor0 & 0xFF) / 255.0f;
                    int waterColor1 = OptimisedFluidBlockRenderer.getWaterColor(lazyBlockColorsCacheOffsetX, lazyBlockColorsCacheOffsetY - 1, lazyBlockColorsCacheOffsetZ, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, lazyBlockColorsCache, lazyBlockColorsCacheCache, lazyBlockColorsCacheSizeX, lazyBlockColorsCacheSizeY, biomeBlendRadius, lazyBlockColorsCacheArea, lazyBlockColorsCacheMax, lazyBlockColorsCacheReader, lazyBlockColorsCacheColorResolver, pooledMutableBlockPos);
                    red1 = (float)(waterColor1 >> 16 & 0xFF) / 255.0f;
                    green1 = (float)(waterColor1 >> 8 & 0xFF) / 255.0f;
                    blue1 = (float)(waterColor1 & 0xFF) / 255.0f;
                    int waterColor2 = OptimisedFluidBlockRenderer.getWaterColor(lazyBlockColorsCacheOffsetX + 1, lazyBlockColorsCacheOffsetY - 1, lazyBlockColorsCacheOffsetZ, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, lazyBlockColorsCache, lazyBlockColorsCacheCache, lazyBlockColorsCacheSizeX, lazyBlockColorsCacheSizeY, biomeBlendRadius, lazyBlockColorsCacheArea, lazyBlockColorsCacheMax, lazyBlockColorsCacheReader, lazyBlockColorsCacheColorResolver, pooledMutableBlockPos);
                    red2 = (float)(waterColor2 >> 16 & 0xFF) / 255.0f;
                    green2 = (float)(waterColor2 >> 8 & 0xFF) / 255.0f;
                    blue2 = (float)(waterColor2 & 0xFF) / 255.0f;
                    int waterColor3 = OptimisedFluidBlockRenderer.getWaterColor(lazyBlockColorsCacheOffsetX + 1, lazyBlockColorsCacheOffsetY - 1, lazyBlockColorsCacheOffsetZ + 1, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, lazyBlockColorsCache, lazyBlockColorsCacheCache, lazyBlockColorsCacheSizeX, lazyBlockColorsCacheSizeY, biomeBlendRadius, lazyBlockColorsCacheArea, lazyBlockColorsCacheMax, lazyBlockColorsCacheReader, lazyBlockColorsCacheColorResolver, pooledMutableBlockPos);
                    red3 = (float)(waterColor3 >> 16 & 0xFF) / 255.0f;
                    green3 = (float)(waterColor3 >> 8 & 0xFF) / 255.0f;
                    blue3 = (float)(waterColor3 & 0xFF) / 255.0f;
                }
            }
            wasAnythingRendered |= fluidRenderer.renderDown(light0, light1, light2, light3, buffer, atextureatlassprite[0], red0, green0, blue0, red1, green1, blue1, red2, green2, blue2, red3, green3, blue3, x, y, z);
        }
        for (int facingIndex = 0; facingIndex < 4; ++facingIndex) {
            float blue02;
            float blue12;
            float blue22;
            float blue32;
            float green02;
            float green12;
            float green22;
            float green32;
            float red02;
            float red12;
            float red22;
            float red32;
            int light02;
            int light12;
            int light22;
            int light32;
            Block block;
            boolean shouldRenderSide;
            Direction direction;
            int z1;
            int z0;
            int x1;
            int x0;
            float y1;
            float y0;
            if (facingIndex == 0) {
                y0 = fluidHeight;
                y1 = fluidHeightEast;
                x0 = x;
                x1 = x + 1;
                z0 = z;
                z1 = z;
                direction = Direction.NORTH;
                shouldRenderSide = shouldRenderNorth;
            } else if (facingIndex == 1) {
                y0 = fluidHeightEastSouth;
                y1 = fluidHeightSouth;
                x0 = x + 1;
                x1 = x;
                z0 = z + 1;
                z1 = z + 1;
                direction = Direction.SOUTH;
                shouldRenderSide = shouldRenderSouth;
            } else if (facingIndex == 2) {
                y0 = fluidHeightSouth;
                y1 = fluidHeight;
                x0 = x;
                x1 = x;
                z0 = z + 1;
                z1 = z;
                direction = Direction.WEST;
                shouldRenderSide = shouldRenderWest;
            } else {
                y0 = fluidHeightEast;
                y1 = fluidHeightEastSouth;
                x0 = x + 1;
                x1 = x + 1;
                z0 = z;
                z1 = z + 1;
                direction = Direction.EAST;
                shouldRenderSide = shouldRenderEast;
            }
            pooledMutableBlockPos.func_181079_c(x, y, z).func_189536_c(direction);
            int offsetRelativeX = pooledMutableBlockPos.func_177958_n() - chunkRenderPosX;
            int offsetRelativeY = pooledMutableBlockPos.func_177956_o() - chunkRenderPosY;
            int offsetRelativeZ = pooledMutableBlockPos.func_177952_p() - chunkRenderPosZ;
            if (!shouldRenderSide) continue;
            TextureAtlasSprite textureatlassprite2 = atextureatlassprite[1];
            if (!isLava && ((block = blockStateArray[stateCache.getIndex(stateCacheStartPaddingX + offsetRelativeX, stateCacheStartPaddingY + offsetRelativeY, stateCacheStartPaddingZ + offsetRelativeZ, stateCacheSizeX, stateCacheSizeY)].func_177230_c()) == Blocks.field_150359_w || block instanceof StainedGlassBlock)) {
                textureatlassprite2 = atlasSpriteWaterOverlay;
            }
            if (isLava) {
                light32 = 0xF000F0;
                light22 = 0xF000F0;
                light12 = 0xF000F0;
                light02 = 0xF000F0;
                red32 = 1.0f;
                red22 = 1.0f;
                red12 = 1.0f;
                red02 = 1.0f;
                green32 = 1.0f;
                green22 = 1.0f;
                green12 = 1.0f;
                green02 = 1.0f;
                blue32 = 1.0f;
                blue22 = 1.0f;
                blue12 = 1.0f;
                blue02 = 1.0f;
            } else {
                if (!smoothLighting) {
                    int combinedLightUpMax;
                    light02 = combinedLightUpMax = OptimisedFluidBlockRenderer.getCombinedLightUpMax(lazyPackedLightCacheStartPaddingX + offsetRelativeX, lazyPackedLightCacheStartPaddingY + offsetRelativeY, lazyPackedLightCacheStartPaddingZ + offsetRelativeZ, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, stateCache, stateCacheSizeX, stateCacheSizeY, lazyPackedLightCache, lazyPackedLightCacheCache, lazyPackedLightCacheSizeX, lazyPackedLightCacheSizeY, lazyPackedLightCacheStartPaddingX, lazyPackedLightCacheStartPaddingY, lazyPackedLightCacheStartPaddingZ, lazyPackedLightCacheDiffX, lazyPackedLightCacheDiffY, lazyPackedLightCacheDiffZ, lazyPackedLightCacheReader, pooledMutableBlockPos);
                    light12 = combinedLightUpMax;
                    light22 = combinedLightUpMax;
                    light32 = combinedLightUpMax;
                } else {
                    light02 = OptimisedFluidBlockRenderer.getCombinedLightUpMax(lazyPackedLightCacheStartPaddingX + (x0 - chunkRenderPosX), lazyPackedLightCacheStartPaddingY + (MathHelper.func_76141_d((float)((float)y + y0)) - chunkRenderPosY), lazyPackedLightCacheStartPaddingZ + (z0 - chunkRenderPosZ), chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, stateCache, stateCacheSizeX, stateCacheSizeY, lazyPackedLightCache, lazyPackedLightCacheCache, lazyPackedLightCacheSizeX, lazyPackedLightCacheSizeY, lazyPackedLightCacheStartPaddingX, lazyPackedLightCacheStartPaddingY, lazyPackedLightCacheStartPaddingZ, lazyPackedLightCacheDiffX, lazyPackedLightCacheDiffY, lazyPackedLightCacheDiffZ, lazyPackedLightCacheReader, pooledMutableBlockPos);
                    light12 = OptimisedFluidBlockRenderer.getCombinedLightUpMax(lazyPackedLightCacheStartPaddingX + (x1 - chunkRenderPosX), lazyPackedLightCacheStartPaddingY + (MathHelper.func_76141_d((float)((float)y + y1)) - chunkRenderPosY), lazyPackedLightCacheStartPaddingZ + (z1 - chunkRenderPosZ), chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, stateCache, stateCacheSizeX, stateCacheSizeY, lazyPackedLightCache, lazyPackedLightCacheCache, lazyPackedLightCacheSizeX, lazyPackedLightCacheSizeY, lazyPackedLightCacheStartPaddingX, lazyPackedLightCacheStartPaddingY, lazyPackedLightCacheStartPaddingZ, lazyPackedLightCacheDiffX, lazyPackedLightCacheDiffY, lazyPackedLightCacheDiffZ, lazyPackedLightCacheReader, pooledMutableBlockPos);
                    light22 = OptimisedFluidBlockRenderer.getCombinedLightUpMax(lazyPackedLightCacheStartPaddingX + (x1 - chunkRenderPosX), lazyPackedLightCacheStartPaddingY + (y - chunkRenderPosY), lazyPackedLightCacheStartPaddingZ + (z1 - chunkRenderPosZ), chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, stateCache, stateCacheSizeX, stateCacheSizeY, lazyPackedLightCache, lazyPackedLightCacheCache, lazyPackedLightCacheSizeX, lazyPackedLightCacheSizeY, lazyPackedLightCacheStartPaddingX, lazyPackedLightCacheStartPaddingY, lazyPackedLightCacheStartPaddingZ, lazyPackedLightCacheDiffX, lazyPackedLightCacheDiffY, lazyPackedLightCacheDiffZ, lazyPackedLightCacheReader, pooledMutableBlockPos);
                    light32 = OptimisedFluidBlockRenderer.getCombinedLightUpMax(lazyPackedLightCacheStartPaddingX + (x0 - chunkRenderPosX), lazyPackedLightCacheStartPaddingY + (y - chunkRenderPosY), lazyPackedLightCacheStartPaddingZ + (z0 - chunkRenderPosZ), chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, stateCache, stateCacheSizeX, stateCacheSizeY, lazyPackedLightCache, lazyPackedLightCacheCache, lazyPackedLightCacheSizeX, lazyPackedLightCacheSizeY, lazyPackedLightCacheStartPaddingX, lazyPackedLightCacheStartPaddingY, lazyPackedLightCacheStartPaddingZ, lazyPackedLightCacheDiffX, lazyPackedLightCacheDiffY, lazyPackedLightCacheDiffZ, lazyPackedLightCacheReader, pooledMutableBlockPos);
                }
                if (!colors) {
                    red22 = red32 = red;
                    red12 = red32;
                    red02 = red32;
                    green22 = green32 = green;
                    green12 = green32;
                    green02 = green32;
                    blue22 = blue32 = blue;
                    blue12 = blue32;
                    blue02 = blue32;
                } else {
                    int waterColor0 = OptimisedFluidBlockRenderer.getWaterColor(lazyBlockColorsCacheStartPaddingX + (x0 - chunkRenderPosX), lazyBlockColorsCacheStartPaddingY + (MathHelper.func_76141_d((float)((float)y + y0)) - chunkRenderPosY), lazyBlockColorsCacheStartPaddingZ + (z0 - chunkRenderPosZ), chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, lazyBlockColorsCache, lazyBlockColorsCacheCache, lazyBlockColorsCacheSizeX, lazyBlockColorsCacheSizeY, biomeBlendRadius, lazyBlockColorsCacheArea, lazyBlockColorsCacheMax, lazyBlockColorsCacheReader, lazyBlockColorsCacheColorResolver, pooledMutableBlockPos);
                    red02 = (float)(waterColor0 >> 16 & 0xFF) / 255.0f;
                    green02 = (float)(waterColor0 >> 8 & 0xFF) / 255.0f;
                    blue02 = (float)(waterColor0 & 0xFF) / 255.0f;
                    int waterColor1 = OptimisedFluidBlockRenderer.getWaterColor(lazyBlockColorsCacheStartPaddingX + (x1 - chunkRenderPosX), lazyBlockColorsCacheStartPaddingY + (MathHelper.func_76141_d((float)((float)y + y1)) - chunkRenderPosY), lazyBlockColorsCacheStartPaddingZ + (z1 - chunkRenderPosZ), chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, lazyBlockColorsCache, lazyBlockColorsCacheCache, lazyBlockColorsCacheSizeX, lazyBlockColorsCacheSizeY, biomeBlendRadius, lazyBlockColorsCacheArea, lazyBlockColorsCacheMax, lazyBlockColorsCacheReader, lazyBlockColorsCacheColorResolver, pooledMutableBlockPos);
                    red12 = (float)(waterColor1 >> 16 & 0xFF) / 255.0f;
                    green12 = (float)(waterColor1 >> 8 & 0xFF) / 255.0f;
                    blue12 = (float)(waterColor1 & 0xFF) / 255.0f;
                    int waterColor2 = OptimisedFluidBlockRenderer.getWaterColor(lazyBlockColorsCacheStartPaddingX + (x1 - chunkRenderPosX), lazyBlockColorsCacheStartPaddingY + (y - chunkRenderPosY), lazyBlockColorsCacheStartPaddingZ + (z1 - chunkRenderPosZ), chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, lazyBlockColorsCache, lazyBlockColorsCacheCache, lazyBlockColorsCacheSizeX, lazyBlockColorsCacheSizeY, biomeBlendRadius, lazyBlockColorsCacheArea, lazyBlockColorsCacheMax, lazyBlockColorsCacheReader, lazyBlockColorsCacheColorResolver, pooledMutableBlockPos);
                    red22 = (float)(waterColor2 >> 16 & 0xFF) / 255.0f;
                    green22 = (float)(waterColor2 >> 8 & 0xFF) / 255.0f;
                    blue22 = (float)(waterColor2 & 0xFF) / 255.0f;
                    int waterColor3 = OptimisedFluidBlockRenderer.getWaterColor(lazyBlockColorsCacheStartPaddingX + (x0 - chunkRenderPosX), lazyBlockColorsCacheStartPaddingY + (y - chunkRenderPosY), lazyBlockColorsCacheStartPaddingZ + (z0 - chunkRenderPosZ), chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, lazyBlockColorsCache, lazyBlockColorsCacheCache, lazyBlockColorsCacheSizeX, lazyBlockColorsCacheSizeY, biomeBlendRadius, lazyBlockColorsCacheArea, lazyBlockColorsCacheMax, lazyBlockColorsCacheReader, lazyBlockColorsCacheColorResolver, pooledMutableBlockPos);
                    red32 = (float)(waterColor3 >> 16 & 0xFF) / 255.0f;
                    green32 = (float)(waterColor3 >> 8 & 0xFF) / 255.0f;
                    blue32 = (float)(waterColor3 & 0xFF) / 255.0f;
                }
            }
            wasAnythingRendered = fluidRenderer.renderSide(buffer, textureatlassprite2, red02, green02, blue02, red12, green12, blue12, red22, green22, blue22, red32, green32, blue32, facingIndex, y, y0, y1, x0, x1, z0, z1, light02, light12, light22, light32, textureatlassprite2 != atlasSpriteWaterOverlay);
        }
        return wasAnythingRendered;
    }

    private static int getWaterColor(int x, int y, int z, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, LazyBlockColorCache lazyBlockColorsCache, int[] cache, int sizeX, int sizeY, int biomeBlendRadius, int area, int max, IEnviromentBlockReader reader, BiomeColors.IColorResolver resolver, BlockPos.PooledMutableBlockPos pooledMutableBlockPos) {
        return LazyBlockColorCache.get(x, y, z, cache, lazyBlockColorsCache.getIndex(x, y, z, sizeX, sizeY), biomeBlendRadius, area, max, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, (BlockPos.MutableBlockPos)pooledMutableBlockPos, reader, resolver, true);
    }

    private static int getCombinedLightUpMax(int x, int y, int z, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, StateCache stateCache, int stateCacheSizeX, int stateCacheSizeY, LazyPackedLightCache lazyPackedLightCache, int[] lazyPackedLightCacheCache, int lazyPackedLightCacheSizeX, int lazyPackedLightCacheSizeY, int lazyPackedLightCacheStartPaddingX, int lazyPackedLightCacheStartPaddingY, int lazyPackedLightCacheStartPaddingZ, int lazyPackedLightCacheDiffX, int lazyPackedLightCacheDiffY, int lazyPackedLightCacheDiffZ, IEnviromentBlockReader lazyPackedLightCacheReader, BlockPos.PooledMutableBlockPos pooledMutableBlockPos) {
        int light = LazyPackedLightCache.get(x, y, z, lazyPackedLightCacheCache, lazyPackedLightCache.getIndex(x, y, z, lazyPackedLightCacheSizeX, lazyPackedLightCacheSizeY), stateCache, lazyPackedLightCacheReader, (BlockPos.MutableBlockPos)pooledMutableBlockPos, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, lazyPackedLightCacheStartPaddingX, lazyPackedLightCacheStartPaddingY, lazyPackedLightCacheStartPaddingZ, lazyPackedLightCacheDiffX, lazyPackedLightCacheDiffY, lazyPackedLightCacheDiffZ, stateCacheSizeX, stateCacheSizeY);
        int lightUp = LazyPackedLightCache.get(x, y + 1, z, lazyPackedLightCacheCache, lazyPackedLightCache.getIndex(x, y + 1, z, lazyPackedLightCacheSizeX, lazyPackedLightCacheSizeY), stateCache, lazyPackedLightCacheReader, (BlockPos.MutableBlockPos)pooledMutableBlockPos, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, lazyPackedLightCacheStartPaddingX, lazyPackedLightCacheStartPaddingY, lazyPackedLightCacheStartPaddingZ, lazyPackedLightCacheDiffX, lazyPackedLightCacheDiffY, lazyPackedLightCacheDiffZ, stateCacheSizeX, stateCacheSizeY);
        int blockLight = light & 0xFF;
        int blockLightUp = lightUp & 0xFF;
        int skyLight = light >> 16 & 0xFF;
        int skyLightUp = lightUp >> 16 & 0xFF;
        return (blockLight > blockLightUp ? blockLight : blockLightUp) | (skyLight > skyLightUp ? skyLight : skyLightUp) << 16;
    }

    public static float getFluidHeight(IFluidState[] fluidStateArray, BlockState[] blockStateArray, StateCache stateCache, int stateCacheSizeX, int stateCacheSizeY, int stateCacheOffsetX, int stateCacheOffsetY, int stateCacheOffsetZ, Fluid fluidIn) {
        int divisor = 0;
        float height = 0.0f;
        for (int xOff = 0; xOff > -2; --xOff) {
            for (int zOff = 0; zOff > -2; --zOff) {
                int stateCacheOffsetXPlusOffset = stateCacheOffsetX + xOff;
                int stateCacheOffsetZPlusOffset = stateCacheOffsetZ + zOff;
                IFluidState upFluidState = fluidStateArray[stateCache.getIndex(stateCacheOffsetXPlusOffset, stateCacheOffsetY + 1, stateCacheOffsetZPlusOffset, stateCacheSizeX, stateCacheSizeY)];
                Fluid upFluid = upFluidState.func_206886_c();
                if (upFluid.func_207187_a(fluidIn)) {
                    return 1.0f;
                }
                IFluidState ifluidstate = fluidStateArray[stateCache.getIndex(stateCacheOffsetXPlusOffset, stateCacheOffsetY, stateCacheOffsetZPlusOffset, stateCacheSizeX, stateCacheSizeY)];
                Fluid fluid = ifluidstate.func_206886_c();
                if (fluid.func_207187_a(fluidIn)) {
                    float fluidHeight = fluid instanceof EmptyFluid ? 0.0f : (fluid.func_207187_a(upFluid) ? 1.0f : (float)ifluidstate.func_206882_g() / 9.0f);
                    if (fluidHeight >= 0.8f) {
                        height += fluidHeight * 10.0f;
                        divisor += 10;
                        continue;
                    }
                    height += fluidHeight;
                    ++divisor;
                    continue;
                }
                if (blockStateArray[stateCache.getIndex(stateCacheOffsetXPlusOffset, stateCacheOffsetY, stateCacheOffsetZPlusOffset, stateCacheSizeX, stateCacheSizeY)].func_185904_a().func_76220_a()) continue;
                ++divisor;
            }
        }
        return height / (float)divisor;
    }
}

