/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.render;

import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.client.LazyPackedLightCache;
import io.github.cadiboo.nocubes.client.optifine.OptiFineCompatibility;
import io.github.cadiboo.nocubes.client.render.ExtendedFluidBlockRenderer;
import io.github.cadiboo.nocubes.config.Config;
import io.github.cadiboo.nocubes.util.ModProfiler;
import io.github.cadiboo.nocubes.util.pooled.cache.SmoothableCache;
import io.github.cadiboo.nocubes.util.pooled.cache.StateCache;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.chunk.ChunkRender;
import net.minecraft.client.renderer.chunk.ChunkRenderTask;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.IWorldReader;

public final class ExtendedFluidChunkRenderer {
    private static final ThreadLocal<boolean[]> IS_FLUID_SOURCE_THREAD_LOCAL = ThreadLocal.withInitial(() -> new boolean[0]);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderChunk(@Nonnull ChunkRender chunkRender, @Nonnull ChunkRenderTask generator, @Nonnull CompiledChunk compiledChunk, @Nonnull BlockPos renderChunkPosition, int renderChunkPositionX, int renderChunkPositionY, int renderChunkPositionZ, @Nonnull IWorldReader reader, @Nonnull BlockPos.PooledMutableBlockPos pooledMutableBlockPos, @Nonnull boolean[] usedBlockRenderLayers, @Nonnull BlockRendererDispatcher blockRendererDispatcher, @Nonnull StateCache stateCache, @Nonnull SmoothableCache smoothableCache, @Nonnull LazyPackedLightCache lazyPackedLightCache) {
        try (ModProfiler ignored = ModProfiler.get().start("Render extended fluid chunk");){
            int extendRange;
            BlockState[] blockCacheArray = stateCache.getBlockStates();
            IFluidState[] fluidCacheArray = stateCache.getFluidStates();
            int fluidCacheLength = blockCacheArray.length;
            int stateCacheSizeX = stateCache.sizeX;
            int stateCacheSizeY = stateCache.sizeY;
            int stateCacheStartPaddingX = stateCache.startPaddingX;
            int stateCacheStartPaddingY = stateCache.startPaddingY;
            int stateCacheStartPaddingZ = stateCache.startPaddingZ;
            boolean[] isFluidSource = IS_FLUID_SOURCE_THREAD_LOCAL.get();
            if (isFluidSource.length < fluidCacheLength) {
                isFluidSource = new boolean[fluidCacheLength];
                IS_FLUID_SOURCE_THREAD_LOCAL.set(isFluidSource);
            }
            for (int i = 0; i < fluidCacheLength; ++i) {
                isFluidSource[i] = fluidCacheArray[i].func_206889_d();
            }
            boolean[] isSmoothable = smoothableCache.getSmoothableCache();
            int smoothableCacheSizeX = smoothableCache.sizeX;
            int smoothableCacheSizeY = smoothableCache.sizeY;
            int smoothableCacheStartPaddingX = smoothableCache.startPaddingX;
            int smoothableCacheStartPaddingY = smoothableCache.startPaddingY;
            int smoothableCacheStartPaddingZ = smoothableCache.startPaddingZ;
            int maxXOffset = extendRange = Config.extendFluidsRange.getRange();
            int maxZOffset = extendRange;
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 16; ++y) {
                    block15: for (int x = 0; x < 16; ++x) {
                        int stateCacheOffsetX = stateCacheStartPaddingX + x;
                        int stateCacheOffsetY = stateCacheStartPaddingY + y;
                        int stateCacheOffsetZ = stateCacheStartPaddingZ + z;
                        if (!isSmoothable[smoothableCache.getIndex(smoothableCacheStartPaddingX + x, smoothableCacheStartPaddingY + y, smoothableCacheStartPaddingZ + z, smoothableCacheSizeX, smoothableCacheSizeY)] || !fluidCacheArray[stateCache.getIndex(stateCacheOffsetX, stateCacheOffsetY, stateCacheOffsetZ, stateCacheSizeX, stateCacheSizeY)].func_206888_e()) continue;
                        for (int xOffset = -maxXOffset; xOffset <= maxXOffset; ++xOffset) {
                            for (int zOffset = -maxZOffset; zOffset <= maxZOffset; ++zOffset) {
                                int fluidStateIndex;
                                if (xOffset == 0 && zOffset == 0 || !isFluidSource[fluidStateIndex = stateCache.getIndex(stateCacheOffsetX + xOffset, stateCacheOffsetY, stateCacheOffsetZ + zOffset, stateCacheSizeX, stateCacheSizeY)] || blockCacheArray[stateCache.getIndex(stateCacheOffsetX + xOffset, stateCacheOffsetY + 1, stateCacheOffsetZ + zOffset, stateCacheSizeX, stateCacheSizeY)].func_200132_m()) continue;
                                IFluidState fluidState = fluidCacheArray[fluidStateIndex];
                                BlockRenderLayer blockRenderLayer = ClientUtil.getCorrectRenderLayer(fluidState);
                                int blockRenderLayerOrdinal = blockRenderLayer.ordinal();
                                BufferBuilder bufferBuilder = ClientUtil.startOrContinueBufferBuilder(generator, blockRenderLayerOrdinal, compiledChunk, blockRenderLayer, chunkRender, renderChunkPosition);
                                int worldX = renderChunkPositionX + x;
                                int worldY = renderChunkPositionY + y;
                                int worldZ = renderChunkPositionZ + z;
                                OptiFineCompatibility.pushShaderThing(fluidState, (BlockPos)pooledMutableBlockPos.func_181079_c(worldX, worldY, worldZ), (IEnviromentBlockReader)reader, bufferBuilder);
                                try {
                                    int n = blockRenderLayerOrdinal;
                                    usedBlockRenderLayers[n] = usedBlockRenderLayers[n] | ExtendedFluidBlockRenderer.renderExtendedFluid(worldX, worldY, worldZ, (BlockPos)pooledMutableBlockPos.func_181079_c(worldX + xOffset, worldY, worldZ + zOffset), reader, fluidState, bufferBuilder, blockRendererDispatcher, lazyPackedLightCache);
                                    continue block15;
                                }
                                finally {
                                    OptiFineCompatibility.popShaderThing(bufferBuilder);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

