/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.render;

import io.github.cadiboo.nocubes.client.ClientUtil;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.BlockRenderLayer;

public final class BufferBuilderCache {
    private final BufferBuilder[] worldRenderers = new BufferBuilder[ClientUtil.BLOCK_RENDER_LAYER_VALUES_LENGTH];

    public BufferBuilderCache() {
        this(0x200000, 131072, 131072, 262144);
    }

    public BufferBuilderCache(int solidSize, int cutoutSize, int cutoutMippedSize, int translucentSize) {
        this.worldRenderers[BlockRenderLayer.SOLID.ordinal()] = new BufferBuilder(solidSize);
        this.worldRenderers[BlockRenderLayer.CUTOUT.ordinal()] = new BufferBuilder(cutoutSize);
        this.worldRenderers[BlockRenderLayer.CUTOUT_MIPPED.ordinal()] = new BufferBuilder(cutoutMippedSize);
        this.worldRenderers[BlockRenderLayer.TRANSLUCENT.ordinal()] = new BufferBuilder(translucentSize);
    }

    public BufferBuilder get(BlockRenderLayer layer) {
        return this.get(layer.ordinal());
    }

    public BufferBuilder get(int id) {
        return this.worldRenderers[id];
    }
}

