/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.optifine;

import io.github.cadiboo.nocubes.NoCubes;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;

public final class OptiFineLocator {
    @Nullable
    private static Class<?> findConfigClass() {
        Class<?> config;
        try {
            config = Class.forName("net.optifine.Config");
        }
        catch (ClassNotFoundException failedToFindModernConfigClass) {
            try {
                config = Class.forName("Config");
            }
            catch (ClassNotFoundException failedToFindLegacyConfigClass) {
                NoCubes.LOGGER.info("OptiFineCompatibility: OptiFine not detected.");
                return null;
            }
        }
        NoCubes.LOGGER.info("OptiFineCompatibility: Found OptiFine!");
        return config;
    }

    private static boolean isCompatibleOptiFineVersion(String version) {
        return version.contains("HD_U_F");
    }

    static boolean isOptiFineInstalledAndCompatible() {
        return OptiFineLocator.isOptiFineInstalled() && OptiFineLocator.isOptiFineCompatible();
    }

    public static boolean isOptiFineCompatible() {
        Class<?> configClass = OptiFineLocator.findConfigClass();
        if (configClass == null) {
            return false;
        }
        return OptiFineLocator.isCompatibleOptiFineVersion(OptiFineLocator.getOptiFineVersion(configClass));
    }

    @Nullable
    public static String getOptiFineVersion() {
        Class<?> configClass = OptiFineLocator.findConfigClass();
        return configClass == null ? null : OptiFineLocator.getOptiFineVersion(configClass);
    }

    @Nonnull
    private static String getOptiFineVersion(Class<?> configClass) {
        try {
            Field versionField = configClass.getField("VERSION");
            versionField.setAccessible(true);
            return (String)versionField.get(null);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            CrashReport crashReport = CrashReport.func_85055_a((Throwable)e, (String)"Problem getting OptiFine version");
            crashReport.func_85058_a("NoCubes OptiFine Locator");
            throw new ReportedException(crashReport);
        }
    }

    public static boolean isOptiFineInstalled() {
        return OptiFineLocator.findConfigClass() != null;
    }
}

