/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.optifine;

import io.github.cadiboo.nocubes.client.optifine.HardOptiFineCompatibility;
import io.github.cadiboo.nocubes.client.optifine.OptiFineLocator;
import io.github.cadiboo.nocubes.client.optifine.OptiFineNotPresentException;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.chunk.ChunkRenderCache;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;

public final class OptiFineCompatibility {
    public static final boolean OPTIFINE_INSTALLED = OptiFineLocator.isOptiFineInstalledAndCompatible();

    public static void pushShaderThing(@Nonnull BlockState blockState, @Nonnull BlockPos pos, @Nonnull IEnviromentBlockReader reader, @Nonnull BufferBuilder bufferBuilder) {
        if (!OPTIFINE_INSTALLED) {
            return;
        }
        HardOptiFineCompatibility.pushShaderThing(blockState, pos, reader, bufferBuilder);
    }

    public static void pushShaderThing(@Nonnull IFluidState fluidState, @Nonnull BlockPos pos, @Nonnull IEnviromentBlockReader reader, @Nonnull BufferBuilder bufferBuilder) {
        OptiFineCompatibility.pushShaderThing(fluidState.func_206883_i(), pos, reader, bufferBuilder);
    }

    public static void popShaderThing(@Nonnull BufferBuilder bufferBuilder) {
        if (!OPTIFINE_INSTALLED) {
            return;
        }
        HardOptiFineCompatibility.popShaderThing(bufferBuilder);
    }

    public static boolean isChunkCacheOF(@Nonnull IEnviromentBlockReader reader) {
        if (!OPTIFINE_INSTALLED) {
            return false;
        }
        return HardOptiFineCompatibility.isChunkCacheOF(reader);
    }

    @Nonnull
    public static ChunkRenderCache getChunkRenderCache(@Nonnull IEnviromentBlockReader reader) {
        if (!OPTIFINE_INSTALLED) {
            throw new OptiFineNotPresentException();
        }
        return HardOptiFineCompatibility.getChunkRenderCache(reader);
    }

    public static final class BlockModelCustomizer {
        @Nonnull
        public static IBakedModel getRenderModel(@Nonnull IBakedModel model, @Nonnull BlockState blockState, @Nonnull Object renderEnv) {
            if (!OPTIFINE_INSTALLED) {
                throw new OptiFineNotPresentException();
            }
            return HardOptiFineCompatibility.BlockModelCustomizerOF.getRenderModel(model, blockState, renderEnv);
        }

        @Nonnull
        public static List<BakedQuad> getRenderQuads(@Nonnull List<BakedQuad> quads, @Nonnull IEnviromentBlockReader reader, @Nonnull BlockState blockState, @Nonnull BlockPos pos, @Nonnull Direction direction, @Nonnull BlockRenderLayer blockRenderLayer, long rand, @Nonnull Object renderEnv) {
            if (!OPTIFINE_INSTALLED) {
                throw new OptiFineNotPresentException();
            }
            return HardOptiFineCompatibility.BlockModelCustomizerOF.getRenderQuads(quads, reader, blockState, pos, direction, blockRenderLayer, rand, renderEnv);
        }
    }

    public static final class BufferBuilderOF {
        @Nonnull
        public static Object getRenderEnv(@Nonnull BufferBuilder bufferBuilder, @Nonnull BlockState state, @Nonnull BlockPos pos) {
            if (!OPTIFINE_INSTALLED) {
                throw new OptiFineNotPresentException();
            }
            return HardOptiFineCompatibility.BufferBuilderOF.getRenderEnv(bufferBuilder, state, pos);
        }
    }
}

