/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.gui.toast;

import com.mojang.blaze3d.platform.GlStateManager;
import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.client.render.BufferBuilderCache;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.toasts.ToastGui;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.model.TRSRTransformation;

public abstract class BlockStateToast
implements IToast {
    private static final Matrix4f ITEM_CAMERA_TRANSFORM_MATRIX = TRSRTransformation.from((ItemTransformVec3f)new ItemTransformVec3f(new Vector3f(-30.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f))).getMatrixVec();
    @Nonnull
    private final BufferBuilderCache bufferCache = new BufferBuilderCache(512, 512, 512, 512);
    @Nonnull
    private final boolean[] usedBlockRenderLayers = new boolean[ClientUtil.BLOCK_RENDER_LAYER_VALUES_LENGTH];
    @Nonnull
    private final String name;

    BlockStateToast(@Nonnull BlockState state, @Nonnull BlockPos pos) {
        Minecraft minecraft = Minecraft.func_71410_x();
        this.name = state.func_177230_c().func_200291_n().func_150254_d();
        this.build(state, pos, (IWorldReader)minecraft.field_71441_e, minecraft.func_175602_ab(), new Random());
    }

    private static void drawBuffer(@Nonnull BufferBuilder bufferBuilderIn) {
        if (bufferBuilderIn.func_178989_h() > 0) {
            VertexFormat vertexformat = bufferBuilderIn.func_178973_g();
            int i = vertexformat.func_177338_f();
            ByteBuffer bytebuffer = bufferBuilderIn.func_178966_f();
            List list = vertexformat.func_177343_g();
            for (int j = 0; j < list.size(); ++j) {
                VertexFormatElement vertexformatelement = (VertexFormatElement)list.get(j);
                bytebuffer.position(vertexformat.func_181720_d(j));
                vertexformatelement.func_177375_c().preDraw(vertexformat, j, i, bytebuffer);
            }
            GlStateManager.drawArrays((int)bufferBuilderIn.func_178979_i(), (int)0, (int)bufferBuilderIn.func_178989_h());
            int j1 = list.size();
            for (int i1 = 0; i1 < j1; ++i1) {
                VertexFormatElement vertexformatelement1 = (VertexFormatElement)list.get(i1);
                vertexformatelement1.func_177375_c().postDraw(vertexformat, i1, i, bytebuffer);
            }
        }
    }

    private void build(@Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull IWorldReader reader, @Nonnull BlockRendererDispatcher blockRendererDispatcher, @Nonnull Random random) {
        if (state.func_185901_i() != BlockRenderType.MODEL) {
            return;
        }
        boolean[] startedBufferBuilders = new boolean[ClientUtil.BLOCK_RENDER_LAYER_VALUES_LENGTH];
        BlockModelRenderer blockModelRenderer = blockRendererDispatcher.func_175019_b();
        for (int i = 0; i < ClientUtil.BLOCK_RENDER_LAYER_VALUES_LENGTH; ++i) {
            BlockRenderLayer blockRenderLayer = ClientUtil.BLOCK_RENDER_LAYER_VALUES[i];
            if (!state.func_177230_c().canRenderInLayer(state, blockRenderLayer)) continue;
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)blockRenderLayer);
            int blockRenderLayerId = blockRenderLayer.ordinal();
            BufferBuilder bufferBuilder = this.bufferCache.get(blockRenderLayerId);
            if (!startedBufferBuilders[blockRenderLayerId]) {
                startedBufferBuilders[blockRenderLayerId] = true;
                bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                bufferBuilder.func_178969_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
            }
            int n = blockRenderLayerId;
            this.usedBlockRenderLayers[n] = this.usedBlockRenderLayers[n] | blockModelRenderer.func_217631_a((IEnviromentBlockReader)reader, blockRendererDispatcher.func_184389_a(state), state, pos, bufferBuilder, false, random, state.func_209533_a(pos));
        }
        ForgeHooksClient.setRenderLayer(null);
        for (int blockRenderLayerId = 0; blockRenderLayerId < this.usedBlockRenderLayers.length; ++blockRenderLayerId) {
            if (!startedBufferBuilders[blockRenderLayerId]) continue;
            this.bufferCache.get(blockRenderLayerId).func_178977_d();
        }
    }

    public abstract String getUpdateType();

    @Nonnull
    public IToast.Visibility func_193653_a(@Nonnull ToastGui toastGui, long delta) {
        Minecraft minecraft = toastGui.func_192989_b();
        minecraft.func_110434_K().func_110577_a(field_193654_a);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        toastGui.blit(0, 0, 0, 0, 160, 32);
        minecraft.field_71466_p.func_211126_b(I18n.func_135052_a((String)this.getUpdateType(), (Object[])new Object[0]) + ":", 30.0f, 7.0f, -1);
        minecraft.field_71466_p.func_211126_b(this.name, 30.0f, 18.0f, -1);
        Entity entity = minecraft.func_175606_aa();
        if (entity != null) {
            minecraft.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            minecraft.func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174936_b(false, false);
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.0f, (float)0.0f, (float)100.0f);
            GlStateManager.enableRescaleNormal();
            GlStateManager.enableAlphaTest();
            GlStateManager.alphaFunc((int)516, (float)0.1f);
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.translatef((float)7.0f, (float)21.0f, (float)0.0f);
            GlStateManager.scalef((float)-1.0f, (float)-1.0f, (float)1.0f);
            GlStateManager.scalef((float)20.0f, (float)20.0f, (float)20.0f);
            RenderHelper.func_74520_c();
            ForgeHooksClient.multiplyCurrentGlMatrix((Matrix4f)ITEM_CAMERA_TRANSFORM_MATRIX);
            for (int blockRenderLayerId = 0; blockRenderLayerId < this.usedBlockRenderLayers.length; ++blockRenderLayerId) {
                if (!this.usedBlockRenderLayers[blockRenderLayerId]) continue;
                BlockStateToast.drawBuffer(this.bufferCache.get(blockRenderLayerId));
            }
            RenderHelper.func_74518_a();
            GlStateManager.disableAlphaTest();
            GlStateManager.disableRescaleNormal();
            GlStateManager.popMatrix();
            minecraft.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            minecraft.func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174935_a();
        }
        return delta >= 10000L ? IToast.Visibility.HIDE : IToast.Visibility.SHOW;
    }

    public static final class RemoveLeaves
    extends BlockStateToast {
        public RemoveLeaves(@Nonnull BlockState state, @Nonnull BlockPos pos) {
            super(state, pos);
        }

        @Override
        public String getUpdateType() {
            return "nocubes.removedLeavesSmoothableBlockState";
        }
    }

    public static final class AddLeaves
    extends BlockStateToast {
        public AddLeaves(@Nonnull BlockState state, @Nonnull BlockPos pos) {
            super(state, pos);
        }

        @Override
        public String getUpdateType() {
            return "nocubes.addedLeavesSmoothableBlockState";
        }
    }

    public static final class RemoveTerrain
    extends BlockStateToast {
        public RemoveTerrain(@Nonnull BlockState state, @Nonnull BlockPos pos) {
            super(state, pos);
        }

        @Override
        public String getUpdateType() {
            return "nocubes.removedTerrainSmoothableBlockState";
        }
    }

    public static final class AddTerrain
    extends BlockStateToast {
        public AddTerrain(@Nonnull BlockState state, @Nonnull BlockPos pos) {
            super(state, pos);
        }

        @Override
        public String getUpdateType() {
            return "nocubes.addedTerrainSmoothableBlockState";
        }
    }
}

