/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.gui.config;

import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.client.gui.config.ConfigOptionsList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public final class NoCubesConfigGui
extends Screen {
    private final Minecraft minecraft;
    private final Screen parentScreen;
    private ConfigOptionsList configOptionsList;

    public NoCubesConfigGui(Minecraft minecraft, Screen parentScreen) {
        super((ITextComponent)new TranslationTextComponent("nocubes.config.title", new Object[0]));
        this.minecraft = minecraft;
        this.parentScreen = parentScreen;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.configOptionsList.render(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.minecraft.field_71466_p, this.title.func_150254_d(), this.width / 2, 8, 0xFFFFFF);
        super.render(mouseX, mouseX, partialTicks);
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    protected void init() {
        super.init();
        FontRenderer fontRenderer = this.minecraft.field_71466_p;
        String doneText = I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]);
        int doneWidth = Math.max(fontRenderer.func_78256_a(doneText) + 20, 100);
        int buttonWidthHalf = (doneWidth + 5) / 2;
        int halfWidth = this.width / 2;
        int buttonsHeight = this.height - 29;
        this.addButton((Widget)new Button(halfWidth - buttonWidthHalf, buttonsHeight, doneWidth, 20, doneText, $ -> {
            if (this.configOptionsList.saveChanged()) {
                ClientUtil.tryReloadRenderers();
            }
            this.minecraft.func_147108_a(this.parentScreen);
        }));
        this.configOptionsList = new ConfigOptionsList(this, this.minecraft);
        this.children.add(this.configOptionsList);
    }

    public void tick() {
        this.configOptionsList.children().forEach(ConfigOptionsList.Entry::tick);
        super.tick();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }
}

