/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.gui.config;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.github.cadiboo.nocubes.client.gui.config.BooleanOption;
import io.github.cadiboo.nocubes.client.gui.config.EnumOption;
import io.github.cadiboo.nocubes.client.gui.config.ListOption;
import io.github.cadiboo.nocubes.client.gui.config.NoCubesConfigGui;
import io.github.cadiboo.nocubes.config.ConfigHelper;
import io.github.cadiboo.nocubes.config.ConfigHolder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.LazyLoadBase;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

final class ConfigOptionsList
extends AbstractOptionList<Entry> {
    private static final Joiner DOT_JOINER = Joiner.on((String)".");
    private final NoCubesConfigGui configGui;
    private final int maxListLabelWidth;

    public ConfigOptionsList(NoCubesConfigGui configGui, Minecraft mcIn) {
        super(mcIn, configGui.width + 45, configGui.height, 43, configGui.height - 32, 20);
        this.configGui = configGui;
        ArrayList<CategoryEntry> entries = new ArrayList<CategoryEntry>();
        CategoryEntry clientCategoryEntry = new CategoryEntry("nocubes.config.client");
        entries.add(clientCategoryEntry);
        this.addEntry((AbstractList.AbstractListEntry)clientCategoryEntry);
        this.getConfigValues(ConfigHolder.CLIENT).forEach((configValue, name) -> {
            ValueEntry<?> e = this.createValueEntry((ForgeConfigSpec.ConfigValue<?>)configValue, (String)name, () -> ConfigHelper.clientConfig);
            entries.add((CategoryEntry)((Object)((Object)e)));
            this.addEntry((AbstractList.AbstractListEntry)e);
        });
        if (this.minecraft.field_71441_e != null && this.minecraft.func_71401_C() != null) {
            CategoryEntry serverCategoryEntry = new CategoryEntry("nocubes.config.server");
            entries.add(serverCategoryEntry);
            this.addEntry((AbstractList.AbstractListEntry)serverCategoryEntry);
            this.getConfigValues(ConfigHolder.SERVER).forEach((configValue, name) -> {
                ValueEntry<?> e = this.createValueEntry((ForgeConfigSpec.ConfigValue<?>)configValue, (String)name, () -> ConfigHelper.serverConfig);
                entries.add((CategoryEntry)((Object)((Object)e)));
                this.addEntry((AbstractList.AbstractListEntry)e);
            });
        }
        FontRenderer fontRenderer = mcIn.field_71466_p;
        int maxListLabelWidth = 0;
        for (Entry entry : entries) {
            int i = fontRenderer.func_78256_a(entry.getTranslatedText());
            if (i <= maxListLabelWidth) continue;
            maxListLabelWidth = i;
        }
        this.maxListLabelWidth = maxListLabelWidth;
    }

    private static void saveValue(ForgeConfigSpec.ConfigValue<?> configValue, Supplier<ModConfig> configSupplier, Object newValue) {
        ConfigHelper.setValueAndSave(configSupplier.get(), DOT_JOINER.join((Iterable)configValue.getPath()), newValue);
    }

    @Nonnull
    private ValueEntry<?> createValueEntry(ForgeConfigSpec.ConfigValue<?> configValue, String name, Supplier<ModConfig> configSupplier) {
        if (configValue instanceof ForgeConfigSpec.BooleanValue) {
            return new BooleanValueEntry((ForgeConfigSpec.BooleanValue)configValue, name, configSupplier);
        }
        if (configValue instanceof ForgeConfigSpec.EnumValue) {
            return new EnumValueEntry((ForgeConfigSpec.EnumValue)configValue, name, configSupplier);
        }
        try {
            return new ListValueEntry(configValue, name, configSupplier);
        }
        catch (Exception e) {
            return new NotImplementedValueEntry(configValue, name, configSupplier);
        }
    }

    private Map<ForgeConfigSpec.ConfigValue<?>, String> getConfigValues(Object config) {
        HashMap configValuesAndNames = new HashMap();
        for (Field declaredField : config.getClass().getDeclaredFields()) {
            declaredField.setAccessible(true);
            try {
                Object o = declaredField.get(config);
                if (!(o instanceof ForgeConfigSpec.ConfigValue)) continue;
                configValuesAndNames.put((ForgeConfigSpec.ConfigValue)o, declaredField.getName());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return configValuesAndNames;
    }

    public int getRowWidth() {
        return super.getRowWidth() + 150;
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 15 + 20;
    }

    boolean saveChanged() {
        boolean wasAnythingSaved = false;
        for (Entry entry : this.children()) {
            if (entry instanceof ValueEntry) {
                ValueEntry valueEntry = (ValueEntry)entry;
                if (!valueEntry.isChanged()) continue;
                ConfigOptionsList.saveValue(valueEntry.configValue, valueEntry.configSupplier, valueEntry.currentValue);
                wasAnythingSaved = true;
                continue;
            }
            if (!(entry instanceof CategoryEntry)) continue;
            CategoryEntry categoryEntry = (CategoryEntry)entry;
        }
        return wasAnythingSaved;
    }

    private final class NotImplementedValueEntry<T>
    extends ValueEntry<T> {
        NotImplementedValueEntry(ForgeConfigSpec.ConfigValue<T> configValue, String name, Supplier<ModConfig> configSupplier) {
            super(configValue, name, configSupplier);
        }

        @Override
        protected Widget makeWidget() {
            Widget widget = new BooleanOption(this.text, () -> false, this::handleChanged){

                @Override
                public String getTranslatedName() {
                    return this.getDisplayString() + I18n.func_135052_a((String)"argument.criteria.invalid", (Object[])new Object[]{NotImplementedValueEntry.this.getTranslatedText()});
                }
            }.createWidget(((ConfigOptionsList)ConfigOptionsList.this).configGui.width / 4 * 3);
            widget.setFGColor(0xFF0000);
            return widget;
        }

        @Override
        private void handleChanged(Boolean ignored) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    final class ListValueEntry<T>
    extends ValueEntry<List<? extends T>> {
        ListValueEntry(ForgeConfigSpec.ConfigValue<List<? extends T>> listValue, String name, Supplier<ModConfig> configSupplier) {
            super(listValue, name, configSupplier);
        }

        @Override
        protected Widget makeWidget() {
            return new ListOption(this.text, () -> (String[])((List)this.currentValue).stream().map(Object::toString).toArray(String[]::new), this::handleChanged).createWidget(((ConfigOptionsList)ConfigOptionsList.this).configGui.width / 4 * 3);
        }

        @Override
        private void handleChanged(String[] newValue) {
            ArrayList<String> list = new ArrayList<String>();
            for (String str : newValue) {
                list.add(str);
            }
            this.handleChanged(list);
        }

        @Override
        void tick() {
            super.tick();
            ((TextFieldWidget)this.widgetSupplier.func_179281_c()).func_146178_a();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    final class EnumValueEntry<T extends Enum<T>>
    extends ValueEntry<T> {
        final T[] values;

        EnumValueEntry(ForgeConfigSpec.EnumValue<T> enumValue, String name, Supplier<ModConfig> configSupplier) {
            super((ForgeConfigSpec.ConfigValue)enumValue, name, configSupplier);
            this.values = (Enum[])((Enum)this.initialValue).getDeclaringClass().getEnumConstants();
        }

        private int cycleAndSave(int ordinal) {
            int i = (ordinal + 1) % this.values.length;
            this.handleChanged(this.values[i]);
            return i;
        }

        private String getTranslatedText(EnumOption enumOption) {
            return enumOption.getDisplayString() + ((Enum)this.currentValue).name();
        }

        @Override
        protected Widget makeWidget() {
            return new EnumOption(this.text, this::cycleAndSave, this::getTranslatedText, ((Enum)this.currentValue).ordinal()).createWidget(((ConfigOptionsList)ConfigOptionsList.this).configGui.width / 4 * 3);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    final class BooleanValueEntry
    extends ValueEntry<Boolean> {
        BooleanValueEntry(ForgeConfigSpec.BooleanValue booleanValue, String name, Supplier<ModConfig> configSupplier) {
            super((ForgeConfigSpec.ConfigValue)booleanValue, name, configSupplier);
        }

        @Override
        protected Widget makeWidget() {
            return new BooleanOption(this.text, () -> (Boolean)this.currentValue, this::handleChanged).createWidget(((ConfigOptionsList)ConfigOptionsList.this).configGui.width / 4 * 3);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    abstract class ValueEntry<T>
    extends Entry {
        final ForgeConfigSpec.ConfigValue<T> configValue;
        final String text;
        final int initialHash;
        final T initialValue;
        final Supplier<ModConfig> configSupplier;
        final LazyLoadBase<Widget> widgetSupplier;
        T currentValue;

        private ValueEntry(ForgeConfigSpec.ConfigValue<T> configValue, String name, Supplier<ModConfig> configSupplier) {
            this.configValue = configValue;
            this.text = I18n.func_135052_a((String)("nocubes.config." + name), (Object[])new Object[0]);
            this.configSupplier = configSupplier;
            Object value = configValue.get();
            this.initialValue = value;
            this.currentValue = this.initialValue;
            this.initialHash = Objects.hashCode(value);
            this.widgetSupplier = new LazyLoadBase(this::makeWidget);
        }

        protected abstract Widget makeWidget();

        public void render(int p_render_1_, int y, int x, int p_render_4_, int p_render_5_, int mouseX, int mouseY, boolean isHovered, float partialTicks) {
            Widget widget = (Widget)this.widgetSupplier.func_179281_c();
            if (widget instanceof TextFieldWidget) {
                widget.x = x + 2;
                widget.y = y + 2;
            } else {
                widget.x = x;
                widget.y = y;
            }
            widget.render(mouseX, mouseY, partialTicks);
        }

        @Nonnull
        public List<? extends IGuiEventListener> children() {
            return ImmutableList.of((Object)this.widgetSupplier.func_179281_c());
        }

        @Override
        String getTranslatedText() {
            return this.text;
        }

        void handleChanged(T newValue) {
            this.currentValue = newValue;
        }

        public boolean isChanged() {
            return this.initialHash != Objects.hashCode(this.currentValue);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    final class CategoryEntry
    extends Entry {
        private final String labelText;
        private final int labelWidth;

        CategoryEntry(String name) {
            this.labelText = I18n.func_135052_a((String)name, (Object[])new Object[0]);
            this.labelWidth = ((ConfigOptionsList)ConfigOptionsList.this).minecraft.field_71466_p.func_78256_a(this.labelText);
        }

        public void render(int p_render_1_, int y, int x, int p_render_4_, int p_render_5_, int mouseX, int mouseY, boolean isHovered, float partialTicks) {
            ((ConfigOptionsList)ConfigOptionsList.this).minecraft.field_71466_p.func_211126_b("Category: " + this.labelText, (float)(((ConfigOptionsList)ConfigOptionsList.this).configGui.width / 2 - this.labelWidth), (float)(y + p_render_5_ - 9 - 1), 0xFFFFFF);
        }

        @Nonnull
        public List<? extends IGuiEventListener> children() {
            return Collections.emptyList();
        }

        public boolean changeFocus(boolean p_changeFocus_1_) {
            return false;
        }

        @Override
        String getTranslatedText() {
            return this.labelText;
        }
    }

    static abstract class Entry
    extends AbstractOptionList.Entry<Entry> {
        Entry() {
        }

        abstract String getTranslatedText();

        void tick() {
        }
    }
}

