/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client;

import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.util.pooled.cache.StateCache;
import io.github.cadiboo.nocubes.util.pooled.cache.XYZCache;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.fml.common.EnhancedRuntimeException;
import org.apache.logging.log4j.LogManager;

public final class LazyPackedLightCache
extends XYZCache
implements AutoCloseable {
    private static final ThreadLocal<LazyPackedLightCache> POOL = ThreadLocal.withInitial(() -> new LazyPackedLightCache(0, 0, 0, 0, 0, 0));
    private static final ThreadLocal<BlockPos.MutableBlockPos> MUTABLE_BLOCK_POS = ThreadLocal.withInitial(BlockPos.MutableBlockPos::new);
    @Nonnull
    public IEnviromentBlockReader reader;
    @Nonnull
    public StateCache stateCache;
    @Nonnull
    public int[] cache;
    private int chunkRenderPosX;
    private int chunkRenderPosY;
    private int chunkRenderPosZ;
    private boolean inUse;

    private LazyPackedLightCache(int startPaddingX, int startPaddingY, int startPaddingZ, int sizeX, int sizeY, int sizeZ) {
        super(startPaddingX, startPaddingY, startPaddingZ, sizeX, sizeY, sizeZ);
        int size = sizeX * sizeY * sizeZ;
        this.cache = new int[size];
        System.arraycopy(ClientUtil.NEGATIVE_1_8000, 0, this.cache, 0, size);
        this.inUse = false;
    }

    @Nonnull
    public static LazyPackedLightCache retain(int startPaddingX, int startPaddingY, int startPaddingZ, int sizeX, int sizeY, int sizeZ, @Nonnull IEnviromentBlockReader reader, @Nonnull StateCache stateCache, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ) {
        LazyPackedLightCache pooled = POOL.get();
        if (pooled.inUse) {
            throw new IllegalStateException("LazyPackedLightCache is already in use!");
        }
        pooled.inUse = true;
        pooled.reader = reader;
        pooled.stateCache = stateCache;
        pooled.chunkRenderPosX = chunkRenderPosX;
        pooled.chunkRenderPosY = chunkRenderPosY;
        pooled.chunkRenderPosZ = chunkRenderPosZ;
        pooled.startPaddingX = startPaddingX;
        pooled.startPaddingY = startPaddingY;
        pooled.startPaddingZ = startPaddingZ;
        int size = sizeX * sizeY * sizeZ;
        if (pooled.sizeX == sizeX && pooled.sizeY == sizeY && pooled.sizeZ == sizeZ) {
            System.arraycopy(ClientUtil.NEGATIVE_1_8000, 0, pooled.cache, 0, size);
            return pooled;
        }
        pooled.sizeX = sizeX;
        pooled.sizeY = sizeY;
        pooled.sizeZ = sizeZ;
        if (pooled.cache.length < size || (float)pooled.cache.length > (float)size * 1.25f) {
            pooled.cache = new int[size];
        }
        System.arraycopy(ClientUtil.NEGATIVE_1_8000, 0, pooled.cache, 0, size);
        return pooled;
    }

    public static int get(int x, int y, int z, int[] cache, int index, StateCache stateCache, IEnviromentBlockReader reader, BlockPos.MutableBlockPos mutableBlockPos, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, int startPaddingX, int startPaddingY, int startPaddingZ, int diffX, int diffY, int diffZ, int stateCacheSizeX, int stateCacheSizeY) {
        try {
            int packedLight = cache[index];
            if (packedLight == -1) {
                try {
                    packedLight = stateCache.getBlockStates()[stateCache.getIndex(x + diffX, y + diffY, z + diffZ, stateCacheSizeX, stateCacheSizeY)].func_215684_a(reader, (BlockPos)mutableBlockPos.func_181079_c(chunkRenderPosX + x - startPaddingX, chunkRenderPosY + y - startPaddingY, chunkRenderPosZ + z - startPaddingZ));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new CustomArrayIndexOutOfBoundsException.StateCacheException(x, y, z, cache, index, stateCache, reader, mutableBlockPos, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, startPaddingX, startPaddingY, startPaddingZ, diffX, diffY, diffZ, e, x + diffX, y + diffY, z + diffZ, stateCacheSizeX, stateCacheSizeY, stateCache.getIndex(x + diffX, y + diffY, z + diffZ, stateCacheSizeX, stateCacheSizeY));
                }
                cache[index] = packedLight;
                if (packedLight == -1) {
                    LogManager.getLogger().error("BARRRF");
                }
            }
            return packedLight;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new CustomArrayIndexOutOfBoundsException(x, y, z, cache, index, stateCache, reader, mutableBlockPos, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, startPaddingX, startPaddingY, startPaddingZ, diffX, diffY, diffZ, e);
        }
    }

    @Deprecated
    public int get(int x, int y, int z) {
        return this.get(x, y, z, this.cache, this.stateCache, this.reader, MUTABLE_BLOCK_POS.get(), this.chunkRenderPosX, this.chunkRenderPosY, this.chunkRenderPosZ, this.startPaddingX, this.startPaddingY, this.startPaddingZ, this.stateCache.startPaddingX - this.startPaddingX, this.stateCache.startPaddingY - this.startPaddingY, this.stateCache.startPaddingZ - this.startPaddingZ);
    }

    @Deprecated
    public int get(int x, int y, int z, int[] cache, StateCache stateCache, IEnviromentBlockReader reader, BlockPos.MutableBlockPos mutableBlockPos, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, int startPaddingX, int startPaddingY, int startPaddingZ, int diffX, int diffY, int diffZ) {
        return LazyPackedLightCache.get(x, y, z, cache, this.getIndex(x, y, z, this.sizeX, this.sizeY), stateCache, reader, mutableBlockPos, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, startPaddingX, startPaddingY, startPaddingZ, diffX, diffY, diffZ, stateCache.sizeX, stateCache.sizeY);
    }

    @Override
    public void close() {
        this.inUse = false;
    }

    private static class CustomArrayIndexOutOfBoundsException
    extends EnhancedRuntimeException {
        private final int x;
        private final int y;
        private final int z;
        private final int[] cache;
        private final int index;
        private final StateCache stateCache;
        private final IEnviromentBlockReader reader;
        private final BlockPos.MutableBlockPos mutableBlockPos;
        private final int chunkRenderPosX;
        private final int chunkRenderPosY;
        private final int chunkRenderPosZ;
        private final int startPaddingX;
        private final int startPaddingY;
        private final int startPaddingZ;
        private final int diffX;
        private final int diffY;
        private final int diffZ;

        CustomArrayIndexOutOfBoundsException(int x, int y, int z, int[] cache, int index, StateCache stateCache, IEnviromentBlockReader reader, BlockPos.MutableBlockPos mutableBlockPos, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, int startPaddingX, int startPaddingY, int startPaddingZ, int diffX, int diffY, int diffZ, ArrayIndexOutOfBoundsException e) {
            super((Throwable)e);
            this.x = x;
            this.y = y;
            this.z = z;
            this.cache = cache;
            this.index = index;
            this.stateCache = stateCache;
            this.reader = reader;
            this.mutableBlockPos = mutableBlockPos;
            this.chunkRenderPosX = chunkRenderPosX;
            this.chunkRenderPosY = chunkRenderPosY;
            this.chunkRenderPosZ = chunkRenderPosZ;
            this.startPaddingX = startPaddingX;
            this.startPaddingY = startPaddingY;
            this.startPaddingZ = startPaddingZ;
            this.diffX = diffX;
            this.diffY = diffY;
            this.diffZ = diffZ;
        }

        protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
            stream.println("x: " + this.x);
            stream.println("y: " + this.y);
            stream.println("z: " + this.z);
            stream.println("cache: " + this.cache);
            stream.println("index: " + this.index);
            stream.println("stateCache: " + this.stateCache);
            stream.println("reader: " + this.reader);
            stream.println("mutableBlockPos: " + this.mutableBlockPos);
            stream.println("chunkRenderPosX: " + this.chunkRenderPosX);
            stream.println("chunkRenderPosY: " + this.chunkRenderPosY);
            stream.println("chunkRenderPosZ: " + this.chunkRenderPosZ);
            stream.println("startPaddingX: " + this.startPaddingX);
            stream.println("startPaddingY: " + this.startPaddingY);
            stream.println("startPaddingZ: " + this.startPaddingZ);
            stream.println("diffX: " + this.diffX);
            stream.println("diffY: " + this.diffY);
            stream.println("diffZ: " + this.diffZ);
        }

        public static class StateCacheException
        extends CustomArrayIndexOutOfBoundsException {
            private final int xPdiffX;
            private final int yPdiffY;
            private final int zPdiffZ;
            private final int stateCacheSizeX;
            private final int stateCacheSizeY;
            private final int stateCacheIndex;

            StateCacheException(int x, int y, int z, int[] cache, int index, StateCache stateCache, IEnviromentBlockReader reader, BlockPos.MutableBlockPos mutableBlockPos, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, int startPaddingX, int startPaddingY, int startPaddingZ, int diffX, int diffY, int diffZ, ArrayIndexOutOfBoundsException e, int xPdiffX, int yPdiffY, int zPdiffZ, int stateCacheSizeX, int stateCacheSizeY, int stateCacheIndex) {
                super(x, y, z, cache, index, stateCache, reader, mutableBlockPos, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, startPaddingX, startPaddingY, startPaddingZ, diffX, diffY, diffZ, e);
                this.xPdiffX = xPdiffX;
                this.yPdiffY = yPdiffY;
                this.zPdiffZ = zPdiffZ;
                this.stateCacheSizeX = stateCacheSizeX;
                this.stateCacheSizeY = stateCacheSizeY;
                this.stateCacheIndex = stateCacheIndex;
            }

            @Override
            protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                super.printStackTrace();
                stream.println("x + diffX: " + this.xPdiffX);
                stream.println("y + diffY: " + this.yPdiffY);
                stream.println("z + diffZ: " + this.zPdiffZ);
                stream.println("stateCacheSizeX: " + this.stateCacheSizeX);
                stream.println("stateCacheSizeY: " + this.stateCacheSizeY);
                stream.println("stateCacheIndex: " + this.stateCacheIndex);
            }
        }
    }
}

