/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client;

import com.mojang.blaze3d.platform.GlStateManager;
import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.client.BlockColorInfo;
import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.client.gui.toast.BlockStateToast;
import io.github.cadiboo.nocubes.client.gui.widget.IngameModListButton;
import io.github.cadiboo.nocubes.client.render.SmoothLightingFluidBlockRenderer;
import io.github.cadiboo.nocubes.config.Config;
import io.github.cadiboo.nocubes.config.ConfigHelper;
import io.github.cadiboo.nocubes.mesh.MeshDispatcher;
import io.github.cadiboo.nocubes.mesh.MeshGeneratorType;
import io.github.cadiboo.nocubes.network.C2SRequestAddTerrainSmoothable;
import io.github.cadiboo.nocubes.network.C2SRequestDisableTerrainCollisions;
import io.github.cadiboo.nocubes.network.C2SRequestEnableTerrainCollisions;
import io.github.cadiboo.nocubes.network.C2SRequestRemoveTerrainSmoothable;
import io.github.cadiboo.nocubes.util.IsSmoothable;
import io.github.cadiboo.nocubes.util.ModProfiler;
import io.github.cadiboo.nocubes.util.Profiler1122;
import io.github.cadiboo.nocubes.util.pooled.Face;
import io.github.cadiboo.nocubes.util.pooled.FaceList;
import io.github.cadiboo.nocubes.util.pooled.Vec3;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.PlayerSPPushOutOfBlocksEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.ConnectionType;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;

@Mod.EventBusSubscriber(modid="nocubes", value={Dist.CLIENT})
public final class ClientEventSubscriber {
    private static final String CATEGORY = "key.categories.nocubes";
    private static final KeyBinding toggleRenderSmoothTerrain = new KeyBinding("nocubes.key.toggleRenderSmoothTerrain", 79, "key.categories.nocubes");
    private static final KeyBinding toggleRenderSmoothLeaves = new KeyBinding("nocubes.key.toggleRenderSmoothLeaves", 73, "key.categories.nocubes");
    private static final KeyBinding toggleProfilers = new KeyBinding("nocubes.key.toggleProfilers", 80, "key.categories.nocubes");
    private static final KeyBinding toggleTerrainSmoothableBlockState = new KeyBinding("nocubes.key.toggleTerrainSmoothableBlockState", 78, "key.categories.nocubes");
    private static final KeyBinding toggleLeavesSmoothableBlockState = new KeyBinding("nocubes.key.toggleLeavesSmoothableBlockState", 75, "key.categories.nocubes");
    private static final KeyBinding toggleTerrainCollisions = new KeyBinding("nocubes.key.toggleTerrainCollisions", 67, "key.categories.nocubes");
    public static SmoothLightingFluidBlockRenderer smoothLightingBlockFluidRenderer;

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        RayTraceResult objectMouseOver;
        ClientWorld world;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayNetHandler connection = minecraft.func_147114_u();
        if (connection != null) {
            if (NetworkHooks.getConnectionType(() -> ((ClientPlayNetHandler)connection).func_147298_b()) != ConnectionType.MODDED) {
                Config.terrainCollisions = false;
            }
        }
        if ((world = minecraft.field_71441_e) != null && world.func_82737_E() % 1200L == 0L) {
            BlockColorInfo.refresh();
        }
        if (toggleRenderSmoothTerrain.func_151468_f()) {
            boolean newRenderSmoothTerrain = !Config.renderSmoothTerrain;
            ConfigHelper.setRenderSmoothTerrain(newRenderSmoothTerrain);
            Config.renderSmoothTerrain = newRenderSmoothTerrain;
            ClientUtil.tryReloadRenderers();
            return;
        }
        if (toggleRenderSmoothLeaves.func_151468_f()) {
            boolean newRenderSmoothLeaves = !Config.renderSmoothLeaves;
            ConfigHelper.setRenderSmoothLeaves(newRenderSmoothLeaves);
            Config.renderSmoothLeaves = newRenderSmoothLeaves;
            ClientUtil.tryReloadRenderers();
            return;
        }
        if (toggleTerrainCollisions.func_151468_f()) {
            if (Config.terrainCollisions) {
                NoCubes.CHANNEL.sendToServer((Object)new C2SRequestDisableTerrainCollisions());
            } else {
                NoCubes.CHANNEL.sendToServer((Object)new C2SRequestEnableTerrainCollisions());
            }
        }
        boolean terrainPressed = toggleTerrainSmoothableBlockState.func_151468_f();
        boolean leavesPressed = toggleLeavesSmoothableBlockState.func_151468_f();
        if ((terrainPressed || leavesPressed) && (objectMouseOver = minecraft.field_71476_x).func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos blockPos = ((BlockRayTraceResult)objectMouseOver).func_216350_a();
            BlockState state = world.func_180495_p(blockPos);
            if (terrainPressed) {
                if (state.nocubes_isTerrainSmoothable) {
                    NoCubes.CHANNEL.sendToServer((Object)new C2SRequestRemoveTerrainSmoothable(Block.func_196246_j((BlockState)state)));
                } else {
                    NoCubes.CHANNEL.sendToServer((Object)new C2SRequestAddTerrainSmoothable(Block.func_196246_j((BlockState)state)));
                }
            }
            if (leavesPressed) {
                BlockStateToast toast;
                if (!state.nocubes_isLeavesSmoothable) {
                    ConfigHelper.addLeavesSmoothable(state);
                    toast = new BlockStateToast.AddLeaves(state, blockPos);
                } else {
                    ConfigHelper.removeLeavesSmoothable(state);
                    toast = new BlockStateToast.RemoveLeaves(state, blockPos);
                }
                minecraft.func_193033_an().func_192988_a((IToast)toast);
                if (Config.renderSmoothLeaves) {
                    ClientUtil.tryReloadRenderers();
                }
            }
        }
        if (toggleProfilers.func_151468_f()) {
            if (ModProfiler.isProfilingEnabled()) {
                ModProfiler.disableProfiling();
            } else {
                ModProfiler.enableProfiling();
            }
        }
    }

    @SubscribeEvent
    public static void onRenderTickEvent(TickEvent.RenderTickEvent event) {
        if (!ModProfiler.isProfilingEnabled()) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71441_e == null || minecraft.field_71439_g == null || minecraft.func_175606_aa() == null) {
            return;
        }
        IProfiler profiler = minecraft.func_213239_aq();
        profiler.func_76320_a("debugNoCubes");
        GlStateManager.pushMatrix();
        try {
            ClientEventSubscriber.renderProfilers();
        }
        catch (Exception e) {
            LogManager.getLogger((String)"NoCubes Profile Renderer").error("Error Rendering Profilers.", (Throwable)e);
        }
        GlStateManager.popMatrix();
        profiler.func_76319_b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderProfilers() {
        Minecraft mc = Minecraft.func_71410_x();
        HashMap<Thread, ModProfiler> hashMap = ModProfiler.PROFILERS;
        synchronized (hashMap) {
            int visibleIndex = 0;
            for (Map.Entry<Thread, ModProfiler> entry : ModProfiler.PROFILERS.entrySet()) {
                Thread thread = entry.getKey();
                ModProfiler profiler = entry.getValue();
                List<Profiler1122.Result> list = profiler.getProfilingData("");
                if (list.size() < 2) continue;
                int offset = visibleIndex++;
                Profiler1122.Result profiler$result = list.remove(0);
                int size = list.size();
                GlStateManager.clear((int)256, (boolean)Minecraft.field_142025_a);
                GlStateManager.matrixMode((int)5889);
                GlStateManager.enableColorMaterial();
                GlStateManager.loadIdentity();
                int framebufferWidth = mc.field_195558_d.func_198109_k();
                int framebufferHeight = mc.field_195558_d.func_198091_l();
                GlStateManager.ortho((double)0.0, (double)framebufferWidth, (double)framebufferHeight, (double)0.0, (double)1000.0, (double)3000.0);
                GlStateManager.matrixMode((int)5888);
                GlStateManager.loadIdentity();
                GlStateManager.scalef((float)((float)framebufferWidth / 1000.0f), (float)((float)framebufferWidth / 1000.0f), (float)1.0f);
                GlStateManager.translatef((float)5.0f, (float)5.0f, (float)0.0f);
                GlStateManager.translatef((float)0.0f, (float)0.0f, (float)-2000.0f);
                GlStateManager.lineWidth((float)1.0f);
                int cx = 160 + 320 * (offset % 3);
                int cy = 100 + 320 * (offset / 3);
                GlStateManager.enableTexture();
                FontRenderer fontRenderer = mc.field_71466_p;
                fontRenderer.func_175063_a(thread.getName(), (float)(cx - 160), (float)(cy - 80 - 10 - 16), 0xFFFFFF);
                GlStateManager.disableTexture();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                GlStateManager.enableBlend();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                bufferbuilder.func_181662_b((double)((float)cx - 176.0f), (double)((float)cy - 96.0f - 16.0f), 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
                bufferbuilder.func_181662_b((double)((float)cx - 176.0f), (double)(cy + 320), 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
                bufferbuilder.func_181662_b((double)((float)cx + 176.0f), (double)(cy + 320), 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
                bufferbuilder.func_181662_b((double)((float)cx + 176.0f), (double)((float)cy - 96.0f - 16.0f), 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.disableBlend();
                double d0 = 0.0;
                for (int i = 0; i < size; ++i) {
                    Profiler1122.Result profiler$result1 = list.get(i);
                    double usePercentage = profiler$result1.usePercentage;
                    int i11 = MathHelper.func_76128_c((double)(usePercentage / 4.0)) + 1;
                    bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
                    int j1 = profiler$result1.getColor();
                    int k1 = j1 >> 16 & 0xFF;
                    int l1 = j1 >> 8 & 0xFF;
                    int i2 = j1 & 0xFF;
                    bufferbuilder.func_181662_b((double)cx, (double)cy, 0.0).func_181669_b(k1, l1, i2, 255).func_181675_d();
                    for (int j2 = i11; j2 >= 0; --j2) {
                        float f = (float)((d0 + usePercentage * (double)j2 / (double)i11) * (Math.PI * 2) / 100.0);
                        float f1 = MathHelper.func_76126_a((float)f) * 160.0f;
                        float f2 = MathHelper.func_76134_b((float)f) * 160.0f * 0.5f;
                        bufferbuilder.func_181662_b((double)((float)cx + f1), (double)((float)cy - f2), 0.0).func_181669_b(k1, l1, i2, 255).func_181675_d();
                    }
                    tessellator.func_78381_a();
                    bufferbuilder.func_181668_a(5, DefaultVertexFormats.field_181706_f);
                    for (int i3 = i11; i3 >= 0; --i3) {
                        float f3 = (float)((d0 + usePercentage * (double)i3 / (double)i11) * (Math.PI * 2) / 100.0);
                        float f4 = MathHelper.func_76126_a((float)f3) * 160.0f;
                        float f5 = MathHelper.func_76134_b((float)f3) * 160.0f * 0.5f;
                        bufferbuilder.func_181662_b((double)((float)cx + f4), (double)((float)cy - f5), 0.0).func_181669_b(k1 >> 1, l1 >> 1, i2 >> 1, 255).func_181675_d();
                        bufferbuilder.func_181662_b((double)((float)cx + f4), (double)((float)cy - f5 + 10.0f), 0.0).func_181669_b(k1 >> 1, l1 >> 1, i2 >> 1, 255).func_181675_d();
                    }
                    tessellator.func_78381_a();
                    d0 += usePercentage;
                }
                DecimalFormat decimalformat = new DecimalFormat("##0.00");
                GlStateManager.enableTexture();
                String str = "";
                String profilerName = profiler$result.profilerName;
                if (!"unspecified".equals(profilerName)) {
                    str = str + "[0] ";
                }
                str = profilerName.isEmpty() ? str + "ROOT " : str + profilerName + ' ';
                fontRenderer.func_175063_a(str, (float)(cx - 160), (float)(cy - 80 - 16), 0xFFFFFF);
                str = decimalformat.format(profiler$result.totalUsePercentage) + "%";
                fontRenderer.func_175063_a(str, (float)(cx + 160 - fontRenderer.func_78256_a(str)), (float)(cy - 80 - 16), 0xFFFFFF);
                for (int k2 = 0; k2 < size; ++k2) {
                    Profiler1122.Result profiler$result2 = list.get(k2);
                    StringBuilder stringbuilder = new StringBuilder();
                    String profilerName1 = profiler$result2.profilerName;
                    if ("unspecified".equals(profilerName1)) {
                        stringbuilder.append("[?] ");
                    } else {
                        stringbuilder.append("[").append(k2 + 1).append("] ");
                    }
                    String s1 = stringbuilder.append(profilerName1).toString();
                    int color = profiler$result2.getColor();
                    fontRenderer.func_175063_a(s1, (float)(cx - 160), (float)(cy + 80 + k2 * 8 + 20), color);
                    s1 = decimalformat.format(profiler$result2.usePercentage) + "%";
                    fontRenderer.func_175063_a(s1, (float)(cx + 160 - 50 - fontRenderer.func_78256_a(s1)), (float)(cy + 80 + k2 * 8 + 20), color);
                    s1 = decimalformat.format(profiler$result2.totalUsePercentage) + "%";
                    fontRenderer.func_175063_a(s1, (float)(cx + 160 - fontRenderer.func_78256_a(s1)), (float)(cy + 80 + k2 * 8 + 20), color);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        GameSettings gameSettings = minecraft.field_71474_y;
        if (!gameSettings.field_74330_P || !gameSettings.field_74329_Q || gameSettings.field_74319_N) {
            return;
        }
        ClientPlayerEntity player = minecraft.field_71439_g;
        if (player == null) {
            return;
        }
        World world = player.field_70170_p;
        if (world == null) {
            return;
        }
        ActiveRenderInfo activeRenderInfo = minecraft.field_71460_t.func_215316_n();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.lineWidth((float)Math.max(2.5f, (float)minecraft.field_195558_d.func_198109_k() / 1920.0f * 2.5f));
        GlStateManager.disableTexture();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.matrixMode((int)5889);
        GlStateManager.pushMatrix();
        GlStateManager.scalef((float)1.0f, (float)1.0f, (float)0.999f);
        Vec3d projectedView = activeRenderInfo.func_216785_c();
        double d0 = projectedView.field_72450_a;
        double d1 = projectedView.field_72448_b;
        double d2 = projectedView.field_72449_c;
        for (VoxelShape voxelShape : world.func_223438_b((Entity)player, new AxisAlignedBB(player.func_180425_c()).func_186662_g(3.0)).collect(Collectors.toList())) {
            WorldRenderer.func_195463_b((VoxelShape)voxelShape, (double)(-d0), (double)(-d1), (double)(-d2), (float)0.0f, (float)1.0f, (float)1.0f, (float)0.4f);
        }
        for (VoxelShape voxelShape : world.func_223438_b((Entity)player, new AxisAlignedBB(player.func_180425_c())).collect(Collectors.toList())) {
            WorldRenderer.func_195463_b((VoxelShape)voxelShape, (double)(-d0), (double)(-d1), (double)(-d2), (float)1.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        }
        GlStateManager.popMatrix();
        GlStateManager.matrixMode((int)5888);
        GlStateManager.depthMask((boolean)true);
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
    }

    @SubscribeEvent
    public static void drawBlockHighlightEvent(DrawBlockHighlightEvent event) {
        MeshGeneratorType meshGeneratorType;
        IsSmoothable isSmoothable;
        if (!Config.renderSmoothTerrain && !Config.renderSmoothLeaves) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        RayTraceResult rayTraceResult = event.getTarget();
        if (rayTraceResult == null || rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
        World world = player.field_70170_p;
        if (world == null) {
            return;
        }
        BlockPos pos = blockRayTraceResult.func_216350_a();
        BlockState blockState = world.func_180495_p(pos);
        if (blockState.func_185904_a() == Material.field_151579_a || !world.func_175723_af().func_177746_a(pos)) {
            return;
        }
        if (Config.renderSmoothTerrain && blockState.nocubes_isTerrainSmoothable) {
            isSmoothable = IsSmoothable.TERRAIN_SMOOTHABLE;
            meshGeneratorType = Config.terrainMeshGenerator;
            event.setCanceled(true);
        } else if (Config.renderSmoothLeaves && blockState.nocubes_isLeavesSmoothable) {
            isSmoothable = IsSmoothable.LEAVES_SMOOTHABLE;
            meshGeneratorType = Config.leavesMeshGenerator;
            event.setCanceled(true);
        } else {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_178969_c(-TileEntityRendererDispatcher.field_147554_b, -TileEntityRendererDispatcher.field_147555_c, -TileEntityRendererDispatcher.field_147552_d);
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.lineWidth((float)3.0f);
        GlStateManager.disableTexture();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        try (FaceList faces = MeshDispatcher.generateBlockMeshOffset(pos, (IBlockReader)world, isSmoothable, meshGeneratorType);){
            int facesSize = faces.size();
            for (int i = 0; i < facesSize; ++i) {
                try (Face face = (Face)faces.get(i);
                     Vec3 v0 = face.getVertex0();
                     Vec3 v1 = face.getVertex1();
                     Vec3 v2 = face.getVertex2();
                     Vec3 v3 = face.getVertex3();){
                    double v0x = v0.x;
                    double v0y = v0.y;
                    double v0z = v0.z;
                    bufferbuilder.func_181662_b(v0x, v0y, v0z).func_181666_a(0.0f, 0.0f, 0.0f, 0.0f).func_181675_d();
                    bufferbuilder.func_181662_b(v1.x, v1.y, v1.z).func_181666_a(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                    bufferbuilder.func_181662_b(v2.x, v2.y, v2.z).func_181666_a(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                    bufferbuilder.func_181662_b(v3.x, v3.y, v3.z).func_181666_a(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                    bufferbuilder.func_181662_b(v0x, v0y, v0z).func_181666_a(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                    continue;
                }
            }
        }
        tessellator.func_78381_a();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
        bufferbuilder.func_178969_c(0.0, 0.0, 0.0);
    }

    @SubscribeEvent
    public static void onPlayerSPPushOutOfBlocksEvent(PlayerSPPushOutOfBlocksEvent event) {
        if (Config.terrainCollisions) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onInitGuiEvent(GuiScreenEvent.InitGuiEvent event) {
        Screen gui = event.getGui();
        if (gui instanceof IngameMenuScreen) {
            int maxY = 0;
            for (Widget button : event.getWidgetList()) {
                maxY = Math.max(button.y, maxY);
            }
            event.addWidget((Widget)new IngameModListButton(gui, maxY + 24));
        }
    }

    static {
        ClientRegistry.registerKeyBinding((KeyBinding)toggleRenderSmoothTerrain);
        ClientRegistry.registerKeyBinding((KeyBinding)toggleRenderSmoothLeaves);
        ClientRegistry.registerKeyBinding((KeyBinding)toggleProfilers);
        ClientRegistry.registerKeyBinding((KeyBinding)toggleTerrainSmoothableBlockState);
        ClientRegistry.registerKeyBinding((KeyBinding)toggleLeavesSmoothableBlockState);
        ClientRegistry.registerKeyBinding((KeyBinding)toggleTerrainCollisions);
    }
}

