/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.parser;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserFactory;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.util.Span;
import opennlp.uima.parser.ParserModelResource;
import opennlp.uima.util.AnnotatorUtil;
import opennlp.uima.util.ContainingConstraint;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class Parser
extends CasAnnotator_ImplBase {
    public static final String PARSE_TYPE_PARAMETER = "opennlp.uima.ParseType";
    public static final String TYPE_FEATURE_PARAMETER = "opennlp.uima.TypeFeature";
    public static final String CHILDREN_FEATURE_PARAMETER = "opennlp.uima.ChildrenFeature";
    public static final String PROBABILITY_FEATURE_PARAMETER = "opennlp.uima.ProbabilityFeature";
    protected UimaContext context;
    protected Logger mLogger;
    protected opennlp.tools.parser.Parser mParser;
    private Type mSentenceType;
    private Type mTokenType;
    private Type mParseType;
    private Feature mTypeFeature;
    private Feature childrenFeature;
    private Feature probabilityFeature;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        ParserModel model;
        super.initialize(context);
        this.context = context;
        this.mLogger = context.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the OpenNLP Parser.");
        }
        try {
            ParserModelResource modelResource = (ParserModelResource)context.getResourceObject(UimaUtil.MODEL_PARAMETER);
            model = modelResource.getModel();
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        this.mParser = ParserFactory.create(model);
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        this.mSentenceType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, UimaUtil.SENTENCE_TYPE_PARAMETER);
        this.mTokenType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, "opennlp.uima.TokenType");
        this.mParseType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, PARSE_TYPE_PARAMETER);
        this.mTypeFeature = AnnotatorUtil.getRequiredFeatureParameter(this.context, this.mParseType, TYPE_FEATURE_PARAMETER, "uima.cas.String");
        this.childrenFeature = AnnotatorUtil.getRequiredFeatureParameter(this.context, this.mParseType, CHILDREN_FEATURE_PARAMETER, "uima.cas.FSArray");
        this.probabilityFeature = AnnotatorUtil.getOptionalFeatureParameter(this.context, this.mParseType, PROBABILITY_FEATURE_PARAMETER, "uima.cas.Double");
    }

    public void process(CAS cas) {
        AnnotationIndex sentences = cas.getAnnotationIndex(this.mSentenceType);
        for (AnnotationFS sentence : sentences) {
            this.process(cas, sentence);
        }
    }

    protected void process(CAS cas, AnnotationFS sentenceAnnotation) {
        AnnotationIndex allTokens = cas.getAnnotationIndex(this.mTokenType);
        ContainingConstraint containingConstraint = new ContainingConstraint(sentenceAnnotation);
        String sentence = sentenceAnnotation.getCoveredText();
        FSIterator containingTokens = cas.createFilteredIterator(allTokens.iterator(), (FSMatchConstraint)containingConstraint);
        LinkedList<Span> tokenSpans = new LinkedList<Span>();
        while (containingTokens.hasNext()) {
            AnnotationFS token = (AnnotationFS)containingTokens.next();
            tokenSpans.add(new Span(token.getBegin() - sentenceAnnotation.getBegin(), token.getEnd() - sentenceAnnotation.getBegin()));
        }
        ParseConverter converter = new ParseConverter(sentence, tokenSpans.toArray(new Span[tokenSpans.size()]));
        Parse unparsedTree = converter.getParseForTagger();
        if (unparsedTree.getChildCount() > 0) {
            Parse parse = this.mParser.parse(unparsedTree);
            parse = converter.transformParseFromTagger(parse);
            if (this.mLogger.isLoggable(Level.INFO)) {
                StringBuffer parseString = new StringBuffer();
                parse.show(parseString);
                this.mLogger.log(Level.INFO, parseString.toString());
            }
            this.createAnnotation(cas, sentenceAnnotation.getBegin(), parse);
        }
    }

    protected AnnotationFS createAnnotation(CAS cas, int offset, Parse parse) {
        Parse[] parseChildren = parse.getChildren();
        AnnotationFS[] parseChildAnnotations = new AnnotationFS[parseChildren.length];
        for (int i = 0; i < parseChildren.length; ++i) {
            parseChildAnnotations[i] = this.createAnnotation(cas, offset, parseChildren[i]);
        }
        AnnotationFS parseAnnotation = cas.createAnnotation(this.mParseType, offset + parse.getSpan().getStart(), offset + parse.getSpan().getEnd());
        parseAnnotation.setStringValue(this.mTypeFeature, parse.getType());
        if (this.probabilityFeature != null) {
            parseAnnotation.setDoubleValue(this.probabilityFeature, parse.getProb());
        }
        ArrayFS childrenArray = cas.createArrayFS(parseChildAnnotations.length);
        childrenArray.copyFromArray((FeatureStructure[])parseChildAnnotations, 0, 0, parseChildAnnotations.length);
        parseAnnotation.setFeatureValue(this.childrenFeature, (FeatureStructure)childrenArray);
        cas.getIndexRepository().addFS((FeatureStructure)parseAnnotation);
        return parseAnnotation;
    }

    public void destroy() {
        this.mParser = null;
    }

    private static class ParseConverter {
        private final String mSentence;
        private Map<Integer, Integer> mIndexMap = new HashMap<Integer, Integer>();
        private Parse mParseForTagger;

        public ParseConverter(String sentence, Span[] tokens) {
            this.mSentence = sentence;
            StringBuilder sentenceStringBuilder = new StringBuilder();
            String[] tokenList = new String[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                String escapedToken;
                String tokenString = tokens[i].getCoveredText(sentence).toString();
                tokenList[i] = escapedToken = ParseConverter.escape(tokenString);
                int escapedStart = sentenceStringBuilder.length();
                int start = tokens[i].getStart();
                this.mIndexMap.put(escapedStart, start);
                int escapedEnd = escapedStart + escapedToken.length();
                int end = tokens[i].getEnd();
                this.mIndexMap.put(escapedEnd, end);
                sentenceStringBuilder.append(tokenList[i]);
                sentenceStringBuilder.append(' ');
            }
            if (sentenceStringBuilder.length() > 0) {
                sentenceStringBuilder.setLength(sentenceStringBuilder.length() - 1);
            }
            String tokenizedSentence = sentenceStringBuilder.toString();
            this.mParseForTagger = new Parse(tokenizedSentence, new Span(0, tokenizedSentence.length()), "INC", 1.0, null);
            int start = 0;
            for (String token : tokenList) {
                this.mParseForTagger.insert(new Parse(tokenizedSentence, new Span(start, start + token.length()), "TK", 0.0, 0));
                start += token.length() + 1;
            }
        }

        private static String escape(String text) {
            return text;
        }

        Parse getParseForTagger() {
            return this.mParseForTagger;
        }

        Parse transformParseFromTagger(Parse parseFromTagger) {
            Parse[] parseFromTaggerChildrens;
            int start = parseFromTagger.getSpan().getStart();
            int end = parseFromTagger.getSpan().getEnd();
            Parse transformedParse = new Parse(this.mSentence, new Span(this.mIndexMap.get(start), (int)this.mIndexMap.get(end)), parseFromTagger.getType(), parseFromTagger.getProb(), parseFromTagger.getHeadIndex());
            for (Parse child : parseFromTaggerChildrens = parseFromTagger.getChildren()) {
                transformedParse.insert(this.transformParseFromTagger(child));
            }
            return transformedParse;
        }
    }
}

