/*
 * Decompiled with CFR 0.152.
 */
package opennlp.morfologik.cmdline.builder;

import java.io.File;
import java.nio.file.Path;
import morfologik.stemming.DictionaryMetadata;
import opennlp.morfologik.builder.MorfologikDictionayBuilder;
import opennlp.morfologik.cmdline.builder.MorfologikDictionaryBuilderParams;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;

public class MorfologikDictionaryBuilderTool
extends BasicCmdLineTool {
    @Override
    public String getShortDescription() {
        return "builds a binary POS Dictionary using Morfologik";
    }

    @Override
    public String getHelp() {
        return this.getBasicHelp((Class<?>)Params.class);
    }

    @Override
    public void run(String[] args) {
        Params params = this.validateAndParseParams(args, Params.class);
        File dictInFile = params.getInputFile();
        CmdLineUtil.checkInputFile("dictionary input file", dictInFile);
        Path metadataPath = DictionaryMetadata.getExpectedMetadataLocation(dictInFile.toPath());
        CmdLineUtil.checkInputFile("dictionary metadata (.info) input file", metadataPath.toFile());
        MorfologikDictionayBuilder builder = new MorfologikDictionayBuilder();
        try {
            builder.build(dictInFile.toPath(), params.getOverwrite(), params.getValidate(), params.getAcceptBOM(), params.getAcceptCR(), params.getIgnoreEmpty());
        }
        catch (Exception e) {
            throw new TerminateToolException(-1, "Error while creating Morfologik POS Dictionay: " + e.getMessage(), e);
        }
    }

    static interface Params
    extends MorfologikDictionaryBuilderParams {
    }
}

